/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.history;

import android.util.SparseIntArray;
import android.view.View;
import android.widget.BaseAdapter;
import android.widget.Toast;
import android.widget.WrapperListAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import oz.main.MainFrameView;
import oz.main.OZStorage;
import oz.util.NListView;
import oz.viewer.ui.history.HistoryNavigationCompData;
import oz.viewer.ui.history.HistoryNavigationData;
import oz.viewer.ui.history.HistoryNavigationManager$1;
import oz.viewer.ui.history.HistoryNavigationManager$ToastHandler;
import oz.viewer.ui.history.HistoryNavigationManager$ToastTextView;
import oz.viewer.ui.history.HistoryNavigationRevisionData;
import oz.viewer.ui.history.adapter.Adapter;

public class HistoryNavigationManager {
    private MainFrameView mMainFrame;
    private ArrayList mHistories;
    private ArrayList mHistoriesDetail;
    private int mSelectedRevision;
    private int mSelectedDetail;
    private NListView mList;
    private boolean mIsRevertMode;
    private Toast mToast;
    private HistoryNavigationManager$ToastHandler mToastHandler;

    public HistoryNavigationManager(MainFrameView mainFrameView) {
        this.mMainFrame = mainFrameView;
        this.initToast();
        this.mHistories = new ArrayList();
        this.mHistoriesDetail = new ArrayList();
        this.mSelectedRevision = -1;
        this.mSelectedDetail = -1;
    }

    public void setData(HistoryNavigationManager historyNavigationManager) {
        this.mHistories.clear();
        this.mHistories.addAll(historyNavigationManager.mHistories);
        this.mHistoriesDetail.clear();
        this.mHistoriesDetail.addAll(historyNavigationManager.mHistoriesDetail);
    }

    public void dismiss() {
        String string;
        Object object;
        if (this.getListView() != null) {
            for (int j = 0; j < this.getListView().getSize(); ++j) {
                object = (Adapter)this.getListView().getListView(j).getAdapter();
                ((Adapter)((Object)object)).dismiss();
            }
        }
        if (((File)(object = new File(string = OZStorage.tmpCacheDir + "/OZVoiceRecorder_history.m4a"))).exists()) {
            ((File)object).delete();
        }
    }

    public MainFrameView getMainFrameView() {
        return this.mMainFrame;
    }

    public int getRevisionSize() {
        return this.mHistories.size();
    }

    public void addRevision(String string, String string2, long l, long l2, String string3) {
        HistoryNavigationRevisionData historyNavigationRevisionData = new HistoryNavigationRevisionData();
        historyNavigationRevisionData.userID = string != null ? string : "";
        historyNavigationRevisionData.userName = string2 != null ? string2 : "";
        historyNavigationRevisionData.time = l;
        historyNavigationRevisionData.saveTime = l2;
        historyNavigationRevisionData.address = string3;
        this.addRevision(historyNavigationRevisionData);
    }

    public void addRevision(HistoryNavigationRevisionData historyNavigationRevisionData) {
        HistoryNavigationData historyNavigationData = new HistoryNavigationData(historyNavigationRevisionData);
        this.addRevision(historyNavigationData);
    }

    public void addRevision(HistoryNavigationData historyNavigationData) {
        this.mHistories.add(historyNavigationData);
        for (int j = 0; j < this.getRevisionSize(); ++j) {
            this.getRevision((int)j).getRevision().version = this.getRevisionSize() - j;
        }
    }

    public HistoryNavigationData getRevision(int n) {
        return (HistoryNavigationData)this.mHistories.get(n);
    }

    public HistoryNavigationData findRevision(int n) {
        HistoryNavigationData historyNavigationData = null;
        for (int j = 0; j < this.getRevisionSize(); ++j) {
            HistoryNavigationData historyNavigationData2 = this.getRevision(j);
            if (historyNavigationData2 == null || historyNavigationData2.getRevisionVersion() != n) continue;
            historyNavigationData = historyNavigationData2;
            break;
        }
        return historyNavigationData;
    }

    public void addItem(int n, int n2, int n3, int n4, int n5, int n6, String string, String string2, String string3, boolean bl, long l) {
        HistoryNavigationCompData historyNavigationCompData = new HistoryNavigationCompData(n4, n6);
        historyNavigationCompData.id = n;
        historyNavigationCompData.compType = n2;
        historyNavigationCompData.docIndex = n3;
        historyNavigationCompData.version = n5;
        historyNavigationCompData.name = string != null ? string : "";
        historyNavigationCompData.value = string2 != null ? string2 : "";
        historyNavigationCompData.srcValue = string3 != null ? string3 : "";
        historyNavigationCompData.setSelectedValue(bl);
        historyNavigationCompData.compptr = l;
        this.addItem(historyNavigationCompData);
        this.update(historyNavigationCompData);
    }

    public void addItem(HistoryNavigationCompData historyNavigationCompData) {
        this.mHistoriesDetail.add(historyNavigationCompData);
    }

    public static ArrayList getItemUniqueZOrders(ArrayList arrayList) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int j = 0; j < arrayList.size(); ++j) {
            int n;
            HistoryNavigationCompData historyNavigationCompData = (HistoryNavigationCompData)arrayList.get(j);
            if (historyNavigationCompData == null || !hashSet.add(n = historyNavigationCompData.getUniqueCompId())) continue;
            arrayList2.add(n);
        }
        return arrayList2;
    }

    public SparseIntArray getItemPages() {
        return HistoryNavigationManager.getItemPages(this.mHistoriesDetail);
    }

    public static SparseIntArray getItemPages(ArrayList arrayList) {
        SparseIntArray sparseIntArray = new SparseIntArray();
        for (int j = 0; j < arrayList.size(); ++j) {
            HistoryNavigationCompData historyNavigationCompData = (HistoryNavigationCompData)arrayList.get(j);
            if (historyNavigationCompData == null) continue;
            sparseIntArray.put(historyNavigationCompData.getPage(), sparseIntArray.get(historyNavigationCompData.getPage(), 0) + 1);
        }
        return sparseIntArray;
    }

    public ArrayList findItemsByPage(int n) {
        return HistoryNavigationManager.findItemsByPage(this.mHistoriesDetail, n);
    }

    public static ArrayList findItemsByPage(ArrayList arrayList, int n) {
        ArrayList<HistoryNavigationCompData> arrayList2 = new ArrayList<HistoryNavigationCompData>();
        for (int j = 0; j < arrayList.size(); ++j) {
            HistoryNavigationCompData historyNavigationCompData = (HistoryNavigationCompData)arrayList.get(j);
            if (historyNavigationCompData == null || n != historyNavigationCompData.getPage()) continue;
            arrayList2.add(historyNavigationCompData);
        }
        return arrayList2;
    }

    public static ArrayList findItemsByUniqueZOrder(ArrayList arrayList, int n) {
        ArrayList<HistoryNavigationCompData> arrayList2 = new ArrayList<HistoryNavigationCompData>();
        for (int j = 0; j < arrayList.size(); ++j) {
            HistoryNavigationCompData historyNavigationCompData = (HistoryNavigationCompData)arrayList.get(j);
            if (historyNavigationCompData == null || n != historyNavigationCompData.getUniqueCompId()) continue;
            arrayList2.add(historyNavigationCompData);
        }
        return arrayList2;
    }

    public static int findFirstVersion(ArrayList arrayList) {
        int n = ((HistoryNavigationCompData)arrayList.get((int)0)).version;
        for (int j = 1; j < arrayList.size(); ++j) {
            if (n <= ((HistoryNavigationCompData)arrayList.get((int)j)).version) continue;
            n = ((HistoryNavigationCompData)arrayList.get((int)j)).version;
        }
        return n;
    }

    public int getItemSize() {
        return this.mHistoriesDetail.size();
    }

    public HistoryNavigationCompData getItem(int n) {
        return (HistoryNavigationCompData)this.mHistoriesDetail.get(n);
    }

    public ArrayList getItems() {
        return this.mHistoriesDetail;
    }

    public void ForceUpdate() {
        int n;
        for (n = 0; n < this.getRevisionSize(); ++n) {
            this.getRevision(n).clearItem();
        }
        for (n = 0; n < this.getItemSize(); ++n) {
            this.update(this.getItem(n));
        }
    }

    private void update(HistoryNavigationCompData historyNavigationCompData) {
        HistoryNavigationData historyNavigationData;
        if (historyNavigationCompData != null && (historyNavigationData = this.findRevision(historyNavigationCompData.version)) != null) {
            historyNavigationData.addItem(historyNavigationCompData);
        }
    }

    public int getSelectedRevision() {
        if (this.mSelectedRevision < 0 && !this.mHistories.isEmpty()) {
            return 0;
        }
        return this.mSelectedRevision;
    }

    public void setSelectedRevision(int n) {
        this.mSelectedRevision = n;
    }

    public void setSelectedRevision(HistoryNavigationData historyNavigationData) {
        for (int j = 0; j < this.getRevisionSize(); ++j) {
            if (!this.getRevision(j).equals(historyNavigationData)) continue;
            this.setSelectedRevision(j);
            break;
        }
    }

    public int getSelectedItem() {
        return this.mSelectedDetail;
    }

    public void setSelectedItem(int n) {
        this.mSelectedDetail = n;
    }

    public void setSelectedItem(HistoryNavigationCompData historyNavigationCompData) {
        for (int j = 0; j < this.getItemSize(); ++j) {
            if (!this.getItem(j).equals(historyNavigationCompData)) continue;
            this.setSelectedItem(j);
            break;
        }
    }

    public NListView getListView() {
        return this.mList;
    }

    public void setListView(NListView nListView) {
        this.mList = nListView;
    }

    public void updateListView() {
        if (this.mList != null) {
            for (int j = 0; j < this.mList.getSize(); ++j) {
                this.updateListView(j);
            }
        }
    }

    public void updateListView(int n) {
        if (this.mList != null && n < this.mList.getSize() && n >= 0) {
            if (this.mList.getListView(n).getAdapter() instanceof WrapperListAdapter) {
                try {
                    ((BaseAdapter)((WrapperListAdapter)this.mList.getListView(n).getAdapter()).getWrappedAdapter()).notifyDataSetChanged();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.mList.getListView(n).getAdapter() instanceof BaseAdapter) {
                ((BaseAdapter)this.mList.getListView(n).getAdapter()).notifyDataSetChanged();
            }
        }
    }

    public boolean isRevertMode() {
        return this.mIsRevertMode;
    }

    public void setRevertMode(boolean bl) {
        if (this.mIsRevertMode != bl) {
            this.mIsRevertMode = bl;
        }
    }

    public void clearRevert() {
        for (int j = 0; j < this.mHistoriesDetail.size(); ++j) {
            ((HistoryNavigationCompData)this.mHistoriesDetail.get((int)j)).selectedValue2 = ((HistoryNavigationCompData)this.mHistoriesDetail.get((int)j)).selectedValue;
        }
    }

    public void setRevert() {
        for (int j = 0; j < this.mHistoriesDetail.size(); ++j) {
            ((HistoryNavigationCompData)this.mHistoriesDetail.get((int)j)).selectedValue = ((HistoryNavigationCompData)this.mHistoriesDetail.get((int)j)).selectedValue2;
        }
    }

    public ArrayList getRevertData() {
        HashMap<Integer, HistoryNavigationCompData> hashMap = new HashMap<Integer, HistoryNavigationCompData>();
        ArrayList<HistoryNavigationCompData> arrayList = new ArrayList<HistoryNavigationCompData>();
        for (int j = 0; j < this.mHistoriesDetail.size(); ++j) {
            Integer n;
            HistoryNavigationCompData historyNavigationCompData = (HistoryNavigationCompData)this.mHistoriesDetail.get(j);
            if (!historyNavigationCompData.selectedValue || historyNavigationCompData.selectedValueOriginal == historyNavigationCompData.selectedValue || hashMap.containsKey(n = Integer.valueOf(historyNavigationCompData.getUniqueCompId()))) continue;
            hashMap.put(n, historyNavigationCompData);
            arrayList.add(historyNavigationCompData);
        }
        Collections.sort(arrayList, new HistoryNavigationManager$1(this));
        return arrayList;
    }

    private void initToast() {
        this.mToastHandler = new HistoryNavigationManager$ToastHandler(this, null);
        this.mToast = new Toast(this.mMainFrame.getContext());
        this.mToast.setDuration(10000);
        this.mToast.setGravity(17, 0, 0);
        this.mToast.setView((View)new HistoryNavigationManager$ToastTextView(this, this.mMainFrame.getContext()));
    }

    public void reqestToast(String string) {
        ((HistoryNavigationManager$ToastTextView)this.mToast.getView()).setText(string);
        this.mToast.show();
        this.requestToastCancel();
    }

    private void requestToastCancel() {
        this.mToastHandler.removeMessages(0);
        this.mToastHandler.sendEmptyMessageDelayed(0, 1500L);
    }

    static /* synthetic */ Toast access$100(HistoryNavigationManager historyNavigationManager) {
        return historyNavigationManager.mToast;
    }
}

