/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.dlg.OZLinearLayout;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.ASearchManager$1;
import oz.viewer.ui.main.overlay.ASearchManager$2;
import oz.viewer.ui.main.overlay.ASearchManager$SearchOnClickListener;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.UserCloseAbleOZOverlayView;

public class ASearchManager
extends UserCloseAbleOZOverlayView {
    static final int FLAG_DOWN = 1;
    static final int FLAG_WHOLEWORD = 2;
    static final int FLAG_MATCHCASE = 4;
    static final int FLAG_FINDNEXT = 8;
    private static final String CLOSE_BTN_PATH = "resource/toolbar_close@2x.png";
    private static final String PREV_BTN_PATH = "resource/toolbar_prev@2x.png";
    private static final String NEXT_BTN_PATH = "resource/toolbar_next@2x.png";
    private static final String SETTING_BTN_PATH = "resource/toolbar_setting@2x.png";
    private static final int CLOSE_BTN_ID = 1;
    private static final int PREV_BTN_ID = 2;
    private static final int NEXT_BTN_ID = 3;
    private static final int SETTING_BTN_ID = 4;
    private static final int WHOLEWORD_BTN_ID = 5;
    private static final int MATCHCASE_BTN_ID = 6;
    private static final int SETTINGCLOSE_BTN_ID = 7;
    private LinearLayout mView;
    private EditText mFindEditText;
    private ASearchManager$SearchOnClickListener mOnButtonClickListener;
    private int mStatus;
    private Dialog mSettingDialog;

    public ASearchManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 5);
        this.setHideVisibility(8);
        this.mOnButtonClickListener = new ASearchManager$SearchOnClickListener(this, null);
        this.initView();
    }

    void addStatus(int n) {
        this.mStatus |= n;
    }

    void removeStatus(int n) {
        this.mStatus &= ~n;
    }

    private void setStatus(int n) {
        this.mStatus = n;
    }

    public boolean isStatus(int n) {
        return (this.mStatus & n) == n;
    }

    public int getStatus() {
        return this.mStatus;
    }

    private void initView() {
        this.mView = new LinearLayout(this.getContext());
        this.mView.setOrientation(0);
        this.mView.setVisibility(8);
        this.mView.setGravity(19);
        this.mView.setOnTouchListener((View.OnTouchListener)new ASearchManager$1(this));
        this.mView.setPadding(AOverlayUtil.DpToPx(15), AOverlayUtil.getDP5(), AOverlayUtil.DpToPx(15), AOverlayUtil.getDP5());
        this.mView.setBackgroundColor(Color.argb((int)255, (int)217, (int)217, (int)217));
        this.mView.addView((View)this.getCloseButton());
        this.mFindEditText = this.getEditText();
        OZLinearLayout oZLinearLayout = new OZLinearLayout(this.getContext());
        oZLinearLayout.setFocusable(true);
        oZLinearLayout.setFocusableInTouchMode(true);
        oZLinearLayout.setOrientation(0);
        oZLinearLayout.addView((View)this.mFindEditText);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
        layoutParams.leftMargin = AOverlayUtil.getDP10();
        layoutParams.rightMargin = AOverlayUtil.getDP10();
        oZLinearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mView.addView((View)oZLinearLayout);
        this.mView.addView((View)this.getPrevButton());
        this.mView.addView((View)this.getNextButton());
        this.mView.addView((View)this.getSettingButton());
    }

    private String getFindWord() {
        return this.mFindEditText.getText().toString();
    }

    void setFindWord(String string) {
        this.mFindEditText.setText((CharSequence)string);
    }

    private static ImageButton getImageButton(Context context, int n, String string, float f2, View.OnClickListener onClickListener) {
        return ASearchManager.getImageButton(context, n, string, 255, f2, onClickListener);
    }

    private static ImageButton getImageButton(Context context, int n, String string, int n2, float f2, View.OnClickListener onClickListener) {
        ImageButton imageButton = AOverlayUtil.createImageButton(context, n, string, n2, onClickListener);
        ASearchManager.setImageButtonDefault(imageButton, AOverlayUtil.getAssetIcon(context, string), f2);
        return imageButton;
    }

    private static void setImageButtonDefault(ImageButton imageButton, Drawable drawable2, float f2) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, 0);
        layoutParams.leftMargin = AOverlayUtil.getDP5();
        layoutParams.rightMargin = AOverlayUtil.getDP5();
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        AOverlayUtil.setImageButtonSize(imageButton, f2);
    }

    private ImageButton getNextButton() {
        return ASearchManager.getImageButton(this.getContext(), 3, NEXT_BTN_PATH, 200, 0.8f, this.mOnButtonClickListener);
    }

    private ImageButton getPrevButton() {
        return ASearchManager.getImageButton(this.getContext(), 2, PREV_BTN_PATH, 200, 0.8f, this.mOnButtonClickListener);
    }

    private ImageButton getSettingButton() {
        return ASearchManager.getImageButton(this.getContext(), 4, SETTING_BTN_PATH, 220, 0.8f, this.mOnButtonClickListener);
    }

    private ImageButton getCloseButton() {
        return ASearchManager.getImageButton(this.getContext(), 1, CLOSE_BTN_PATH, 0.75f, this.mOnButtonClickListener);
    }

    private void hideKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(this.mFindEditText.getWindowToken(), 0);
    }

    private EditText getEditText() {
        EditText editText = new EditText(this.getContext());
        editText.setBackgroundDrawable(null);
        editText.setSingleLine(true);
        editText.setImeOptions(3);
        editText.setTextColor(-16777216);
        editText.setOnEditorActionListener((TextView.OnEditorActionListener)new ASearchManager$2(this));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
        editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return editText;
    }

    private void showSettingDialog() {
        CheckBox checkBox;
        if (this.mSettingDialog == null) {
            this.mSettingDialog = new Dialog(this.getContext());
            this.mSettingDialog.requestWindowFeature(1);
            this.mSettingDialog.addContentView((View)this.getSettingDialogChildView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        }
        if ((checkBox = (CheckBox)this.mSettingDialog.findViewById(5)) != null) {
            checkBox.setChecked(this.isStatus(2));
        }
        if ((checkBox = (CheckBox)this.mSettingDialog.findViewById(6)) != null) {
            checkBox.setChecked(this.isStatus(4));
        }
        if (!this.mSettingDialog.isShowing()) {
            this.mSettingDialog.show();
        }
    }

    private ViewGroup getSettingDialogChildView() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        TextView textView = new TextView(this.getContext());
        textView.setId(7);
        textView.setTextSize(25.0f);
        textView.setTextColor(-16777216);
        textView.setText((CharSequence)OZAndroidResource.getResource("close.label"));
        textView.setOnClickListener((View.OnClickListener)this.mOnButtonClickListener);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setBackgroundColor(Color.rgb((int)190, (int)190, (int)190));
        linearLayout2.setPadding(AOverlayUtil.getDP10(), AOverlayUtil.getDP5(), AOverlayUtil.getDP10(), AOverlayUtil.getDP5());
        linearLayout2.addView((View)textView);
        linearLayout.addView((View)linearLayout2);
        LinearLayout linearLayout3 = new LinearLayout(this.getContext());
        linearLayout3.setPadding(linearLayout3.getPaddingLeft(), 0, linearLayout3.getPaddingRight(), 0);
        linearLayout3.setBackgroundColor(-1);
        linearLayout3.setOrientation(1);
        int n = AOverlayUtil.DpToPx(30);
        CheckBox checkBox = new CheckBox(this.getContext());
        checkBox.setId(5);
        checkBox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this.mOnButtonClickListener);
        checkBox.setPadding(checkBox.getPaddingLeft(), 0, checkBox.getPaddingRight(), 0);
        checkBox.setTextSize(25.0f);
        checkBox.setTextColor(-16777216);
        checkBox.setText((CharSequence)OZAndroidResource.getResource("word.unit.text"));
        LinearLayout linearLayout4 = new LinearLayout(this.getContext());
        linearLayout4.setPadding(n, n, n * 2, 0);
        linearLayout4.addView((View)checkBox);
        linearLayout3.addView((View)linearLayout4);
        CheckBox checkBox2 = new CheckBox(this.getContext());
        checkBox2.setId(6);
        checkBox2.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this.mOnButtonClickListener);
        checkBox2.setPadding(checkBox2.getPaddingLeft(), 0, checkBox2.getPaddingRight(), 0);
        checkBox2.setTextSize(25.0f);
        checkBox2.setTextColor(-16777216);
        checkBox2.setText((CharSequence)OZAndroidResource.getResource("case.sensetive.text"));
        linearLayout4 = new LinearLayout(this.getContext());
        linearLayout4.setPadding(n, n / 2, n * 2, n);
        linearLayout4.addView((View)checkBox2);
        linearLayout3.addView((View)linearLayout4);
        linearLayout.addView((View)linearLayout3);
        return linearLayout;
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)overlayLayout.findLayout(21120);
        frameLayout.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void hide() {
        super.hide();
        this.hideKeyboard();
        if (this.mSettingDialog != null && this.mSettingDialog.isShowing()) {
            this.mSettingDialog.dismiss();
        }
        this.reset();
    }

    private void reset() {
        this.setStatus(0);
        this.setFindWord("");
    }

    public void search() {
        this.getNativeController().searchText(this.getFindWord(), this.getStatus());
    }

    static /* synthetic */ void access$100(ASearchManager aSearchManager) {
        aSearchManager.hideKeyboard();
    }

    static /* synthetic */ void access$200(ASearchManager aSearchManager) {
        aSearchManager.showSettingDialog();
    }

    static /* synthetic */ Dialog access$300(ASearchManager aSearchManager) {
        return aSearchManager.mSettingDialog;
    }
}

