/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.Locale;
import oz.main.OZStorage;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.ATableView;
import oz.viewer.ui.main.overlay.SidebarStyle;

public class ATableView$ThumbnailView {
    private int selectedStrokeWidth = 8;
    private int selectedMargin = this.selectedStrokeWidth / 2;
    private int selectedColor = -16776961;
    private int markerStrokeWidth = 5;
    private int markerMargin = this.markerStrokeWidth / 2;
    private int markerColor = -65383;
    public static final int THUMBNAIL_PAGENUMBER_ALIGN_CENTER = 0;
    public static final int THUMBNAIL_PAGENUMBER_ALIGN_LEFT = 1;
    private String mReportName;
    private String mPageIndexString;
    private String mPageNumberFormat;
    private int mPageNumberAlignment;
    private Paint mPaint = new Paint(1);
    private float mTextSize;
    private int mPosition;
    private int mPageIndex;
    private Bitmap mBitmap;
    private boolean mIsShow;
    private boolean mHasThumbnailMarker;
    private boolean mIsLoading;
    private boolean mSelected;
    private PointF mSize;
    private PointF mPageSize;
    private PointF mScale;
    private PointF mTableSize;
    private PointF mTableInitSize;
    private Rect mSrcRect;
    private RectF mDstRect;
    private RectF mSelectedDstRect;
    private RectF mMarkerDstRect;
    private PointF mDrawPoint;
    private int mStyleID;
    final /* synthetic */ ATableView this$0;

    public ATableView$ThumbnailView(ATableView aTableView, float f2) {
        this.this$0 = aTableView;
        this.mTextSize = TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)aTableView.getContext().getResources().getDisplayMetrics());
        this.mSize = new PointF();
        this.mPageSize = new PointF();
        this.mScale = new PointF();
        this.mTableSize = new PointF();
        this.mTableInitSize = new PointF();
        this.mIsShow = false;
        this.mHasThumbnailMarker = false;
        this.mSrcRect = new Rect();
        this.mDstRect = new RectF();
        this.mDrawPoint = new PointF();
    }

    public void setPageIndex(int n, int n2, String string, int n3) {
        this.mStyleID = n;
        this.mPageIndex = n2;
        this.mPageNumberFormat = string;
        this.mPageNumberAlignment = n3;
        this.mPageIndexString = this.getPageIndexString();
    }

    public void setDisplayName(int n, String string) {
        this.mPageIndex = n;
        this.mPageIndexString = String.format("%d. %s", this.mPageIndex + 1, string);
    }

    public void setPosition(int n) {
        this.mPosition = n;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public void setShow(boolean bl) {
        this.mIsShow = bl;
    }

    public boolean getShow() {
        return this.mIsShow;
    }

    public void setPageLayout(float f2, float f3) {
        this.mPageSize.x = f2;
        this.mPageSize.y = f3;
    }

    public void setHasThumbnailMarker(boolean bl, int n) {
        this.mHasThumbnailMarker = bl;
        this.markerColor = 0xFF000000 | OZStorage.bgr2rgb(n);
    }

    public void setSelectedPageBorderColor(int n) {
        this.selectedColor = 0xFF000000 | OZStorage.bgr2rgb(n);
    }

    public void setScaleXY(float f2, float f3) {
        this.mScale.x = f2;
        this.mScale.y = f3;
    }

    public void setReportName(String string) {
        this.mReportName = string;
    }

    public int _getTextSize() {
        return (int)(this.mTextSize + 20.0f);
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public int getMargin() {
        return AOverlayUtil.getDP20();
    }

    public int getHeightSize() {
        int n = (int)this.mSize.y;
        if (n <= 0) {
            n = (int)this.mTableInitSize.y;
        }
        int n2 = this.getMargin() + n + this._getTextSize() + this.getMargin();
        return n2;
    }

    public float getScale() {
        return this.mScale.x / this.mPageSize.x;
    }

    public void setLoading(boolean bl) {
        this.mIsLoading = bl;
    }

    public boolean isLoading() {
        return this.mIsLoading;
    }

    public void setTableInitWidth(int n) {
        this.mTableInitSize.x = n;
        this.mTableInitSize.y = (float)((double)n * 0.7);
    }

    private void calcDrawRect(int n, int n2) {
        this.mDrawPoint.x = (int)((double)this.mTableSize.x * 0.7);
        this.mDrawPoint.y = (int)this.mSize.y;
        int n3 = AOverlayUtil.getDP20();
        if (this.mPageSize.x > this.mPageSize.y) {
            float f2 = this.mDrawPoint.x / this.mPageSize.x;
            this.mDrawPoint.y = (int)(this.mPageSize.y * f2);
            n3 = (int)(((float)n2 - this.mDrawPoint.y) / 2.0f);
        } else {
            this.mDrawPoint.x = (int)((double)this.mTableSize.x * 0.7);
            float f3 = this.mDrawPoint.x / this.mPageSize.y;
            this.mDrawPoint.x = (int)(this.mPageSize.x * f3);
        }
        this.mDstRect.left = (int)(((float)n - this.mDrawPoint.x) / 2.0f);
        this.mDstRect.right = (int)(this.mDstRect.left + this.mDrawPoint.x);
        this.mDstRect.top = n3;
        this.mDstRect.bottom = (int)(this.mDstRect.top + this.mDrawPoint.y);
        this.calcSelectedRect();
        this.calcMarkerRect();
    }

    private void calcSelectedRect() {
        if (this.mSelectedDstRect != null) {
            this.mSelectedDstRect.set(this.mDstRect);
            int n = AOverlayUtil.DpToPx(this.selectedMargin);
            if (!this.mHasThumbnailMarker) {
                n = AOverlayUtil.DpToPx(this.markerMargin);
            }
            this.mSelectedDstRect.inset((float)(-n), (float)(-n));
        }
    }

    private void calcMarkerRect() {
        if (this.mMarkerDstRect != null) {
            this.mMarkerDstRect.set(this.mDstRect);
            int n = AOverlayUtil.DpToPx(this.markerMargin);
            this.mMarkerDstRect.inset((float)(-n), (float)(-n));
        }
    }

    public void setTableWidth(int n) {
        this.mTableSize.x = n;
        this.mSize.y = this.mSize.x = (float)((int)((double)n * 0.7));
    }

    public void setTableWidth(int n, int n2, int n3) {
        this.mTableSize.x = n;
        this.mSize.y = this.mSize.x = (float)((int)((double)n * 0.7));
        this.calcDrawRect(n2, n3);
    }

    public int getPosition() {
        return this.mPosition;
    }

    public PointF getPageSize() {
        return this.mPageSize;
    }

    public PointF getTableSize() {
        return this.mTableSize;
    }

    public PointF getSize() {
        return this.mSize;
    }

    public void setSelected(boolean bl) {
        this.mSelected = bl;
    }

    public String getPageIndexString() {
        if (!this.mPageNumberFormat.isEmpty()) {
            return this.mPageNumberFormat;
        }
        return String.format("%d", this.mPageIndex + 1);
    }

    public String getCacheKey() {
        return this.makeKey(this.mReportName, this.mPosition, this.getSize().x, this.getPageSize().x);
    }

    private String makeKey(String string, int n, float f2, float f3) {
        double d2 = f2 / (f3 != 0.0f ? f3 : f2);
        d2 = Math.max(0.2, d2);
        if ((d2 = Double.parseDouble(String.format(Locale.US, "%.1f", d2))) * 10.0 % 2.0 != 0.0) {
            d2 += 0.1;
        }
        String string2 = String.format(Locale.ENGLISH, "%.1f", d2);
        String string3 = "";
        string3 = string != null && !string.isEmpty() ? String.format("%s_%d_%d_%s", string, n, (int)f3, string2) : String.format("%d_%d_%s", n, (int)f3, string2);
        return string3;
    }

    protected void draw(Canvas canvas) {
        if (this.mSize.x > 0.0f && this.mSize.y > 0.0f) {
            SidebarStyle sidebarStyle = this.this$0.getManager().getStyleManager().getDefaultStyle();
            this.mPaint.setTextSize(this.getTextSize());
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(sidebarStyle.getPageNumberColor());
            this.mPaint.setTypeface(sidebarStyle.getPageNumberFont());
            int n = OZStorage.padding_10 + OZStorage.padding_5;
            canvas.save();
            canvas.clipRect(new Rect(n, 0, canvas.getWidth() - n, canvas.getHeight()));
            if (this.mPageNumberAlignment == 1) {
                canvas.drawText(this.mPageIndexString, (float)n, this.mDstRect.top + this.mDrawPoint.y + this.mPaint.getTextSize() * 1.8f, this.mPaint);
            } else {
                canvas.drawText(this.mPageIndexString, (float)canvas.getWidth() / 2.0f - this.mPaint.measureText(this.mPageIndexString) / 2.0f, this.mDstRect.top + this.mDrawPoint.y + this.mPaint.getTextSize() * 1.8f, this.mPaint);
            }
            canvas.restore();
            if (this.mSelected || this.mHasThumbnailMarker) {
                this.mPaint.setStyle(Paint.Style.STROKE);
                if (this.mSelected) {
                    float f2 = AOverlayUtil.DpToPxF(this.selectedStrokeWidth);
                    int n2 = this.selectedStrokeWidth / 2;
                    if (this.mSelectedDstRect == null) {
                        this.mSelectedDstRect = new RectF();
                        this.calcSelectedRect();
                    }
                    if (!this.mHasThumbnailMarker) {
                        n2 = this.markerStrokeWidth / 2;
                        f2 = AOverlayUtil.DpToPxF(this.markerStrokeWidth);
                    }
                    this.mPaint.setColor(this.selectedColor);
                    this.mPaint.setStrokeWidth(f2);
                    canvas.drawRoundRect(this.mSelectedDstRect, (float)n2, (float)n2, this.mPaint);
                }
                if (this.mHasThumbnailMarker) {
                    this.mPaint.setColor(this.markerColor);
                    this.mPaint.setStrokeWidth(AOverlayUtil.DpToPxF(this.markerStrokeWidth));
                    if (this.mMarkerDstRect == null) {
                        this.mMarkerDstRect = new RectF();
                        this.calcMarkerRect();
                    }
                    canvas.drawRoundRect(this.mMarkerDstRect, (float)(this.markerStrokeWidth / 2), (float)(this.markerStrokeWidth / 2), this.mPaint);
                }
            }
            this.mPaint.setColor(-16777216);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(AOverlayUtil.getDP());
            canvas.drawRect(this.mDstRect, this.mPaint);
            if (this.mBitmap != null) {
                this.mSrcRect.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                canvas.drawBitmap(this.mBitmap, this.mSrcRect, this.mDstRect, null);
            }
        }
    }
}

