package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.dto.ArchiveDto;
import jp.agentec.abook.abv.bl.dto.ChatGroupDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class ArchiveListJSON extends AcmsCommonJSON {

    public ArrayList<ArchiveDto> archiveList;
    public String archiveLastUpdateDate;
    public ArchiveListJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // ルーム一覧情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }
        if (!json.getJSONObject(ABookCommConstants.KEY.BODY).has(ABookCommConstants.KEY.ARCHIVE_INFO_LIST)) { return; }

        JSONArray archiveListJsonArray = json.getJSONObject(ABookCommConstants.KEY.BODY).getJSONArray(ABookCommConstants.KEY.ARCHIVE_INFO_LIST);
        if (archiveListJsonArray == null) { return; }

        archiveList = new ArrayList<ArchiveDto>();
        for (int listCount = 0; listCount < archiveListJsonArray.length(); listCount++) {
            if (archiveListJsonArray.getJSONObject(listCount).length() == 0) {
                break;
            }
            JSONObject archiveJSON = archiveListJsonArray.getJSONObject(listCount);

            ArchiveDto archiveDto = new ArchiveDto();

            archiveDto.archiveId = archiveJSON.getInt(ABookCommConstants.KEY.ARCHIVE_ID);
            archiveDto.collaborationDetailId = archiveJSON.getInt(ABookCommConstants.KEY.COLLABORATION_DEATAIL_ID);
            archiveDto.archiveName = archiveJSON.getString(ABookCommConstants.KEY.ARCHIVE_NAME);
            archiveDto.archiveDate = DateTimeUtil.millToDateString(archiveJSON.getJSONObject(ABookCommConstants.KEY.ARCHIVE_DATE)
                    .getLong(ABookCommConstants.KEY.TIME), "yyyy/MM/dd HH:mm");
            archiveDto.archiveType = archiveJSON.getInt(ABookCommConstants.KEY.ARCHIVE_TYPE);
            archiveDto.delFlg = archiveJSON.getInt(ABookCommConstants.KEY.DEL_FLG);
            archiveDto.roomId = archiveJSON.getInt(ABookCommConstants.KEY.ROOM_ID);
            archiveDto.saveUserId = archiveJSON.getInt(ABookCommConstants.KEY.SAVE_USER_ID);
            archiveDto.filePath = archiveJSON.getString(ABookCommConstants.KEY.FILE_PATH);
            if (archiveJSON.has(ABookCommConstants.KEY.ATTEND_USER_IDS)) {
                archiveDto.attendUserIds = archiveJSON.getJSONArray(ABookCommConstants.KEY.ATTEND_USER_IDS).toString();
            }
            archiveList.add(archiveDto);
        }


        String time = JsonUtil.getString(json, PresentTime);
        presentTime = DateTimeUtil.toDate(time, DateTimeFormat.yyyyMMddHHmmss_hyphen);
        archiveLastUpdateDate = DateTimeUtil.toString(presentTime, DateTimeFormat.yyyyMMddHHmmss_none);
    }
}

