package jp.agentec.abook.abv.bl.acms.client.parameters;

import java.sql.Timestamp;

import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

import org.json.adf.JSONObject;

/**
 * 閲覧コンテンツに対するログを記録するためのパラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ContentReadingLogParameters extends AcmsContentParameters {
	private Timestamp readingStartDate;
	private Timestamp readingEndDate;
	private int readingTime;
	private int deviceTypeId;
	private Double latitude;
	private Double longitude;
	private JSONObject pageLog;
	private JSONObject objectLog;
	private String loginId; // Reader
	private String key; // Reader
	private int mode;
	
	/**
	 * {@link ContentReadingLogParameters} クラスのインスタンスを初期化します。
	 * @param mode 
	 * @param sid　ログインした時のセッションIDです。
	 * @param contentId　閲覧したコンテンツのIDです。
	 * @param readingStartDate　閲覧の開始時刻です。
	 * @param readingEndDate　閲覧の終了時刻です。
	 * @param readingTime　閲覧時間（秒）です。
	 * @param deviceTypeId　端末タイプIDです。（iPad:1, iPhone:2, Android:3）
	 * @param latitude　緯度です。
	 * @param longitude　経度です。
	 * @param pageLog　ページ閲覧ログです。
	 * @param pageLog　オブジェクトログです。
	 * @since 1.0.0
	 */
	public ContentReadingLogParameters(String sid, long contentId, Timestamp readingStartDate, Timestamp readingEndDate
			, int readingTime, int deviceTypeId, Double latitude, Double longitude, int mode, JSONObject pageLog,  JSONObject objectLog) {
		super(sid, contentId);

		this.readingStartDate = readingStartDate;
		this.readingEndDate = readingEndDate;
		this.readingTime = readingTime;
		this.deviceTypeId = deviceTypeId;
		this.latitude = latitude;
		this.longitude = longitude;
		this.mode = mode;
		this.pageLog = pageLog;
		this.objectLog = objectLog;
	}

	/**
	 * 閲覧の開始時刻を返します。
	 * @return　閲覧の開始時刻です。
	 * @since 1.0.0
	 */
	public String getReadingStartDate() {
		if (readingStartDate == null) {
			return null;
		}
		return DateTimeUtil.toStringInTimeZone(readingStartDate, DateTimeFormat.yyyyMMddHHmmss_hyphen, "GMT") + ",GMT";
	}

	/**
	 * 閲覧の終了時刻を返します。
	 * @return　閲覧の終了時刻です。
	 * @since 1.0.0
	 */
	public String getReadingEndDate() {
		if (readingEndDate == null) {
			return null;
		}
		return DateTimeUtil.toStringInTimeZone(readingEndDate, DateTimeFormat.yyyyMMddHHmmss_hyphen, "GMT") + ",GMT";
	}

	/**
	 * 閲覧時間（秒）を返します。
	 * @return　閲覧時間（秒）です。
	 * @since 1.0.0
	 */
	public int getReadingTime() {
		return readingTime;
	}

	/**
	 * 端末タイプIDを返します。
	 * @return　端末タイプIDです。（iPad:1, iPhone:2, Android:3）
	 * @since 1.0.0
	 */
	public int getDeviceTypeId() {
		return deviceTypeId;
	}

	/**
	 * 緯度
	 * 
	 * @return
	 */
	public Double getLatitude() {
		return latitude;
	}

	/**
	 * 経度
	 * 
	 * @return
	 */
	public Double getLongitude() {
		return longitude;
	}

	/**
	 * モード（管理、インタラクティブ、サイネージ）
	 * 
	 * @return
	 */
	public int getMode() {
		return mode;
	}

	/**
	 * ページ閲覧ログ
	 * 
	 * @return
	 */
	public String getPageLog() {
		if(pageLog == null){
			return null;
		}
		return pageLog.toString();
	}

	/**
	 * オブジェクトログ
	 * 
	 * @return
	 */
	public String getObjectLog() {
		if(objectLog == null){
			return null;
		}
		return objectLog.toString();
	}

	public String getLoginId() {
		return loginId;
	}

	public void setLoginId(String loginId) {
		this.loginId = loginId;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

}
