package jp.agentec.abook.abv.bl.data.dao;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.adf.util.StringUtil;

public class ChatMessageDao extends AbstractCommunicationDao {

	/**
	 * {@link ChatMessageDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ChatMessageDao() {
	}

	@Override
	protected ChatMessageDto convert(Cursor cursor) {
		ChatMessageDto dto = new ChatMessageDto();

		int column = cursor.getColumnIndex("chat_message_id");
		if (column != -1) {
			dto.chatMessageId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("chat_room_id");
		if (column != -1) {
			dto.chatRoomId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("shop_member_id");
		if (column != -1) {
			dto.shopMemberId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("login_id");
		if (column != -1) {
			dto.loginId = cursor.getString(column);
		}
		column = cursor.getColumnIndex("message");
		if (column != -1) {
			dto.message = cursor.getString(column);
		}
		column = cursor.getColumnIndex("message_type");
		if (column != -1) {
			dto.messageType = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("image_name");
		if (column != -1) {
			dto.imageName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("download_file_name");
		if (column != -1) {
			dto.downloadFileName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("save_path");
		if (column != -1) {
			dto.savePath = cursor.getString(column);
		}
		column = cursor.getColumnIndex("insert_date");
		if (column != -1) {
			dto.insertDate = cursor.getString(column);
		}
		column = cursor.getColumnIndex("shop_member_name");
		if (column != -1) {
			dto.shopMemberName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("profile_url");
		if (column != -1) {
			dto.profileUrl = cursor.getString(column);
		}
		column = cursor.getColumnIndex("self_flg");
		if (column != -1) {
			dto.selfFlg = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("unread_count");
		if (column != -1) {
			dto.unreadCount = cursor.getInt(column);
		}
		return dto;
	}

	public List<ChatMessageDto> getChatMessage(int chatRoomId) {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append("      cm.chat_message_id ");
		sql.append("      ,cm.chat_room_id ");
		sql.append("      ,cm.shop_member_id ");
		sql.append("      ,cm.login_id ");
		sql.append("      ,cm.message ");
		sql.append("      ,cm.message_type ");
		sql.append("      ,cm.image_name ");
		sql.append("      ,cm.download_file_name ");
		sql.append("      ,cm.save_path ");
		sql.append("      ,cm.insert_date ");
		sql.append("      ,sm.shop_member_name ");
		sql.append("      ,sm.profile_url ");
		sql.append("      ,sm.self_flg ");
		sql.append("      ,cm.unread_count ");
		sql.append(" FROM ");
		sql.append("      t_chat_message AS cm ");
		sql.append(" INNER JOIN ");
		sql.append("      m_shop_member AS sm ");
		sql.append("   ON cm.shop_member_id = sm.shop_member_id ");
		sql.append(" WHERE cm.chat_room_id = ? ");
		sql.append(" ORDER BY cm.insert_date DESC ");
		sql.append(" LIMIT " + ABookCommConstants.SIZE.MESSAGE_PAGING_SIZE);
		List<ChatMessageDto> list = rawQueryGetDtoList(sql.toString(), new String[]{""+ chatRoomId}, ChatMessageDto.class);
		return list;
	}

	public List<ChatMessageDto> getChatMessageFromMessageId(int chatRoomId, String MessageId) {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append("      cm.chat_message_id ");
		sql.append("      ,cm.chat_room_id ");
		sql.append("      ,cm.shop_member_id ");
		sql.append("      ,cm.login_id ");
		sql.append("      ,cm.message ");
		sql.append("      ,cm.message_type ");
		sql.append("      ,cm.image_name ");
		sql.append("      ,cm.download_file_name ");
		sql.append("      ,cm.save_path ");
		sql.append("      ,cm.insert_date ");
		sql.append("      ,sm.shop_member_name ");
		sql.append("      ,sm.profile_url ");
		sql.append("      ,sm.self_flg ");
		sql.append("      ,cm.unread_count ");
		sql.append(" FROM ");
		sql.append("      t_chat_message AS cm ");
		sql.append(" INNER JOIN ");
		sql.append("      m_shop_member AS sm ");
		sql.append("   ON cm.shop_member_id = sm.shop_member_id ");
		sql.append(" WHERE cm.chat_room_id = ? ");
		sql.append(" AND cm.chat_message_id < ? ");
		sql.append(" ORDER BY cm.insert_date DESC ");
		sql.append(" LIMIT " + ABookCommConstants.SIZE.MESSAGE_PAGING_SIZE);
		List<ChatMessageDto> list = rawQueryGetDtoList(sql.toString(), new String[]{"" + chatRoomId, "" + MessageId}, ChatMessageDto.class);
		return list;
	}

	public List<ChatMessageDto> searchChatMessage(int chatRoomId, String[] keywords, String userList) {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append("      cm.chat_message_id ");
		sql.append("      ,cm.chat_room_id ");
		sql.append("      ,cm.shop_member_id ");
		sql.append("      ,cm.login_id ");
		sql.append("      ,cm.message ");
		sql.append("      ,cm.message_type ");
		sql.append("      ,cm.image_name ");
		sql.append("      ,cm.download_file_name ");
		sql.append("      ,cm.save_path ");
		sql.append("      ,cm.insert_date ");
		sql.append("      ,sm.shop_member_name ");
		sql.append("      ,sm.profile_url ");
		sql.append("      ,sm.self_flg ");
		sql.append("      ,cm.unread_count ");
		sql.append(" FROM ");
		sql.append("      t_chat_message AS cm ");
		sql.append(" INNER JOIN ");
		sql.append("      m_shop_member AS sm ");
		sql.append("   ON cm.shop_member_id = sm.shop_member_id ");
		sql.append(" WHERE cm.message_type = 0 ");
		List<String> whereSqlList = new ArrayList<String>();
		for (String keyword : keywords) {
			if (StringUtil.isNullOrEmpty(keyword)) {
				continue;
			}
			whereSqlList.add("cm.message LIKE  '%" + keyword + "%'");
		}
		String whereSql = StringUtil.join(" AND ", whereSqlList);
		if (!StringUtil.isNullOrEmpty(whereSql)) {
			sql.append("AND (" + whereSql + ")");
		}
		if (!StringUtil.isNullOrEmpty(userList)) {
			sql.append("   AND cm.shop_member_id IN (" + userList + ") ");
		}
		sql.append("AND cm.chat_room_id = ? ");
		sql.append("ORDER BY cm.insert_date DESC ");
		List<ChatMessageDto> list = rawQueryGetDtoList(sql.toString(), new String[]{""+ chatRoomId}, ChatMessageDto.class);
		return list;
	}

	public void insertChatMessage(ChatMessageDto dto) {
		insert("INSERT OR replace INTO t_chat_message (chat_message_id, chat_room_id, shop_member_id, login_id, message, message_type, image_name, download_file_name, save_path, insert_date, unread_count) VALUES (?,?,?,?,?,?,?,?,?,?,?)", dto.getInsertValues());
	}

	public void insertChatMessage(List<ChatMessageDto> chatMessageDtoList) {
		try {
			beginTransaction();
			for (ChatMessageDto chatMessageDto : chatMessageDtoList) {
				insertChatMessage(chatMessageDto);
			}
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("insertChatRoomList failed.", e);
			throw new RuntimeException(e);
		}
	}

	public boolean updateChatMessage(ChatMessageDto dto) {
		long count = update("UPDATE t_chat_message SET chat_room_id=?, shop_member_id=?, login_id=?,message=?, message_type=?, image_name=?, download_file_name=?, save_path=?, insert_date=?, unread_count WHERE chat_message_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public void updatUnreadCount(List<ChatMessageDto> messageDtoList, String roomId) {
		beginTransaction();
		update("UPDATE t_chat_message SET unread_count = 0 WHERE chat_room_id=?", new String[]{"" + roomId});
		for (ChatMessageDto messageDto : messageDtoList) {
			update("UPDATE t_chat_message SET unread_count = ? WHERE chat_message_id=?", new String[]{"" + messageDto.unreadCount, "" + messageDto.chatMessageId});
		}
		commit();
	}

	public void deleteChatMessage() {
		try {
			beginTransaction();
			delete("t_chat_message", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteChatMessage failed.", e);
			throw new RuntimeException(e);
		} finally {
		}
	}

}
