package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.common.db.SQLiteStatement;

public class ContentCategoryDao extends AbstractDao {

	/*package*/ ContentCategoryDao() {
	}


	public boolean insertContentCategory(int categoryId, long contentId) {
		StringBuffer sql = new StringBuffer();

		sql.append(" INSERT into r_content_category ");
		sql.append(" SELECT " + contentId);
		sql.append("      , category_relation_id ");
		sql.append("   FROM m_category   ");
		sql.append("  WHERE category_id = ? ");

		SQLiteStatement stmt = null;
		try {
			SQLiteDatabase db = getDatabase();
			stmt = db.compileStatement(sql.toString());
			stmt.bindLong(1, categoryId);

			return (stmt.executeInsert() > 0);
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	public void deleteContentCategory(long contentId) {
		delete("r_content_category", "content_id=?", new String[]{""+ contentId});
	}

}
