package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class TContentMarking extends SQLiteTableScript {

	public TContentMarking() {
	}

	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();

		sql.append(" CREATE TABLE t_content_marking ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , page_num INTEGER NOT NULL ");
		sql.append("      , marking_id VARCHAR(64) NOT NULL");
		sql.append("      , file_name TEXT NOT NULL ");
		sql.append("      , insert_date DATETIME NOT NULL ");
		sql.append("      , update_date DATETIME NOT NULL ");
		sql.append("      , PRIMARY KEY (content_id, page_num) ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append(" ) ");

		ddl.add(sql.toString());
		
		ddl.add(" CREATE INDEX idx_content_marking_page_num ON t_content_marking (page_num) ");

		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
