package jp.agentec.abook.abv.bl.download;

import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;
import jp.agentec.adf.net.http.HttpDownloadNotification;

public class ContentZipDownloadNotification extends HttpDownloadNotification {
	public long contentId;
	public DownloadStatusType downloadStatus; // 親のdownloadStateと一部重複
	
	public ContentZipDownloadNotification() {}
	
	public ContentZipDownloadNotification(HttpDownloadNotification notification, DownloadStatusType downloadStatus) {
		if (notification != null && downloadStatus != null && notification.getCustomInformation() != null) {
			contentId = (Long) notification.getCustomInformation();
			downloadFileName = notification.getDownloadFileName();
			outputFileName = notification.getOutputFileName();
			fileSize = notification.getFileSize();
			downloadedSize = notification.getDownloadedSize();

			switch (downloadStatus) {
				case Downloading:
				case AutoPaused:
				case Paused:
				case Waiting:
					downloadRate = notification.getDownloadRate();
					break;
				case Initializing:
				case Succeeded:
					downloadRate = 100;
					break;
				case Failed:
					break;
				case Canceled:
					break;
				case None:
					break;
				default:
					downloadRate = 0f;
					break;
			}

			error = notification.getError();
			this.downloadStatus = downloadStatus;
		}
	}

	public long getContentId() {
		return contentId;
	}

	public DownloadStatusType getDownloadStatus() {
		return downloadStatus;
	}
}
