package jp.agentec.abook.abv.ui.common.appinfo.options;

import jp.agentec.abook.abv.bl.acms.type.ServiceOption.ServiceOptionId;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.launcher.android.R;
import android.content.Context;

/**
 * @author tauchi
 *
 */
public class ABVFunctionOptions extends AbstractOptions {

	public ABVFunctionOptions(Context context) {
		super(context);
	}

	@Override
	public int getViewerMenuTextcopy() {
		return ABVDataCache.getInstance().serviceOption.isServiceOptionEnable(ServiceOptionId.PdfTextCopy) ? 1 : 0;
	}

	@Override
	public int getViewerMenuMarking() {
		if (context.getResources().getBoolean(R.bool.follow_service_option)) {
			return ABVDataCache.getInstance().serviceOption.isMarking() ? 1 : 0;
		}
		return 1;
	}
}
