package jp.agentec.abook.abv.ui.home.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;

import jp.agentec.abook.abv.launcher.android.R;

/**
 * 初回起動時のOS時間制限を回避するためのActivity
 * 機能はない⇒本来の起動画面に遷移するだけの機能
 */
public class PreSplashActivity extends Activity {

    static {
        try {
            // アーキテクチャがx86以外の場合のみ、以下のライブラリをロードする。
            if (!Build.CPU_ABI.contains("x86")) {
                System.loadLibrary("skia_android");
                System.loadLibrary("ozrv");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.ac_splash1);
        Intent intent = getIntent();
        intent.setClassName(getApplicationContext().getPackageName(), SplashScreenActivity.class.getName()).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
        finish();
    }
}
