package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.bl.dto.FixPushMessageDto;
import jp.agentec.abook.abv.launcher.android.R;

/**
 * Created by kim jinsung on 2018/09/15.
 */

public class FixPushMessageAdapter extends ArrayAdapter<FixPushMessageDto> {
    private LayoutInflater mInflater;
    private int selectedPosition;
    public FixPushMessageAdapter(Context context, List<FixPushMessageDto> objects, int selectedPosition) {
        super(context, 0, objects);
        this.selectedPosition = selectedPosition;
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_fix_push_message_list, parent, false);
            holder = new ViewHolder();
            holder.titleTextView = (TextView) convertView.findViewById(R.id.push_message_title_text_view);
            holder.messageTextView = (TextView) convertView.findViewById(R.id.push_message_text_view);
            holder.selectedImageView = (ImageView) convertView.findViewById(R.id.selectedImageView);
            if (selectedPosition == position) {
                holder.selectedImageView.setVisibility(View.VISIBLE);
            } else {
                holder.selectedImageView.setVisibility(View.INVISIBLE);
            }
            convertView.setTag(holder);

        }else {
            holder = (ViewHolder) convertView.getTag();
        }
        FixPushMessageDto item = getItem(position);
        if (position == 0) {
            holder.messageTextView.setVisibility(View.GONE);
        } else {
            holder.messageTextView.setVisibility(View.VISIBLE);
        }
        if (item != null) {
            holder.titleTextView.setText(item.name);
            holder.messageTextView.setText(item.value);
        }
        return convertView;
    }
    private class ViewHolder {
        TextView titleTextView;
        TextView messageTextView;
        ImageView selectedImageView;
    }
}


