package jp.agentec.abook.abv.ui.home.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebSettings;
import android.webkit.WebView;

import java.io.File;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.data.ChatData;
import jp.agentec.abook.abv.ui.home.activity.ChatWebViewActivity;
import jp.agentec.abook.abv.ui.home.activity.OperationRelatedContentActivity;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;

public class ChatWebView extends WebView {

    private final ChatWebViewActivity chatActivity;
    private ChatData chatData;
    public ChatWebViewDelegate delegate;

    public ChatWebView(Context context) {
        super(context);
        chatActivity = (ChatWebViewActivity)context;
    }

    @SuppressLint("SetJavaScriptEnabled")
    public void configue(ChatData chatData) {
        setOverScrollMode(View.OVER_SCROLL_NEVER);  //オーバースクロールしない。
        setVerticalScrollBarEnabled(false); //スクロールバーを消す。
        addJavascriptInterface(this, "android");
        WebSettings settings = getSettings();
        settings.setJavaScriptEnabled(true); //Javascriptを有効にする。
        settings.setCacheMode(WebSettings.LOAD_NO_CACHE);

        settings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        settings.setAllowFileAccess(true);
        settings.setUseWideViewPort(true);
        settings.setAllowContentAccess(true);
        settings.setAllowFileAccessFromFileURLs(true);
        settings.setSaveFormData(false);
        settings.setAllowUniversalAccessFromFileURLs(true);
        if (Logger.isDebugEnabled()) {
            setWebContentsDebuggingEnabled(true); //デバッグモード（chromeからinspect可)
        }
        this.chatData = chatData;
    }

    @JavascriptInterface
    public void saveVisitRoomInfo(String roomId, String roomName) {
        chatActivity.saveVisitRoomInfo(roomId, roomName);
    }

    @JavascriptInterface
    public void goHome() {
        post(new Runnable() {
            @Override
            public void run() {
                chatActivity.backToHome();
            }
        });
    }

    @JavascriptInterface
    public void openOperationRelatedContent() {
        post(new Runnable() {
            @Override
            public void run() {
                chatActivity.showCommonContent();
            }
        });
    }

    @JavascriptInterface
    public void openCommunication() {
        chatActivity.showCommunicationChatMenuDialog();
    }

    @JavascriptInterface
    public void openCommunicationHome() {
        post(new Runnable() {
            @Override
            public void run() {
                loadUrl(ABookCommConstants.CHAT_PAGE_URL);
            }
        });
    }

    @Override
    @JavascriptInterface
    public void reload() {
        post(new Runnable() {
            @Override
            public void run() {
                ActivityHandlingHelper.getInstance().startChatWebViewActivity();
            }
        });
    }

    @JavascriptInterface
    public void saveSelectedUserList(String userIdList) {
        chatActivity.setSelectedUserIdList(userIdList);
    }

    @JavascriptInterface
    public String getSelectedUserList() {
        return chatActivity.getSelectedUserList();
    }

    @JavascriptInterface
    public String getRoomList(String roomType, String keyword) {
        return chatData.getRoomList(roomType, keyword);
    }

    @JavascriptInterface
    public void test() {
        OperationRelatedContentActivity testact = ActivityHandlingHelper
                .getInstance()
                .getActivity(OperationRelatedContentActivity.class);
        testact.finish();
    }

    @JavascriptInterface
    public void updateRoomList() throws NetworkDisconnectedException, AcmsException {
        chatData.updateRoomList();
    }

    @JavascriptInterface
    public void updateMyInfo() throws NetworkDisconnectedException, AcmsException {
        chatActivity.updateMyInfo();
    }

    @JavascriptInterface
    public void updateGroupUser() throws NetworkDisconnectedException, AcmsException {
        chatActivity.updateGroupUser();
    }

    @JavascriptInterface
    public void createChatRoom(
            String roomType,
            String userIdList,
            String encodedRoomName,
            String screenFlg,
            boolean isVoice)
            throws NetworkDisconnectedException, AcmsException
    {
        chatActivity.createChatRoom(roomType, userIdList, encodedRoomName, screenFlg, isVoice);
    }

    @JavascriptInterface
    public void changeRoomName(String changeRoomName) throws NetworkDisconnectedException, AcmsException {
        chatActivity.changeRoomName(changeRoomName);
    }

    @JavascriptInterface
    public void joinRoom(String joinRoomId, String joinRoomName) {
        chatActivity.joinRoom(joinRoomId, joinRoomName);
    }

    @JavascriptInterface
    public void roomDisplayOff() {
        chatActivity.roomDisplayOff();
    }

    @JavascriptInterface
    public void inviteUsers(String userIds) throws NetworkDisconnectedException, AcmsException {
        chatActivity.inviteUsers(userIds);
    }

    @JavascriptInterface
    public String getRoomType() {
        return chatActivity.getRoomType();
    }

    @JavascriptInterface
    public String getBeforeRoomType() {
        return chatActivity.getBeforeRoomType();
    }

    @JavascriptInterface
    public void clearBeforeRoomType() {
        chatActivity.clearBeforeRoomType();
    }

    @JavascriptInterface
    public void updateMessages(String roomId) throws NetworkDisconnectedException, AcmsException {
        chatActivity.updateMessages(roomId);
    }

    @JavascriptInterface
    public String getMessageList(String roomId) {
        return chatData.getMessageList(roomId);
    }

    @JavascriptInterface
    public String searchMessages(String keyword, String userList) {
        return chatActivity.searchMessages(keyword, userList);
    }

    @JavascriptInterface
    public String getFavoriteUsers() {
        return chatData.getFavoriteUsers();
    }

    @JavascriptInterface
    public String getFavoriteUsersNotInRoom() {
        return chatActivity.getFavoriteUsersNotInRoom();
    }

    @JavascriptInterface
    public String getMyInfo() {
        return chatData.getMyInfo();
    }

    @JavascriptInterface
    public String getUsersInRoom(String roomId) {
        return chatData.getUsersInRoom(roomId);
    }

    @JavascriptInterface
    public String getMyGroupUsers() {
        return chatData.getMyGroupUsers();
    }

    @JavascriptInterface
    public String getMyGroupUsersNotInRoom() {
        return chatActivity.getMyGroupUsersNotInRoom();
    }

    @JavascriptInterface
    public String getMyGroupShopMemberByName(String keyword) {
        return chatData.getMyGroupShopMemberByName(keyword);
    }

    @JavascriptInterface
    public String getMyGroupShopMemberNotInRoomByName(String keywords) {
        return chatActivity.getMyGroupShopMemberNotInRoomByName(keywords);
    }

    @JavascriptInterface
    public String getAllGroupShopMemberByName(String shopMemberName) {
        return chatData.getAllGroupShopMemberByName(shopMemberName);
    }

    @JavascriptInterface
    public String getAllGroupShopMemberNotInRoomByName(String keywords) {
        return chatActivity.getAllGroupShopMemberNotInRoomByName(keywords);
    }

    @JavascriptInterface
    public String getGroupByName(String keyword) {
        return chatData.getGroupByName(keyword);
    }

    @JavascriptInterface
    public String getFavoriteGroups() {
        return chatData.getFavoriteGroups();
    }

    @JavascriptInterface
    public void updateUserInfo(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        chatActivity.updateUserInfo(shopMemberId);
    }

    @JavascriptInterface
    public String getGroupInfo(String groupId) {
        return chatData.getGroupInfo(groupId);
    }

    @JavascriptInterface
    public String getGroupInfoForAddUser(String groupId) {
        return chatActivity.getGroupInfoForAddUser(groupId);
    }

    @JavascriptInterface
    public String getNameCardData(String shopMemberId) {
        return chatData.getNameCardData(shopMemberId);
    }

    @JavascriptInterface
    public String getFavoriteGroupsList() {
        return chatData.getFavoriteGroupsList();
    }

    @JavascriptInterface
    public boolean addFavoriteUser(String shopMemberId) throws AcmsException {
        return chatActivity.addFavoriteUser(shopMemberId);
    }

    @JavascriptInterface
    public boolean removeFavoriteUser(String shopMemberId) throws AcmsException {
        return chatActivity.removeFavoriteUser(shopMemberId);
    }

    @JavascriptInterface
    public boolean addFavoriteGroup(String groupId) throws  AcmsException {
        return chatActivity.addFavoriteGroup(groupId);
    }

    @JavascriptInterface
    public boolean removeFavoriteGroup(String groupId) throws AcmsException {
        return chatActivity.removeFavoriteGroup(groupId);
    }

    @JavascriptInterface
    public void updateFavorite() throws NetworkDisconnectedException, AcmsException {
        chatActivity.updateFavorite();
    }

    @JavascriptInterface
    public void updateArchiveList() throws NetworkDisconnectedException, AcmsException {
        chatData.updateArchiveList();
    }

    @JavascriptInterface
    public String getArchiveList() {
        return chatData.getArchiveList();
    }

    @JavascriptInterface
    public String getArchiveListByName(String keyword) {
        return chatData.getArchiveListByName(keyword);
    }

    @JavascriptInterface
    public String getUserInfo(String shopMemberId) {
        return chatData.getUserInfo(shopMemberId);
    }

    @JavascriptInterface
    public String getUserInfoList(String shopMemberIds) {
        return chatData.getUserInfoList(shopMemberIds);
    }

    @JavascriptInterface
    public String getArchiveDetail(String archiveId) {
        return chatData.getArchiveDetail(archiveId);
    }

    @JavascriptInterface
    public void updateArchiveDetail(String archiveId) throws NetworkDisconnectedException, AcmsException {
        chatData.updateArchiveDetail(archiveId);
    }

    @JavascriptInterface
    public void joinCollaboration(String collaborationType, String meetingId)
            throws NetworkDisconnectedException, AcmsException
    {
        chatActivity.joinCollaboration(collaborationType, meetingId);
    }

    @JavascriptInterface
    public void joinChangedCollaboration(String collaborationType, String meetingId)
            throws NetworkDisconnectedException, AcmsException
    {
        chatData.joinChangedCollaboration(collaborationType, meetingId);
    }

    @JavascriptInterface
    public void inviteCollaboration(String inviteUserIds, String collaborationType)
            throws NetworkDisconnectedException, AcmsException
    {
        chatData.inviteCollaboration(inviteUserIds, collaborationType);
    }

    @JavascriptInterface
    public void startCollaboration(String collaborationType) {
        chatActivity.startCollaboration(collaborationType);
    }

    @JavascriptInterface
    public void finishCollaboration() throws NetworkDisconnectedException, AcmsException {
        chatData.finishCollaboration();
    }

    @JavascriptInterface
    public void finishAllCollaboration() throws NetworkDisconnectedException, AcmsException {
        chatData.finishAllCollaboration();
    }

    @JavascriptInterface
    public String getCollaborationJoinFlg() {
        return chatData.getCollaborationJoinFlg();
    }

    @JavascriptInterface
    public String getCollaborationType() {
        return chatData.getStrCollaborationType();
    }

    @JavascriptInterface
    public String getToMoveGroupId() {
        return chatData.getToMoveGroupId();
    }

    @JavascriptInterface
    public void setToMoveGroupId(String moveToGroupId) {
        chatData.setToMoveGroupId(moveToGroupId);
    }

    @JavascriptInterface
    public String getContentList() {
        return chatData.getContentList();
    }

    @JavascriptInterface
    public String getUserListByLoginId(String loginIdList) {
        return chatData.getUserListByLoginId(loginIdList);
    }

    @JavascriptInterface
    public int createContentView() {
        return chatActivity.createContentView();
    }

    @JavascriptInterface
    public void startContentView() throws InterruptedException  {
        chatActivity.startContentView();
    }

    @JavascriptInterface
    public void joinMeetingRoom(int newMeetingId) throws InterruptedException {
        chatActivity.joinMeetingRoom(newMeetingId);
    }

    @JavascriptInterface
    public void startPIPMode() {
        chatActivity.startPIPMode();
    }

    @JavascriptInterface
    public void exitPIPmode() {
        chatActivity.exitPIPmode();
    }

    @JavascriptInterface
    public void exitMeetingRoom() {
        chatActivity.exitMeetingRoom();
    }

    @JavascriptInterface
    public int getJoinCollaborationType() {
        return chatData.getJoinCollaborationType();
    }

    @JavascriptInterface
    public void setJoinCollaborationType(int collaborationType) {
        chatData.setJoinCollaborationType(collaborationType);
    }

    @JavascriptInterface
    public void changeCollaboration(int changeCollaborationType, int meetingId)
            throws NetworkDisconnectedException, AcmsException
    {
        chatData.changeCollaboration(changeCollaborationType, meetingId);
    }

    @JavascriptInterface
    public int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    @JavascriptInterface
    public void removeEncodedVideo(String filePath) {
        File encodedVideo = new File(filePath);
        if (encodedVideo.exists()) {
            encodedVideo.delete();
        }
    }

    @JavascriptInterface
    public void setHostRequestFlg(int hostRequestFlg) {
        chatData.setHostRequestFlg(hostRequestFlg);
    }

    @JavascriptInterface
    public int getHostRequestFlg() {
        return chatData.getHostRequestFlg();
    }

    @JavascriptInterface
    public void finishPIP() {
        //Androidの場合、PIP解除はできないので、不要（リクエスト要請時に呼ばれる）
    }

    @JavascriptInterface
    public void setExitHostAlert() {
        chatActivity.setExitHostAlert();
    }

    @JavascriptInterface
    public boolean getExitHostAlert() {
        return chatActivity.getExitHostAlert();
    }

    @JavascriptInterface
    public void updatePreMessage(String messageId)
            throws NetworkDisconnectedException, AcmsException
    {
        chatData.updatePreMessage(messageId);
    }

    @JavascriptInterface
    public String getMessageListFromMessageId(String messageId) {
        return chatData.getMessageListFromMessageId(messageId);
    }

    @JavascriptInterface
    public String getDeviceInfo() {
        return chatData.getDeviceInfo();
    }

    @JavascriptInterface
    public String getServerInfo() {
        return chatData.getServerInfo();
    }

    @JavascriptInterface
    public String getMyUserInfo() {
        return chatData.getMyUserInfo();
    }

    @JavascriptInterface
    public String getRoomInfo() {
        return chatData.getRoomInfo();
    }

    @JavascriptInterface
    public void showLoadingIndicator() {
        if (delegate != null) {
            delegate.chatWebViewNeedsShowProgressBar();
        }

    }

    @JavascriptInterface
    public void hideLoadingIndicator() {
        if (delegate != null) {
            delegate.chatWebViewNeedsDismissProgressBar();
        }
    }
    public void loadBlank() {
        post(new Runnable() {
            @Override
            public void run() {
                loadUrl("about:blank");
            }
        });
    }

    public void loadChatViewUrl(final String urlString) {
        post(new Runnable() {
            @Override
            public void run() {
                loadUrl(urlString);
            }
        });
    }

    public void showAlert(String message) {
        loadChatViewUrl("javascript:alert('" + message + "');");
    }

    public void extendHeartBeat() {
        loadUrl("javascript:coview_api.HeartBeatUser(globalUserInfo.loginId);");
    }

    public void extendHeartBeatIfNeeded() {
        if (getUrl() != null && getUrl().equals(ABookCommConstants.COLLABORATION_PAGE_URL)) {
            extendHeartBeat();
        }
    }

    public void hideNameCardInCollaboaration() {
        loadUrl("javascript:$('#userNameCardInCollaboration').modal('hide');");
    }

    public void hideHostRequestModal() {
        loadUrl("javascript:$('#hostRequestModal').modal('hide');");
    }

    public void leaveRoom() {
        loadUrl("javascript:ReverseDelegate.leaveRoom()");
    }

    public void recordFinished() {
        loadUrl("javascript:recordFinished()");
    }

    public void penOff() {
        loadUrl("javascript:penOff();");
    }

    public void refreshForOffline() {
        loadUrl("javascript:Common.refreshForOffline();");
    }

    public void refreshForOnline() {
        loadUrl("javascript:Common.refreshForOnline();");
    }

    public void windowReload() {
        loadUrl("javascript:window.location.reload();");
    }

    public void finishedVideoEncoding(String encodedFilePath) {
        loadUrl("javascript:ChatMediaHandler.videoEncodeEnd('" +encodedFilePath + "')");
    }

    public void failedVideoEncoding() {
        loadUrl("javascript:ChatMediaHandler.videoEncodeFail();)");
    }

    public void removePIPIndicator() {
        loadUrl("javascript:$('.pip_indicator').removeClass('none');");
    }

    public void exitCollaboration() {
        loadUrl("javascript:CoviewBridge.exitCollaboration();");
    }

    public void addPIPIndicator() {
        loadUrl("javascript:$('.pip_indicator').addClass('none');");
    }

    public void addPIPButton() {
        loadUrl("javascript:$('.start_pip_btn').addClass('none');");
    }

    public void socketCheck() {
        loadUrl("javascript:CHAT_SOCKET.socketCheck();");
    }

    public void displayExistRoom(Integer chatRoomId) {
        loadChatViewUrl(String.format("javascript:ReverseDelegate.displayExistRoom('%s');", chatRoomId.toString()));
    }

    public void startAudioCollaboration() {
        loadChatViewUrl(String.format("javascript:Common.startCollaboration('%s');", ABookCommConstants.FLAG.COLLABORATION_TYPE.AUDIO ));
    }
}
