/*
 * Decompiled with CFR 0.152.
 */
package oz.api;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.StrictMode;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import oz.api.OZRViewerCmd;
import oz.api.OZRViewerCmdImpl;
import oz.api.OZReportCommandListener;
import oz.api.OZReportCustomUICheckListener;
import oz.api.OZReportViewer;
import oz.api.OZReportViewerImpl$1;
import oz.client.shape.ui.ICImagePickerWnd;
import oz.client.shape.ui.ICSignPadWnd;
import oz.client.shape.ui.OZInputComponent;
import oz.main.MainFrameView;
import oz.main.OZPageView;
import oz.main.OZStorage;
import oz.util.LinkedHashtable;
import oz.util.OZDirectByteBufferInputStream;
import oz.util.OZLocationManager;

public class OZReportViewerImpl
extends OZReportViewer {
    private ViewGroup _parentView = null;
    private OZReportCommandListener m_listener = null;
    private boolean _disposed = false;
    LinkedHashtable m_exportMap;
    OZRViewerCmdImpl m_viewerCmd = null;

    protected void internalInit(ViewGroup viewGroup) {
        MainFrameView.s_context = viewGroup.getContext();
        LinearLayout linearLayout = new LinearLayout(viewGroup.getContext());
        LinearLayout linearLayout2 = new LinearLayout(viewGroup.getContext());
        linearLayout.setOrientation(1);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        viewGroup.addView((View)linearLayout, new ViewGroup.LayoutParams(-1, -1));
        this._parentView = linearLayout2;
        this.mainThreadPolicy();
        this.storage();
        this.tempResourceCopy();
        this.initInstance();
    }

    protected String getClientDeviceInfoHash() {
        int n = Settings.Secure.getString((ContentResolver)this._parentView.getContext().getContentResolver(), (String)"android_id").hashCode();
        return Integer.toString(n);
    }

    private void mainThreadPolicy() {
        GenericDeclaration genericDeclaration;
        try {
            genericDeclaration = Class.forName("android.os.StrictMode", true, Thread.currentThread().getContextClassLoader());
            Class<?> clazz = Class.forName("android.os.StrictMode$ThreadPolicy", true, Thread.currentThread().getContextClassLoader());
            Class<?> clazz2 = Class.forName("android.os.StrictMode$ThreadPolicy$Builder", true, Thread.currentThread().getContextClassLoader());
            Method method = ((Class)genericDeclaration).getMethod("setThreadPolicy", clazz);
            Method method2 = clazz2.getMethod("permitDiskReads", new Class[0]);
            Method method3 = clazz2.getMethod("permitDiskWrites", new Class[0]);
            Method method4 = clazz2.getMethod("permitNetwork", new Class[0]);
            Method method5 = clazz2.getMethod("build", new Class[0]);
            Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Object object = method2.invoke(obj, new Object[0]);
            object = method3.invoke(object, new Object[0]);
            object = method4.invoke(object, new Object[0]);
            Object object2 = method5.invoke(object, new Object[0]);
            method.invoke((Object)genericDeclaration, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                genericDeclaration = StrictMode.class.getMethod("disableDeathOnFileUriExposure", new Class[0]);
                ((Method)genericDeclaration).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setHelpURL(String string) {
        OZStorage.m_helpURL = string;
    }

    private void storage() {
        OZStorage.nativeSetAndroidApi(Build.VERSION.SDK_INT);
        Display display = ((WindowManager)this._parentView.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        OZStorage.m_dpi = displayMetrics.densityDpi;
        OZStorage.m_xdpi = displayMetrics.xdpi;
        OZStorage.m_ydpi = displayMetrics.ydpi;
        OZStorage.m_width = displayMetrics.widthPixels;
        OZStorage.m_height = displayMetrics.heightPixels;
        OZStorage.m_scaledDensity = displayMetrics.scaledDensity;
        OZStorage.m_screenWidth = displayMetrics.widthPixels;
        OZStorage.m_screenHeight = displayMetrics.heightPixels;
        OZStorage.m_SignPadiconMargin = this.getSignPadIconMargin(this._parentView.getContext());
        OZStorage.tmpCacheDir = this.getCacheTmpDir();
        OZStorage.Language = this.getDefaultLanguage();
        OZStorage.m_strLan = this.getDefaultLanguage() + "_" + this.getDefaultCountry();
        if (OZStorage.padding_5 == 0) {
            OZStorage.padding_1 = OZStorage.getDensityDPI();
            OZStorage.padding_3 = (int)(OZStorage.padding_1 * 3.0f);
            OZStorage.padding_5 = (int)(OZStorage.padding_1 * 5.0f);
            OZStorage.padding_10 = (int)(OZStorage.padding_1 * 10.0f);
            OZStorage.padding_20 = (int)(OZStorage.padding_1 * 20.0f);
        }
        Log.d((String)"OZViewer", (String)("dpi========" + displayMetrics.densityDpi + "   displayWidth=" + displayMetrics.widthPixels + ",  displayHeight=" + displayMetrics.heightPixels + ", scaledDensity=" + displayMetrics.scaledDensity));
        this.tmpCacheDeleteFiles();
    }

    private Point getSignPadIconMargin(Context context) {
        Drawable drawable2;
        Button button = new Button(context);
        button.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        if (OZStorage.getCustomID("R.drawable.OZSignPadInitButton") != -1) {
            button.setBackgroundResource(OZStorage.getCustomID("R.drawable.OZSignPadInitButton"));
        } else {
            try {
                drawable2 = OZStorage.getDrawable(context.getResources().getAssets().open(OZStorage.getImagePath("resource/default_btn_init@2x.png")));
                button.setBackgroundDrawable(drawable2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Button button2 = new Button(context);
        button2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        if (OZStorage.getCustomID("R.drawable.OZSignPadConfirmButton") != -1) {
            button2.setBackgroundResource(OZStorage.getCustomID("R.drawable.OZSignPadConfirmButton"));
        } else {
            try {
                drawable2 = OZStorage.getDrawable(context.getResources().getAssets().open(OZStorage.getImagePath("resource/default_btn_confirm@2x.png")));
                button2.setBackgroundDrawable(drawable2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n = Math.max(button2.getBackground().getIntrinsicHeight(), button.getBackground().getIntrinsicHeight());
        if (n <= 0) {
            n = 40;
        }
        int n2 = 10 + n + 10;
        int n3 = button2.getBackground().getIntrinsicWidth() + button.getBackground().getIntrinsicWidth() + 10;
        return new Point(n3, n2);
    }

    private void tmpCacheDeleteFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tempResourceCopy() {
        String[] stringArray = null;
        try {
            Closeable closeable;
            String string;
            long l;
            Object object;
            PackageManager packageManager;
            String string2 = this.getCacheTmpDir() + "/OZReport Viewer/res";
            boolean bl = new File(string2).mkdirs();
            Log.d((String)"OZViewer", (String)("make Resource Dir is " + bl));
            File file = new File(string2 + "/resourcever.txt");
            Properties properties = new Properties();
            if (file.exists()) {
                packageManager = this._parentView.getContext().getPackageManager();
                object = null;
                l = 0L;
                try {
                    object = packageManager.getApplicationInfo(this._parentView.getContext().getPackageName(), 0);
                    string = object.sourceDir;
                    l = new File(string).lastModified();
                    closeable = new FileInputStream(file);
                    properties.load((InputStream)closeable);
                    ((FileInputStream)closeable).close();
                    String string3 = properties.getProperty("version", "-1");
                    if (string3.equals(l + "")) {
                        return;
                    }
                    properties.setProperty("version", l + "");
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, "OZReport Viewer Resource Version");
                    fileOutputStream.close();
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    nameNotFoundException.printStackTrace();
                }
            } else {
                packageManager = this._parentView.getContext().getPackageManager();
                object = null;
                l = 0L;
                try {
                    object = packageManager.getApplicationInfo(this._parentView.getContext().getPackageName(), 0);
                    string = object.sourceDir;
                    l = new File(string).lastModified();
                    Log.d((String)"OZViewer", (String)("App Install time==" + l));
                    properties.setProperty("version", l + "");
                    closeable = new FileOutputStream(file);
                    properties.store((OutputStream)closeable, "OZReport Viewer Resource Version");
                    ((FileOutputStream)closeable).close();
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    nameNotFoundException.printStackTrace();
                }
            }
            stringArray = this._parentView.getContext().getResources().getAssets().list("resource/xml");
            if (stringArray == null) return;
            for (int j = 0; j < stringArray.length; ++j) {
                FileOutputStream fileOutputStream;
                block17: {
                    Object var15_20;
                    object = new File(string2 + "/" + stringArray[j].toLowerCase());
                    InputStream inputStream = null;
                    fileOutputStream = null;
                    try {
                        try {
                            inputStream = this._parentView.getContext().getResources().getAssets().open("resource/xml/" + stringArray[j]);
                            fileOutputStream = new FileOutputStream((File)object);
                            this.transfer(inputStream, fileOutputStream);
                            Log.d((String)"OZViewer", (String)("file [" + stringArray[j] + "] copy ok"));
                        }
                        catch (Exception exception) {
                            Log.e((String)"OZViewer", (String)"file copy error", (Throwable)exception);
                            var15_20 = null;
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (fileOutputStream == null) continue;
                            fileOutputStream.close();
                            continue;
                        }
                        var15_20 = null;
                        if (inputStream == null) break block17;
                    }
                    catch (Throwable throwable) {
                        var15_20 = null;
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (fileOutputStream == null) throw throwable;
                        fileOutputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                if (fileOutputStream == null) continue;
                fileOutputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Log.e((String)"OZViewer", (String)"file not founded.", (Throwable)iOException);
        }
    }

    private void transfer(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[2048];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public ViewGroup getParentView() {
        return this._parentView;
    }

    public String getCacheTmpDir() {
        String string = this._parentView.getContext().getExternalFilesDir(null).toString();
        Log.d((String)"OZViewer", (String)("temp folder = " + string));
        return string;
    }

    public String getPackageName() {
        return this._parentView.getContext().getPackageName();
    }

    public String getNativeLibraryFolder() {
        if (this._parentView != null) {
            return this._parentView.getContext().getApplicationInfo().nativeLibraryDir;
        }
        return "";
    }

    public String getPackageResourcePath() {
        if (this._parentView != null) {
            String string = null;
            string = Build.VERSION.SDK_INT < 21 ? Build.CPU_ABI : Build.SUPPORTED_ABIS[0];
            return this._parentView.getContext().getPackageResourcePath() + "!/lib/" + string;
        }
        return "";
    }

    public String getCacheTmpDirUrlCache() {
        String string = this._parentView.getContext().getCacheDir().getAbsolutePath();
        Log.d((String)"OZViewer", (String)("temp url cache folder = " + string));
        return string;
    }

    public String getDefaultLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getDefaultCountry() {
        return Locale.getDefault().getCountry();
    }

    public int getTimezone() {
        return Calendar.getInstance().getTimeZone().getRawOffset();
    }

    public int getDaylight() {
        return Calendar.getInstance().getTimeZone().useDaylightTime() ? 1 : 0;
    }

    public void SetLangAndCountry(String string) {
        OZStorage.m_strLan = string;
    }

    public float getDensityDPI() {
        return OZStorage.getDensityDPI();
    }

    public float getScreenDPI() {
        return OZStorage.getScreenDPI();
    }

    public void dispose() {
        if (!this._disposed) {
            this._disposed = true;
            Log.d((String)"OZViewer", (String)"Call Dispose");
            if (OZLocationManager.getInstance(null) != null) {
                OZLocationManager.getInstance(null).reset();
            }
            if (this._parentView.getParent() != null && this._parentView.getParent().getParent() != null) {
                Log.d((String)"OZViewer", (String)"Remove from parent");
                ((ViewGroup)this._parentView.getParent().getParent()).removeAllViewsInLayout();
            }
            this.setListener(null);
            this.nativeSetListener();
            this.unbindImagePickerAndSignPadReferences(this._parentView);
            this.Script("closeall");
            this.nativeOnDispose();
            this.unbindReferences((View)this._parentView);
            System.clearProperty("OZ_HTTP_REQUEST_TIMEOUT");
            if (Build.VERSION.SDK_INT <= 23) {
                Runtime.getRuntime().gc();
                System.runFinalization();
                Handler handler = new Handler();
                handler.postDelayed((Runnable)new OZReportViewerImpl$1(this), 1000L);
            }
        }
    }

    public void setListener(OZReportCommandListener oZReportCommandListener) {
        this.m_listener = oZReportCommandListener;
    }

    public OZReportCommandListener getListener() {
        return this.m_listener;
    }

    public void setCustomUICheckListener(OZReportCustomUICheckListener oZReportCustomUICheckListener) {
        this.nativeSetCustomUICheckListener(oZReportCustomUICheckListener);
    }

    protected void finalize() {
        super.finalize();
        this.dispose();
    }

    protected native void initInstance();

    protected native void nativeOnDispose();

    protected native void nativeSetListener();

    protected native void nativeSetCustomUICheckListener(OZReportCustomUICheckListener var1);

    public void CreateReport(String string) {
        this.CreateReportEx(string);
    }

    public void CreateReportEx(String string) {
        this.CreateReportEx(string, "\n");
    }

    public native void CreateReportEx(String var1, String var2);

    public native void NewReport(String var1, String var2);

    public native void SetUserOption(String var1, String var2);

    public native void SetImagePickerImage(boolean var1, byte[] var2, int var3, String var4, int var5);

    private native void DismissAttachmentDialog();

    private native void AddAttachment(boolean var1, byte[] var2, int var3, String var4, String var5);

    public void ReBind(int n, String string, String string2) {
        this.ReBind(n, string, string2, "\n", true);
    }

    public void ReBind(int n, String string, String string2, boolean bl) {
        this.ReBind(n, string, string2, "\n", bl);
    }

    public void ReBind(int n, String string, String string2, String string3) {
        this.ReBind(n, string, string2, string3, true);
    }

    public native void ReBind(int var1, String var2, String var3, String var4, boolean var5);

    public native String GetInformation(String var1);

    public native void Script(String var1);

    public native int ScriptEx(String var1, String var2, String var3);

    protected native void ExportStream(String var1, String var2, String var3);

    protected native void copyExportedDirectBuffer(String var1, ByteBuffer var2, int var3);

    public Hashtable GetMemoryStreamByExport(String string, String string2) {
        if (this.m_exportMap != null) {
            this.m_exportMap.clear();
            this.m_exportMap = null;
        }
        this.m_exportMap = new LinkedHashtable();
        this.ExportStream("save", string, string2);
        return this.m_exportMap;
    }

    public void enumExportedStream(String string, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        this.copyExportedDirectBuffer(string, byteBuffer, n);
        this.m_exportMap.put(string, new OZDirectByteBufferInputStream(byteBuffer, 0, n));
    }

    public native void preLoadRepositoryAddItem(String var1, String var2);

    public native byte[] preLoadRepositoryStart();

    public native byte[] preLoadRepositoryResponse(byte[] var1);

    public native String preLoadRepositoryGetLastError();

    public native void preLoadRepositoryInitParam(String var1, String var2);

    public native boolean preLoadRepositoryDownload();

    public native void preLoadRepositoryAddBinary(String var1, InputStream var2, boolean var3);

    public native void nativeDocument(OZRViewerCmdImpl var1);

    public OZRViewerCmd Document() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd;
    }

    public void unbindReferences(View view) {
        try {
            if (view != null) {
                this.unbindViewReferences(view);
                if (view instanceof ViewGroup) {
                    this.unbindViewGroupReferences((ViewGroup)view);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unbindImagePickerAndSignPadReferences(ViewGroup viewGroup) {
        InputMethodManager inputMethodManager = (InputMethodManager)this._parentView.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(((Activity)this._parentView.getContext()).getWindow().getDecorView().getWindowToken(), 0);
        int n = viewGroup.getChildCount();
        for (int j = 0; j < n; ++j) {
            OZInputComponent oZInputComponent;
            View view = viewGroup.getChildAt(j);
            if (view instanceof ICImagePickerWnd) {
                oZInputComponent = (ICImagePickerWnd)view;
                ((ICImagePickerWnd)oZInputComponent).closeWindow(true);
                ((ICImagePickerWnd)oZInputComponent).removeAllObject();
                continue;
            }
            if (view instanceof ICSignPadWnd) {
                oZInputComponent = (ICSignPadWnd)view;
                ((ICSignPadWnd)oZInputComponent).closeWindow();
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.unbindImagePickerAndSignPadReferences((ViewGroup)view);
        }
    }

    private void unbindViewGroupReferences(ViewGroup viewGroup) {
        int n = viewGroup.getChildCount();
        for (int j = 0; j < n; ++j) {
            View view = viewGroup.getChildAt(j);
            this.unbindViewReferences(view);
            if (!(view instanceof ViewGroup)) continue;
            this.unbindViewGroupReferences((ViewGroup)view);
        }
        try {
            viewGroup.removeAllViews();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unbindViewReferences(View view) {
        FrameLayout frameLayout;
        try {
            if (view instanceof OZPageView) {
                frameLayout = (OZPageView)view;
                frameLayout.removeAllObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (view instanceof MainFrameView) {
                frameLayout = (MainFrameView)view;
                frameLayout.removeAllObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnClickListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnCreateContextMenuListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnFocusChangeListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnKeyListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnLongClickListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnClickListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setTouchDelegate(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        frameLayout = view.getBackground();
        if (frameLayout != null) {
            try {
                frameLayout.setCallback(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            frameLayout = imageView.getDrawable();
            if (frameLayout != null) {
                frameLayout.setCallback(null);
            }
            if (frameLayout instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)frameLayout).getBitmap();
                bitmap.recycle();
            }
            imageView.setImageDrawable(null);
        } else if (view instanceof WebView) {
            ((WebView)view).destroyDrawingCache();
            ((WebView)view).destroy();
        }
        try {
            view.setBackgroundDrawable(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setAnimation(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setContentDescription(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setTag(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean Document_SetChartStyle(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.SetChartStyle(string);
    }

    public boolean Document_PingOZServer(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.PingOZServer(string);
    }

    public boolean Document_PingOZServer(String string, int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.PingOZServer(string, n);
    }

    public Object Document_GetGlobal(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetGlobal(string);
    }

    public Object Document_GetGlobal(String string, int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetGlobal(string, n);
    }

    public boolean Document_SetGlobal(String string, Object object) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.SetGlobal(string, object);
    }

    public boolean Document_SetGlobal(String string, Object object, int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.SetGlobal(string, object, n);
    }

    public String Document_GetTitle() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetTitle();
    }

    public float Document_GetPaperWidth() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetPaperWidth();
    }

    public float Document_GetPaperHeight() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetPaperHeight();
    }

    public String Document_TriggerExternalEvent() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent();
    }

    public String Document_TriggerExternalEvent(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string);
    }

    public String Document_TriggerExternalEvent(String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string, string2);
    }

    public String Document_TriggerExternalEvent(String string, String string2, String string3) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string, string2, string3);
    }

    public String Document_TriggerExternalEvent(String string, String string2, String string3, String string4) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string, string2, string3, string4);
    }

    public String Document_TriggerExternalEventByDocIndex(int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string, string2);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string, String string2, String string3) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string, string2, string3);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string, String string2, String string3, String string4) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string, string2, string3, string4);
    }

    public String Document_TriggerLocationUpdated(String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerLocationUpdated(string, string2);
    }

    public String Document_TriggerLocationUpdatedByDocIndex(int n, String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerLocationUpdatedByDocIndex(n, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onActivityResult(Activity var1_1, int var2_2, int var3_3, Intent var4_4) {
        var5_5 = false;
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = 0;
        var10_10 = false;
        switch (var2_2) {
            case 13001: 
            case 13005: 
            case 13203: {
                if (var3_3 != -1) ** GOTO lbl90
                var11_11 = null;
                try {
                    var12_18 = var4_4.getData();
                    if (var12_18 == null) ** GOTO lbl39
                    var13_27 = var1_1.getContentResolver().query(var12_18, null, null, null, null);
                    if (var13_27 != null && var13_27.moveToFirst()) {
                        var14_30 = var13_27.getColumnIndex("_data");
                        if (var14_30 == -1) {
                            var14_30 = var13_27.getColumnIndex("_display_name");
                        }
                        var15_35 = var13_27.getColumnIndex("orientation");
                        if (var14_30 > -1) {
                            var8_8 = var13_27.getString(var14_30);
                        }
                        if (var15_35 > -1) {
                            var9_9 = var13_27.getInt(var15_35);
                        }
                        if ((var16_42 = var13_27.getColumnIndex("mime_type")) > -1 && (var17_43 = var13_27.getString(var16_42)).equalsIgnoreCase("image/png")) {
                            var10_10 = true;
                        }
                    }
                    if (var8_8 == null) {
                        var8_8 = var12_18.getPath();
                    }
                    if (var13_27 != null) {
                        var13_27.close();
                    }
                    if ((var11_11 = var1_1.getContentResolver().openInputStream(var12_18)) == null) ** GOTO lbl39
                    var14_30 = var11_11.available();
                    var6_6 = new byte[var14_30];
                    var11_11.read(var6_6, 0, var14_30);
                    var11_11.close();
                    var5_5 = true;
lbl39:
                    // 3 sources

                    var19_44 = null;
                    ** if (var11_11 == null) goto lbl-1000
                }
                catch (Throwable var18_54) {
                    var19_48 = null;
                    if (var11_11 != null) {
                        try {
                            var11_11.close();
                        }
                        catch (IOException var20_53) {
                            var20_53.printStackTrace();
                        }
                    }
                    throw var18_54;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var11_11.close();
                    }
                    catch (IOException var20_49) {
                        var20_49.printStackTrace();
                    }
                }
lbl-1000:
                // 2 sources

                {
                    ** GOTO lbl90
                    catch (FileNotFoundException var12_19) {
                        var12_19.printStackTrace();
                        var19_45 = null;
                        if (var11_11 != null) {
                            try {
                                var11_11.close();
                            }
                            catch (IOException var20_50) {
                                var20_50.printStackTrace();
                            }
                        }
                        ** GOTO lbl90
                    }
                    catch (IOException var12_20) {
                        var12_20.printStackTrace();
                        var19_46 = null;
                        if (var11_11 != null) {
                            try {
                                var11_11.close();
                            }
                            catch (IOException var20_51) {
                                var20_51.printStackTrace();
                            }
                        }
                        ** GOTO lbl90
                    }
                    catch (Throwable var12_21) {
                        var12_21.printStackTrace();
                        var19_47 = null;
                        if (var11_11 != null) {
                            try {
                                var11_11.close();
                            }
                            catch (IOException var20_52) {
                                var20_52.printStackTrace();
                            }
                        }
                    }
                }
lbl90:
                // 9 sources

                if (var2_2 == 13001) {
                    if (var5_5) {
                        this.SetImagePickerImage(false, var6_6, var6_6.length, var8_8, var9_9);
                    } else {
                        this.SetImagePickerImage(true, null, 0, null, 0);
                    }
                    ICImagePickerWnd.isStartGallay = false;
                    break;
                }
                if (var2_2 == 13203) {
                    if (var5_5) {
                        var11_11 = MimeTypeMap.getSingleton().getExtensionFromMimeType(var1_1.getContentResolver().getType(var4_4.getData()));
                        this.AddAttachment(false, var6_6, var6_6.length, var8_8, (String)var11_11);
                        break;
                    }
                    this.AddAttachment(true, null, 0, null, null);
                    break;
                }
                try {
                    var11_11 = BitmapFactory.decodeByteArray(var6_6, (int)0, (int)var6_6.length);
                    if (var11_11 == null) break;
                    if (var9_9 != 0) {
                        var12_18 = new Matrix();
                        var12_18.setRotate((float)var9_9);
                        var13_27 = Bitmap.createBitmap((Bitmap)var11_11, (int)0, (int)0, (int)var11_11.getWidth(), (int)var11_11.getHeight(), (Matrix)var12_18, (boolean)true);
                        var11_11.recycle();
                        var11_11 = var13_27;
                    }
                    if ((var12_18 = var1_1.findViewById(52520725)) == null || !(var12_18 instanceof MainFrameView)) break;
                    ((MainFrameView)var12_18).m_isPng = var10_10;
                    ((MainFrameView)var12_18).getOverlayLayout().getCommentManager().openImage((Bitmap)var11_11);
                }
                catch (Exception var11_12) {
                    var11_12.printStackTrace();
                }
                break;
            }
            case 13003: 
            case 13004: 
            case 13202: {
                if (var3_3 != -1) ** GOTO lbl210
                var11_13 = null;
                try {
                    var12_22 = var1_1.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                    var13_28 = new File(var12_22, "OZ_TMP_IMAGE");
                    if (!var13_28.exists()) ** GOTO lbl159
                    var8_8 = var13_28.toString();
                    try {
                        var14_31 = new ExifInterface(var8_8);
                        var15_36 = var14_31.getAttributeInt("Orientation", -65535);
                        if (var15_36 != -65535) {
                            switch (var15_36) {
                                default: {
                                    var9_9 = 0;
                                    break;
                                }
                                case 6: {
                                    var9_9 = 90;
                                    break;
                                }
                                case 3: {
                                    var9_9 = 180;
                                    break;
                                }
                                case 8: {
                                    var9_9 = 270;
                                }
                            }
                        }
                    }
                    catch (IOException var14_32) {
                        var14_32.printStackTrace();
                    }
                    var11_13 = new FileInputStream(var13_28);
                    if (var11_13 != null) {
                        var14_33 = var11_13.available();
                        var6_6 = new byte[var14_33];
                        var11_13.read(var6_6, 0, var14_33);
                        var11_13.close();
                        var5_5 = true;
                    }
                    var13_28.delete();
lbl159:
                    // 2 sources

                    var22_55 = null;
                    ** if (var11_13 == null) goto lbl-1000
                }
                catch (Throwable var21_65) {
                    var22_59 = null;
                    if (var11_13 != null) {
                        try {
                            var11_13.close();
                        }
                        catch (IOException var23_64) {
                            var23_64.printStackTrace();
                        }
                    }
                    throw var21_65;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var11_13.close();
                    }
                    catch (IOException var23_60) {
                        var23_60.printStackTrace();
                    }
                }
lbl-1000:
                // 2 sources

                {
                    ** GOTO lbl210
                    catch (FileNotFoundException var12_23) {
                        var12_23.printStackTrace();
                        var22_56 = null;
                        if (var11_13 != null) {
                            try {
                                var11_13.close();
                            }
                            catch (IOException var23_61) {
                                var23_61.printStackTrace();
                            }
                        }
                        ** GOTO lbl210
                    }
                    catch (IOException var12_24) {
                        var12_24.printStackTrace();
                        var22_57 = null;
                        if (var11_13 != null) {
                            try {
                                var11_13.close();
                            }
                            catch (IOException var23_62) {
                                var23_62.printStackTrace();
                            }
                        }
                        ** GOTO lbl210
                    }
                    catch (Throwable var12_25) {
                        var12_25.printStackTrace();
                        var22_58 = null;
                        if (var11_13 != null) {
                            try {
                                var11_13.close();
                            }
                            catch (IOException var23_63) {
                                var23_63.printStackTrace();
                            }
                        }
                    }
                }
lbl210:
                // 9 sources

                if (var2_2 == 13003) {
                    if (var5_5) {
                        this.SetImagePickerImage(false, var6_6, var6_6.length, var8_8, var9_9);
                    } else {
                        this.SetImagePickerImage(true, null, 0, null, 0);
                    }
                    ICImagePickerWnd.isStartGallay = false;
                    break;
                }
                if (var2_2 == 13202) {
                    if (var5_5) {
                        this.AddAttachment(false, var6_6, var6_6.length, var8_8, "jpg");
                        break;
                    }
                    this.AddAttachment(true, null, 0, null, null);
                    break;
                }
                try {
                    var11_13 = BitmapFactory.decodeByteArray(var6_6, (int)0, (int)var6_6.length);
                    if (var11_13 == null) break;
                    if (var9_9 != 0) {
                        var12_22 = new Matrix();
                        var12_22.setRotate(var9_9);
                        var13_28 = Bitmap.createBitmap((Bitmap)var11_13, (int)0, (int)0, (int)var11_13.getWidth(), (int)var11_13.getHeight(), (Matrix)var12_22, (boolean)true);
                        var11_13.recycle();
                        var11_13 = var13_28;
                    }
                    if ((var12_22 = var1_1.findViewById(52520725)) == null || !(var12_22 instanceof MainFrameView)) break;
                    ((MainFrameView)var12_22).getOverlayLayout().getCommentManager().openImage((Bitmap)var11_13);
                }
                catch (Exception var11_14) {
                    var11_14.printStackTrace();
                }
                break;
            }
            case 13101: {
                var11_15 = new File(OZStorage.tmpCacheDir + "/OZVoiceRecorder_history.m4a");
                if (!var11_15.exists()) break;
                var11_15.delete();
                break;
            }
            case 13102: {
                var11_16 = new File(OZStorage.tmpCacheDir + "/OZAttachment_history.pdf");
                if (!var11_16.exists()) break;
                var11_16.delete();
                break;
            }
            case 13201: {
                if (var3_3 != -1) break;
                var13_29 = null;
                var14_34 = null;
                var11_17 = var4_4.getData();
                var12_26 = var11_17.getPath();
                try {
                    if (var11_17 != null) {
                        var14_34 = this._parentView.getContext().getContentResolver().openFileDescriptor(var11_17, "r");
                        var13_29 = new ParcelFileDescriptor.AutoCloseInputStream(var14_34);
                    }
                    if (var13_29 != null) {
                        var15_37 = var13_29.available();
                        var7_7 = new byte[var15_37];
                        var13_29.read(var7_7, 0, var15_37);
                        var13_29.close();
                        var5_5 = true;
                    }
                }
                catch (FileNotFoundException var15_38) {
                    var15_38.printStackTrace();
                }
                catch (IOException var15_39) {
                    var15_39.printStackTrace();
                }
                catch (Throwable var15_40) {
                    var15_40.printStackTrace();
                }
                if (var5_5) {
                    var15_41 = MimeTypeMap.getSingleton().getExtensionFromMimeType(var1_1.getContentResolver().getType(var11_17));
                    this.AddAttachment(false, var7_7, var7_7.length, var8_8, var15_41);
                    break;
                }
                this.AddAttachment(true, null, 0, null, null);
            }
        }
    }

    private void copyFileParcel(Uri uri, String string) {
        ParcelFileDescriptor parcelFileDescriptor = null;
        File file = new File(string);
        try {
            if (uri != null) {
                parcelFileDescriptor = this._parentView.getContext().getContentResolver().openFileDescriptor(uri, "r");
                ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = autoCloseInputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                autoCloseInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String makeAddPDFParam(String string) {
        String string2 = "repository_agent.type=local";
        int n = string.lastIndexOf("/");
        if (n > -1) {
            string2 = string2 + "\nrepository_agent.local.root_path=" + string.substring(0, n);
            string2 = string2 + "\nconnection.reportname=" + string.substring(n + 1);
        }
        return string2;
    }
}

