/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONObject;
import oz.lottie.LottieComposition;
import oz.lottie.LottieCompositionFactory$1;
import oz.lottie.LottieCompositionFactory$10;
import oz.lottie.LottieCompositionFactory$11;
import oz.lottie.LottieCompositionFactory$2;
import oz.lottie.LottieCompositionFactory$3;
import oz.lottie.LottieCompositionFactory$4;
import oz.lottie.LottieCompositionFactory$5;
import oz.lottie.LottieCompositionFactory$6;
import oz.lottie.LottieCompositionFactory$7;
import oz.lottie.LottieCompositionFactory$8;
import oz.lottie.LottieCompositionFactory$9;
import oz.lottie.LottieImageAsset;
import oz.lottie.LottieResult;
import oz.lottie.LottieTask;
import oz.lottie.custom.okio.Okio;
import oz.lottie.model.LottieCompositionCache;
import oz.lottie.network.NetworkFetcher;
import oz.lottie.parser.LottieCompositionMoshiParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.utils.Utils;

public class LottieCompositionFactory {
    private static final Map taskCache = new HashMap();

    private LottieCompositionFactory() {
    }

    public static void setMaxCacheSize(int n) {
        LottieCompositionCache.getInstance().resize(n);
    }

    public static LottieTask fromUrl(Context context, String string) {
        return LottieCompositionFactory.fromUrl(context, string, "url_" + string);
    }

    public static LottieTask fromUrl(Context context, String string, String string2) {
        return LottieCompositionFactory.cache(string2, new LottieCompositionFactory$1(context, string));
    }

    public static LottieResult fromUrlSync(Context context, String string) {
        return NetworkFetcher.fetchSync(context, string);
    }

    public static LottieTask fromAsset(Context context, String string) {
        String string2 = "asset_" + string;
        return LottieCompositionFactory.fromAsset(context, string, string2);
    }

    public static LottieTask fromAsset(Context context, String string, String string2) {
        Context context2 = context.getApplicationContext();
        return LottieCompositionFactory.cache(string2, new LottieCompositionFactory$2(context2, string, string2));
    }

    public static LottieResult fromAssetSync(Context context, String string) {
        String string2 = "asset_" + string;
        return LottieCompositionFactory.fromAssetSync(context, string, string2);
    }

    public static LottieResult fromAssetSync(Context context, String string, String string2) {
        try {
            if (string.endsWith(".zip")) {
                return LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(context.getAssets().open(string)), string2);
            }
            return LottieCompositionFactory.fromJsonInputStreamSync(context.getAssets().open(string), string2);
        }
        catch (IOException iOException) {
            return new LottieResult(iOException);
        }
    }

    public static LottieTask fromRawRes(Context context, int n) {
        return LottieCompositionFactory.fromRawRes(context, n, LottieCompositionFactory.rawResCacheKey(context, n));
    }

    public static LottieTask fromRawRes(Context context, int n, String string) {
        WeakReference<Context> weakReference = new WeakReference<Context>(context);
        Context context2 = context.getApplicationContext();
        return LottieCompositionFactory.cache(string, new LottieCompositionFactory$3(weakReference, context2, n));
    }

    public static LottieResult fromRawResSync(Context context, int n) {
        return LottieCompositionFactory.fromRawResSync(context, n, LottieCompositionFactory.rawResCacheKey(context, n));
    }

    public static LottieResult fromRawResSync(Context context, int n, String string) {
        try {
            return LottieCompositionFactory.fromJsonInputStreamSync(context.getResources().openRawResource(n), string);
        }
        catch (Resources.NotFoundException notFoundException) {
            return new LottieResult(notFoundException);
        }
    }

    private static String rawResCacheKey(Context context, int n) {
        return "rawRes" + (LottieCompositionFactory.isNightMode(context) ? "_night_" : "_day_") + n;
    }

    private static boolean isNightMode(Context context) {
        int n = context.getResources().getConfiguration().uiMode & 0x30;
        return n == 32;
    }

    public static LottieTask fromJsonInputStream(InputStream inputStream, String string) {
        return LottieCompositionFactory.cache(string, new LottieCompositionFactory$4(inputStream, string));
    }

    public static LottieResult fromJsonInputStreamSync(InputStream inputStream, String string) {
        return LottieCompositionFactory.fromJsonInputStreamSync(inputStream, string, true);
    }

    private static LottieResult fromJsonInputStreamSync(InputStream inputStream, String string, boolean bl) {
        try {
            LottieResult lottieResult = LottieCompositionFactory.fromJsonReaderSync(JsonReader.of(Okio.buffer(Okio.source(inputStream))), string);
            return lottieResult;
        }
        finally {
            if (bl) {
                Utils.closeQuietly(inputStream);
            }
        }
    }

    public static LottieTask fromJson(JSONObject jSONObject, String string) {
        return LottieCompositionFactory.cache(string, new LottieCompositionFactory$5(jSONObject, string));
    }

    public static LottieResult fromJsonSync(JSONObject jSONObject, String string) {
        return LottieCompositionFactory.fromJsonStringSync(jSONObject.toString(), string);
    }

    public static LottieTask fromJsonString(String string, String string2) {
        return LottieCompositionFactory.cache(string2, new LottieCompositionFactory$6(string, string2));
    }

    public static LottieResult fromJsonStringSync(String string, String string2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return LottieCompositionFactory.fromJsonReaderSync(JsonReader.of(Okio.buffer(Okio.source(byteArrayInputStream))), string2);
    }

    public static LottieTask fromJsonReader(JsonReader jsonReader, String string) {
        return LottieCompositionFactory.cache(string, new LottieCompositionFactory$7(jsonReader, string));
    }

    public static LottieResult fromJsonReaderSync(JsonReader jsonReader, String string) {
        return LottieCompositionFactory.fromJsonReaderSyncInternal(jsonReader, string, true);
    }

    private static LottieResult fromJsonReaderSyncInternal(JsonReader jsonReader, String string, boolean bl) {
        try {
            LottieComposition lottieComposition = LottieCompositionMoshiParser.parse(jsonReader);
            if (string != null) {
                LottieCompositionCache.getInstance().put(string, lottieComposition);
            }
            LottieResult lottieResult = new LottieResult(lottieComposition);
            return lottieResult;
        }
        catch (Exception exception) {
            LottieResult lottieResult = new LottieResult(exception);
            return lottieResult;
        }
        finally {
            if (bl) {
                Utils.closeQuietly(jsonReader);
            }
        }
    }

    public static LottieTask fromZipStream(ZipInputStream zipInputStream, String string) {
        return LottieCompositionFactory.cache(string, new LottieCompositionFactory$8(zipInputStream, string));
    }

    public static LottieResult fromZipStreamSync(ZipInputStream zipInputStream, String string) {
        try {
            LottieResult lottieResult = LottieCompositionFactory.fromZipStreamSyncInternal(zipInputStream, string);
            return lottieResult;
        }
        finally {
            Utils.closeQuietly(zipInputStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static LottieResult fromZipStreamSyncInternal(ZipInputStream zipInputStream, String string) {
        Object object;
        LottieComposition lottieComposition = null;
        HashMap<String, Bitmap> hashMap = new HashMap<String, Bitmap>();
        try {
            void iOException;
            ZipEntry entry = zipInputStream.getNextEntry();
            while (iOException != null) {
                String string2 = iOException.getName();
                if (string2.contains("__MACOSX")) {
                    zipInputStream.closeEntry();
                } else if (iOException.getName().contains(".json")) {
                    object = JsonReader.of(Okio.buffer(Okio.source(zipInputStream)));
                    lottieComposition = (LottieComposition)LottieCompositionFactory.fromJsonReaderSyncInternal((JsonReader)object, null, false).getValue();
                } else if (string2.contains(".png") || string2.contains(".webp")) {
                    object = string2.split("/");
                    String string3 = object[((String[])object).length - 1];
                    hashMap.put(string3, BitmapFactory.decodeStream((InputStream)zipInputStream));
                } else {
                    zipInputStream.closeEntry();
                }
                ZipEntry zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            return new LottieResult(iOException);
        }
        if (lottieComposition == null) {
            return new LottieResult(new IllegalArgumentException("Unable to parse composition"));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = LottieCompositionFactory.findImageAssetForFileName(lottieComposition, (String)entry.getKey());
            if (object == null) continue;
            ((LottieImageAsset)object).setBitmap(Utils.resizeBitmapIfNeeded((Bitmap)entry.getValue(), ((LottieImageAsset)object).getWidth(), ((LottieImageAsset)object).getHeight()));
        }
        for (Map.Entry entry : lottieComposition.getImages().entrySet()) {
            if (((LottieImageAsset)entry.getValue()).getBitmap() != null) continue;
            return new LottieResult(new IllegalStateException("There is no image for " + ((LottieImageAsset)entry.getValue()).getFileName()));
        }
        if (string != null) {
            LottieCompositionCache.getInstance().put(string, lottieComposition);
        }
        return new LottieResult(lottieComposition);
    }

    private static LottieImageAsset findImageAssetForFileName(LottieComposition lottieComposition, String string) {
        for (LottieImageAsset lottieImageAsset : lottieComposition.getImages().values()) {
            if (!lottieImageAsset.getFileName().equals(string)) continue;
            return lottieImageAsset;
        }
        return null;
    }

    private static LottieTask cache(String string, Callable callable) {
        LottieComposition lottieComposition;
        LottieComposition lottieComposition2 = lottieComposition = string == null ? null : LottieCompositionCache.getInstance().get(string);
        if (lottieComposition != null) {
            return new LottieTask(new LottieCompositionFactory$9(lottieComposition));
        }
        if (string != null && taskCache.containsKey(string)) {
            return (LottieTask)taskCache.get(string);
        }
        LottieTask lottieTask = new LottieTask(callable);
        if (string != null) {
            lottieTask.addListener(new LottieCompositionFactory$10(string));
            lottieTask.addFailureListener(new LottieCompositionFactory$11(string));
            taskCache.put(string, lottieTask);
        }
        return lottieTask;
    }

    static /* synthetic */ Map access$0() {
        return taskCache;
    }
}

