/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.keyframe;

import java.util.ArrayList;
import java.util.List;
import oz.lottie.L;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$EmptyKeyframeWrapper;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$KeyframesWrapper;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$KeyframesWrapperImpl;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$SingleKeyframeWrapper;
import oz.lottie.value.Keyframe;
import oz.lottie.value.LottieValueCallback;

public abstract class BaseKeyframeAnimation {
    final List listeners = new ArrayList(1);
    private boolean isDiscrete = false;
    private final BaseKeyframeAnimation$KeyframesWrapper keyframesWrapper;
    protected float progress = 0.0f;
    protected LottieValueCallback valueCallback;
    private Object cachedGetValue = null;
    private float cachedStartDelayProgress = -1.0f;
    private float cachedEndProgress = -1.0f;

    BaseKeyframeAnimation(List list) {
        this.keyframesWrapper = BaseKeyframeAnimation.wrap(list);
    }

    public void setIsDiscrete() {
        this.isDiscrete = true;
    }

    public void addUpdateListener(BaseKeyframeAnimation$AnimationListener baseKeyframeAnimation$AnimationListener) {
        this.listeners.add(baseKeyframeAnimation$AnimationListener);
    }

    public void setProgress(float f2) {
        if (this.keyframesWrapper.isEmpty()) {
            return;
        }
        if (f2 < this.getStartDelayProgress()) {
            f2 = this.getStartDelayProgress();
        } else if (f2 > this.getEndProgress()) {
            f2 = this.getEndProgress();
        }
        if (f2 == this.progress) {
            return;
        }
        this.progress = f2;
        if (this.keyframesWrapper.isValueChanged(f2)) {
            this.notifyListeners();
        }
    }

    public void notifyListeners() {
        int n = 0;
        while (n < this.listeners.size()) {
            ((BaseKeyframeAnimation$AnimationListener)this.listeners.get(n)).onValueChanged();
            ++n;
        }
    }

    protected Keyframe getCurrentKeyframe() {
        L.beginSection("BaseKeyframeAnimation#getCurrentKeyframe");
        Keyframe keyframe = this.keyframesWrapper.getCurrentKeyframe();
        L.endSection("BaseKeyframeAnimation#getCurrentKeyframe");
        return keyframe;
    }

    float getLinearCurrentKeyframeProgress() {
        if (this.isDiscrete) {
            return 0.0f;
        }
        Keyframe keyframe = this.getCurrentKeyframe();
        if (keyframe.isStatic()) {
            return 0.0f;
        }
        float f2 = this.progress - keyframe.getStartProgress();
        float f3 = keyframe.getEndProgress() - keyframe.getStartProgress();
        return f2 / f3;
    }

    protected float getInterpolatedCurrentKeyframeProgress() {
        Keyframe keyframe = this.getCurrentKeyframe();
        if (keyframe.isStatic()) {
            return 0.0f;
        }
        return keyframe.interpolator.getInterpolation(this.getLinearCurrentKeyframeProgress());
    }

    private float getStartDelayProgress() {
        if (this.cachedStartDelayProgress == -1.0f) {
            this.cachedStartDelayProgress = this.keyframesWrapper.getStartDelayProgress();
        }
        return this.cachedStartDelayProgress;
    }

    float getEndProgress() {
        if (this.cachedEndProgress == -1.0f) {
            this.cachedEndProgress = this.keyframesWrapper.getEndProgress();
        }
        return this.cachedEndProgress;
    }

    public Object getValue() {
        Object object;
        float f2 = this.getInterpolatedCurrentKeyframeProgress();
        if (this.valueCallback == null && this.keyframesWrapper.isCachedValueEnabled(f2)) {
            return this.cachedGetValue;
        }
        Keyframe keyframe = this.getCurrentKeyframe();
        this.cachedGetValue = object = this.getValue(keyframe, f2);
        return object;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setValueCallback(LottieValueCallback lottieValueCallback) {
        if (this.valueCallback != null) {
            this.valueCallback.setAnimation(null);
        }
        this.valueCallback = lottieValueCallback;
        if (lottieValueCallback != null) {
            lottieValueCallback.setAnimation(this);
        }
    }

    abstract Object getValue(Keyframe var1, float var2);

    private static BaseKeyframeAnimation$KeyframesWrapper wrap(List list) {
        if (list.isEmpty()) {
            return new BaseKeyframeAnimation$EmptyKeyframeWrapper(null);
        }
        if (list.size() == 1) {
            return new BaseKeyframeAnimation$SingleKeyframeWrapper(list);
        }
        return new BaseKeyframeAnimation$KeyframesWrapperImpl(list);
    }
}

