/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import oz.lottie.custom.okio.AsyncTimeout$1;
import oz.lottie.custom.okio.AsyncTimeout$2;
import oz.lottie.custom.okio.AsyncTimeout$Watchdog;
import oz.lottie.custom.okio.Sink;
import oz.lottie.custom.okio.Source;
import oz.lottie.custom.okio.Timeout;

public class AsyncTimeout
extends Timeout {
    private static AsyncTimeout head;
    private boolean inQueue;
    private AsyncTimeout next;
    private long timeoutAt;

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long l = this.timeoutNanos();
        boolean bl = this.hasDeadline();
        if (l == 0L && !bl) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout(this, l, bl);
    }

    private static synchronized void scheduleTimeout(AsyncTimeout asyncTimeout, long l, boolean bl) {
        if (head == null) {
            head = new AsyncTimeout();
            new AsyncTimeout$Watchdog().start();
        }
        long l2 = System.nanoTime();
        if (l != 0L && bl) {
            asyncTimeout.timeoutAt = l2 + Math.min(l, asyncTimeout.deadlineNanoTime() - l2);
        } else if (l != 0L) {
            asyncTimeout.timeoutAt = l2 + l;
        } else if (bl) {
            asyncTimeout.timeoutAt = asyncTimeout.deadlineNanoTime();
        } else {
            throw new AssertionError();
        }
        long l3 = asyncTimeout.remainingNanos(l2);
        AsyncTimeout asyncTimeout2 = head;
        while (true) {
            if (asyncTimeout2.next == null || l3 < asyncTimeout2.next.remainingNanos(l2)) {
                asyncTimeout.next = asyncTimeout2.next;
                asyncTimeout2.next = asyncTimeout;
                if (asyncTimeout2 != head) break;
                AsyncTimeout.class.notify();
                break;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout asyncTimeout) {
        AsyncTimeout asyncTimeout2 = head;
        while (asyncTimeout2 != null) {
            if (asyncTimeout2.next == asyncTimeout) {
                asyncTimeout2.next = asyncTimeout.next;
                asyncTimeout.next = null;
                return false;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
        return true;
    }

    private long remainingNanos(long l) {
        return this.timeoutAt - l;
    }

    protected void timedOut() {
    }

    public final Sink sink(Sink sink) {
        return new AsyncTimeout$1(this, sink);
    }

    public final Source source(Source source) {
        return new AsyncTimeout$2(this, source);
    }

    final void exit(boolean bl) {
        boolean bl2 = this.exit();
        if (bl2 && bl) {
            throw new InterruptedIOException("timeout");
        }
    }

    final IOException exit(IOException iOException) {
        if (!this.exit()) {
            return iOException;
        }
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        interruptedIOException.initCause(iOException);
        return interruptedIOException;
    }

    private static synchronized AsyncTimeout awaitTimeout() {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        if (asyncTimeout == null) {
            AsyncTimeout.class.wait();
            return null;
        }
        long l = asyncTimeout.remainingNanos(System.nanoTime());
        if (l > 0L) {
            long l2 = l / 1000000L;
            AsyncTimeout.class.wait(l2, (int)(l -= l2 * 1000000L));
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    static /* synthetic */ AsyncTimeout access$0() {
        return AsyncTimeout.awaitTimeout();
    }
}

