/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import oz.lottie.custom.okio.AsyncTimeout;
import oz.lottie.custom.okio.BufferedSink;
import oz.lottie.custom.okio.BufferedSource;
import oz.lottie.custom.okio.Okio$1;
import oz.lottie.custom.okio.Okio$2;
import oz.lottie.custom.okio.Okio$3;
import oz.lottie.custom.okio.RealBufferedSink;
import oz.lottie.custom.okio.RealBufferedSource;
import oz.lottie.custom.okio.Sink;
import oz.lottie.custom.okio.Source;
import oz.lottie.custom.okio.Timeout;

public final class Okio {
    private static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(OutputStream outputStream, Timeout timeout) {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Okio$1(timeout, outputStream);
    }

    public static Sink sink(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(socket);
        Sink sink = Okio.sink(socket.getOutputStream(), asyncTimeout);
        return asyncTimeout.sink(sink);
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(InputStream inputStream, Timeout timeout) {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Okio$2(timeout, inputStream);
    }

    public static Source source(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.source(new FileInputStream(file));
    }

    public static Source source(Path path, OpenOption ... openOptionArray) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.source(Files.newInputStream(path, openOptionArray));
    }

    public static Sink sink(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file, true));
    }

    public static Sink sink(Path path, OpenOption ... openOptionArray) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.sink(Files.newOutputStream(path, openOptionArray));
    }

    public static Source source(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(socket);
        Source source = Okio.source(socket.getInputStream(), asyncTimeout);
        return asyncTimeout.source(source);
    }

    private static AsyncTimeout timeout(Socket socket) {
        return new Okio$3(socket);
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }
}

