/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oz.lottie.L;
import oz.lottie.LottieComposition;
import oz.lottie.LottieDrawable;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.content.DrawingContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.FloatKeyframeAnimation;
import oz.lottie.animation.keyframe.MaskKeyframeAnimation;
import oz.lottie.animation.keyframe.TransformKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.KeyPathElement;
import oz.lottie.model.content.Mask;
import oz.lottie.model.content.Mask$MaskMode;
import oz.lottie.model.layer.BaseLayer$1;
import oz.lottie.model.layer.CompositionLayer;
import oz.lottie.model.layer.ImageLayer;
import oz.lottie.model.layer.Layer;
import oz.lottie.model.layer.Layer$MatteType;
import oz.lottie.model.layer.NullLayer;
import oz.lottie.model.layer.ShapeLayer;
import oz.lottie.model.layer.SolidLayer;
import oz.lottie.model.layer.TextLayer;
import oz.lottie.utils.Logger;
import oz.lottie.utils.Utils;
import oz.lottie.value.LottieValueCallback;

public abstract class BaseLayer
implements DrawingContent,
BaseKeyframeAnimation$AnimationListener,
KeyPathElement {
    private static final int CLIP_SAVE_FLAG = 2;
    private static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    private static final int MATRIX_SAVE_FLAG = 1;
    private static final int SAVE_FLAGS = 19;
    private final Path path = new Path();
    private final Matrix matrix = new Matrix();
    private final Paint contentPaint = new LPaint(1);
    private final Paint dstInPaint = new LPaint(1, PorterDuff.Mode.DST_IN);
    private final Paint dstOutPaint = new LPaint(1, PorterDuff.Mode.DST_OUT);
    private final Paint mattePaint = new LPaint(1);
    private final Paint clearPaint = new LPaint(PorterDuff.Mode.CLEAR);
    private final RectF rect = new RectF();
    private final RectF maskBoundsRect = new RectF();
    private final RectF matteBoundsRect = new RectF();
    private final RectF tempMaskBoundsRect = new RectF();
    private final String drawTraceName;
    final Matrix boundsMatrix = new Matrix();
    final LottieDrawable lottieDrawable;
    final Layer layerModel;
    private MaskKeyframeAnimation mask;
    private BaseLayer matteLayer;
    private BaseLayer parentLayer;
    private List parentLayers;
    private final List animations = new ArrayList();
    final TransformKeyframeAnimation transform;
    private boolean visible = true;

    static BaseLayer forModel(Layer layer, LottieDrawable lottieDrawable, LottieComposition lottieComposition) {
        switch (layer.getLayerType()) {
            case SHAPE: {
                return new ShapeLayer(lottieDrawable, layer);
            }
            case PRE_COMP: {
                return new CompositionLayer(lottieDrawable, layer, lottieComposition.getPrecomps(layer.getRefId()), lottieComposition);
            }
            case SOLID: {
                return new SolidLayer(lottieDrawable, layer);
            }
            case IMAGE: {
                return new ImageLayer(lottieDrawable, layer);
            }
            case NULL: {
                return new NullLayer(lottieDrawable, layer);
            }
            case TEXT: {
                return new TextLayer(lottieDrawable, layer);
            }
        }
        Logger.warning("Unknown layer type " + (Object)((Object)layer.getLayerType()));
        return null;
    }

    BaseLayer(LottieDrawable lottieDrawable, Layer layer) {
        this.lottieDrawable = lottieDrawable;
        this.layerModel = layer;
        this.drawTraceName = String.valueOf(layer.getName()) + "#draw";
        if (layer.getMatteType() == Layer$MatteType.INVERT) {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        } else {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        }
        this.transform = layer.getTransform().createAnimation();
        this.transform.addListener(this);
        if (layer.getMasks() != null && !layer.getMasks().isEmpty()) {
            this.mask = new MaskKeyframeAnimation(layer.getMasks());
            for (BaseKeyframeAnimation baseKeyframeAnimation : this.mask.getMaskAnimations()) {
                baseKeyframeAnimation.addUpdateListener(this);
            }
            for (BaseKeyframeAnimation baseKeyframeAnimation : this.mask.getOpacityAnimations()) {
                this.addAnimation(baseKeyframeAnimation);
                baseKeyframeAnimation.addUpdateListener(this);
            }
        }
        this.setupInOutAnimations();
    }

    @Override
    public void onValueChanged() {
        this.invalidateSelf();
    }

    Layer getLayerModel() {
        return this.layerModel;
    }

    void setMatteLayer(BaseLayer baseLayer) {
        this.matteLayer = baseLayer;
    }

    boolean hasMatteOnThisLayer() {
        return this.matteLayer != null;
    }

    void setParentLayer(BaseLayer baseLayer) {
        this.parentLayer = baseLayer;
    }

    private void setupInOutAnimations() {
        if (!this.layerModel.getInOutKeyframes().isEmpty()) {
            FloatKeyframeAnimation floatKeyframeAnimation = new FloatKeyframeAnimation(this.layerModel.getInOutKeyframes());
            floatKeyframeAnimation.setIsDiscrete();
            floatKeyframeAnimation.addUpdateListener(new BaseLayer$1(this, floatKeyframeAnimation));
            this.setVisible(((Float)floatKeyframeAnimation.getValue()).floatValue() == 1.0f);
            this.addAnimation(floatKeyframeAnimation);
        } else {
            this.setVisible(true);
        }
    }

    private void invalidateSelf() {
        this.lottieDrawable.invalidateSelf();
    }

    public void addAnimation(BaseKeyframeAnimation baseKeyframeAnimation) {
        if (baseKeyframeAnimation == null) {
            return;
        }
        this.animations.add(baseKeyframeAnimation);
    }

    public void removeAnimation(BaseKeyframeAnimation baseKeyframeAnimation) {
        this.animations.remove(baseKeyframeAnimation);
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.buildParentLayerListIfNeeded();
        this.boundsMatrix.set(matrix);
        if (bl) {
            if (this.parentLayers != null) {
                int n = this.parentLayers.size() - 1;
                while (n >= 0) {
                    this.boundsMatrix.preConcat(((BaseLayer)this.parentLayers.get((int)n)).transform.getMatrix());
                    --n;
                }
            } else if (this.parentLayer != null) {
                this.boundsMatrix.preConcat(this.parentLayer.transform.getMatrix());
            }
        }
        this.boundsMatrix.preConcat(this.transform.getMatrix());
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, int n) {
        L.beginSection(this.drawTraceName);
        if (!this.visible || this.layerModel.isHidden()) {
            L.endSection(this.drawTraceName);
            return;
        }
        this.buildParentLayerListIfNeeded();
        L.beginSection("Layer#parentMatrix");
        this.matrix.reset();
        this.matrix.set(matrix);
        int n2 = this.parentLayers.size() - 1;
        while (n2 >= 0) {
            this.matrix.preConcat(((BaseLayer)this.parentLayers.get((int)n2)).transform.getMatrix());
            --n2;
        }
        L.endSection("Layer#parentMatrix");
        n2 = this.transform.getOpacity() == null ? 100 : (Integer)this.transform.getOpacity().getValue();
        int n3 = (int)((float)n / 255.0f * (float)n2 / 100.0f * 255.0f);
        if (!this.hasMatteOnThisLayer() && !this.hasMasksOnThisLayer()) {
            this.matrix.preConcat(this.transform.getMatrix());
            L.beginSection("Layer#drawLayer");
            this.drawLayer(canvas, this.matrix, n3);
            L.endSection("Layer#drawLayer");
            this.recordRenderTime(L.endSection(this.drawTraceName));
            return;
        }
        L.beginSection("Layer#computeBounds");
        this.getBounds(this.rect, this.matrix, false);
        this.intersectBoundsWithMatte(this.rect, matrix);
        this.matrix.preConcat(this.transform.getMatrix());
        this.intersectBoundsWithMask(this.rect, this.matrix);
        if (!this.rect.intersect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight())) {
            this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
        L.endSection("Layer#computeBounds");
        if (!this.rect.isEmpty()) {
            L.beginSection("Layer#saveLayer");
            this.contentPaint.setAlpha(255);
            Utils.saveLayerCompat(canvas, this.rect, this.contentPaint);
            L.endSection("Layer#saveLayer");
            this.clearCanvas(canvas);
            L.beginSection("Layer#drawLayer");
            this.drawLayer(canvas, this.matrix, n3);
            L.endSection("Layer#drawLayer");
            if (this.hasMasksOnThisLayer()) {
                this.applyMasks(canvas, this.matrix);
            }
            if (this.hasMatteOnThisLayer()) {
                L.beginSection("Layer#drawMatte");
                L.beginSection("Layer#saveLayer");
                Utils.saveLayerCompat(canvas, this.rect, this.mattePaint, 19);
                L.endSection("Layer#saveLayer");
                this.clearCanvas(canvas);
                this.matteLayer.draw(canvas, matrix, n3);
                L.beginSection("Layer#restoreLayer");
                canvas.restore();
                L.endSection("Layer#restoreLayer");
                L.endSection("Layer#drawMatte");
            }
            L.beginSection("Layer#restoreLayer");
            canvas.restore();
            L.endSection("Layer#restoreLayer");
        }
        this.recordRenderTime(L.endSection(this.drawTraceName));
    }

    private void recordRenderTime(float f2) {
        this.lottieDrawable.getComposition().getPerformanceTracker().recordRenderTime(this.layerModel.getName(), f2);
    }

    private void clearCanvas(Canvas canvas) {
        L.beginSection("Layer#clearLayer");
        canvas.drawRect(this.rect.left - 1.0f, this.rect.top - 1.0f, this.rect.right + 1.0f, this.rect.bottom + 1.0f, this.clearPaint);
        L.endSection("Layer#clearLayer");
    }

    private void intersectBoundsWithMask(RectF rectF, Matrix matrix) {
        this.maskBoundsRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        if (!this.hasMasksOnThisLayer()) {
            return;
        }
        int n = this.mask.getMasks().size();
        int n2 = 0;
        while (n2 < n) {
            Mask mask = (Mask)this.mask.getMasks().get(n2);
            BaseKeyframeAnimation baseKeyframeAnimation = (BaseKeyframeAnimation)this.mask.getMaskAnimations().get(n2);
            Path path = (Path)baseKeyframeAnimation.getValue();
            this.path.set(path);
            this.path.transform(matrix);
            switch (mask.getMaskMode()) {
                case MASK_MODE_NONE: {
                    return;
                }
                case MASK_MODE_SUBTRACT: {
                    return;
                }
                case MASK_MODE_ADD: 
                case MASK_MODE_INTERSECT: {
                    if (!mask.isInverted()) break;
                    return;
                }
            }
            this.path.computeBounds(this.tempMaskBoundsRect, false);
            if (n2 == 0) {
                this.maskBoundsRect.set(this.tempMaskBoundsRect);
            } else {
                this.maskBoundsRect.set(Math.min(this.maskBoundsRect.left, this.tempMaskBoundsRect.left), Math.min(this.maskBoundsRect.top, this.tempMaskBoundsRect.top), Math.max(this.maskBoundsRect.right, this.tempMaskBoundsRect.right), Math.max(this.maskBoundsRect.bottom, this.tempMaskBoundsRect.bottom));
            }
            ++n2;
        }
        n2 = rectF.intersect(this.maskBoundsRect) ? 1 : 0;
        if (n2 == 0) {
            rectF.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void intersectBoundsWithMatte(RectF rectF, Matrix matrix) {
        if (!this.hasMatteOnThisLayer()) {
            return;
        }
        if (this.layerModel.getMatteType() == Layer$MatteType.INVERT) {
            return;
        }
        this.matteBoundsRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.matteLayer.getBounds(this.matteBoundsRect, matrix, true);
        boolean bl = rectF.intersect(this.matteBoundsRect);
        if (!bl) {
            rectF.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    abstract void drawLayer(Canvas var1, Matrix var2, int var3);

    private void applyMasks(Canvas canvas, Matrix matrix) {
        L.beginSection("Layer#saveLayer");
        Utils.saveLayerCompat(canvas, this.rect, this.dstInPaint, 19);
        if (Build.VERSION.SDK_INT < 28) {
            canvas.drawColor(0);
        }
        L.endSection("Layer#saveLayer");
        int n = 0;
        while (n < this.mask.getMasks().size()) {
            Mask mask = (Mask)this.mask.getMasks().get(n);
            BaseKeyframeAnimation baseKeyframeAnimation = (BaseKeyframeAnimation)this.mask.getMaskAnimations().get(n);
            BaseKeyframeAnimation baseKeyframeAnimation2 = (BaseKeyframeAnimation)this.mask.getOpacityAnimations().get(n);
            switch (mask.getMaskMode()) {
                case MASK_MODE_NONE: {
                    if (!this.areAllMasksNone()) break;
                    this.contentPaint.setAlpha(255);
                    canvas.drawRect(this.rect, this.contentPaint);
                    break;
                }
                case MASK_MODE_ADD: {
                    if (mask.isInverted()) {
                        this.applyInvertedAddMask(canvas, matrix, mask, baseKeyframeAnimation, baseKeyframeAnimation2);
                        break;
                    }
                    this.applyAddMask(canvas, matrix, mask, baseKeyframeAnimation, baseKeyframeAnimation2);
                    break;
                }
                case MASK_MODE_SUBTRACT: {
                    if (n == 0) {
                        this.contentPaint.setColor(-16777216);
                        this.contentPaint.setAlpha(255);
                        canvas.drawRect(this.rect, this.contentPaint);
                    }
                    if (mask.isInverted()) {
                        this.applyInvertedSubtractMask(canvas, matrix, mask, baseKeyframeAnimation, baseKeyframeAnimation2);
                        break;
                    }
                    this.applySubtractMask(canvas, matrix, mask, baseKeyframeAnimation, baseKeyframeAnimation2);
                    break;
                }
                case MASK_MODE_INTERSECT: {
                    if (mask.isInverted()) {
                        this.applyInvertedIntersectMask(canvas, matrix, mask, baseKeyframeAnimation, baseKeyframeAnimation2);
                        break;
                    }
                    this.applyIntersectMask(canvas, matrix, mask, baseKeyframeAnimation, baseKeyframeAnimation2);
                }
            }
            ++n;
        }
        L.beginSection("Layer#restoreLayer");
        canvas.restore();
        L.endSection("Layer#restoreLayer");
    }

    private boolean areAllMasksNone() {
        if (this.mask.getMaskAnimations().isEmpty()) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < this.mask.getMasks().size()) {
            if (((Mask)this.mask.getMasks().get(n)).getMaskMode() != Mask$MaskMode.MASK_MODE_NONE) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void applyAddMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation baseKeyframeAnimation, BaseKeyframeAnimation baseKeyframeAnimation2) {
        Path path = (Path)baseKeyframeAnimation.getValue();
        this.path.set(path);
        this.path.transform(matrix);
        this.contentPaint.setAlpha((int)((float)((Integer)baseKeyframeAnimation2.getValue()).intValue() * 2.55f));
        canvas.drawPath(this.path, this.contentPaint);
    }

    private void applyInvertedAddMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation baseKeyframeAnimation, BaseKeyframeAnimation baseKeyframeAnimation2) {
        Utils.saveLayerCompat(canvas, this.rect, this.contentPaint);
        canvas.drawRect(this.rect, this.contentPaint);
        Path path = (Path)baseKeyframeAnimation.getValue();
        this.path.set(path);
        this.path.transform(matrix);
        this.contentPaint.setAlpha((int)((float)((Integer)baseKeyframeAnimation2.getValue()).intValue() * 2.55f));
        canvas.drawPath(this.path, this.dstOutPaint);
        canvas.restore();
    }

    private void applySubtractMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation baseKeyframeAnimation, BaseKeyframeAnimation baseKeyframeAnimation2) {
        Path path = (Path)baseKeyframeAnimation.getValue();
        this.path.set(path);
        this.path.transform(matrix);
        canvas.drawPath(this.path, this.dstOutPaint);
    }

    private void applyInvertedSubtractMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation baseKeyframeAnimation, BaseKeyframeAnimation baseKeyframeAnimation2) {
        Utils.saveLayerCompat(canvas, this.rect, this.dstOutPaint);
        canvas.drawRect(this.rect, this.contentPaint);
        this.dstOutPaint.setAlpha((int)((float)((Integer)baseKeyframeAnimation2.getValue()).intValue() * 2.55f));
        Path path = (Path)baseKeyframeAnimation.getValue();
        this.path.set(path);
        this.path.transform(matrix);
        canvas.drawPath(this.path, this.dstOutPaint);
        canvas.restore();
    }

    private void applyIntersectMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation baseKeyframeAnimation, BaseKeyframeAnimation baseKeyframeAnimation2) {
        Utils.saveLayerCompat(canvas, this.rect, this.dstInPaint);
        Path path = (Path)baseKeyframeAnimation.getValue();
        this.path.set(path);
        this.path.transform(matrix);
        this.contentPaint.setAlpha((int)((float)((Integer)baseKeyframeAnimation2.getValue()).intValue() * 2.55f));
        canvas.drawPath(this.path, this.contentPaint);
        canvas.restore();
    }

    private void applyInvertedIntersectMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation baseKeyframeAnimation, BaseKeyframeAnimation baseKeyframeAnimation2) {
        Utils.saveLayerCompat(canvas, this.rect, this.dstInPaint);
        canvas.drawRect(this.rect, this.contentPaint);
        this.dstOutPaint.setAlpha((int)((float)((Integer)baseKeyframeAnimation2.getValue()).intValue() * 2.55f));
        Path path = (Path)baseKeyframeAnimation.getValue();
        this.path.set(path);
        this.path.transform(matrix);
        canvas.drawPath(this.path, this.dstOutPaint);
        canvas.restore();
    }

    boolean hasMasksOnThisLayer() {
        return this.mask != null && !this.mask.getMaskAnimations().isEmpty();
    }

    private void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.invalidateSelf();
        }
    }

    void setProgress(float f2) {
        this.transform.setProgress(f2);
        if (this.mask != null) {
            int n = 0;
            while (n < this.mask.getMaskAnimations().size()) {
                ((BaseKeyframeAnimation)this.mask.getMaskAnimations().get(n)).setProgress(f2);
                ++n;
            }
        }
        if (this.layerModel.getTimeStretch() != 0.0f) {
            f2 /= this.layerModel.getTimeStretch();
        }
        if (this.matteLayer != null) {
            float f3 = this.matteLayer.layerModel.getTimeStretch();
            this.matteLayer.setProgress(f2 * f3);
        }
        int n = 0;
        while (n < this.animations.size()) {
            ((BaseKeyframeAnimation)this.animations.get(n)).setProgress(f2);
            ++n;
        }
    }

    private void buildParentLayerListIfNeeded() {
        if (this.parentLayers != null) {
            return;
        }
        if (this.parentLayer == null) {
            this.parentLayers = Collections.emptyList();
            return;
        }
        this.parentLayers = new ArrayList();
        BaseLayer baseLayer = this.parentLayer;
        while (baseLayer != null) {
            this.parentLayers.add(baseLayer);
            baseLayer = baseLayer.parentLayer;
        }
    }

    @Override
    public String getName() {
        return this.layerModel.getName();
    }

    @Override
    public void setContents(List list, List list2) {
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        if (!keyPath.matches(this.getName(), n)) {
            return;
        }
        if (!"__container".equals(this.getName())) {
            keyPath2 = keyPath2.addKey(this.getName());
            if (keyPath.fullyResolvesTo(this.getName(), n)) {
                list.add(keyPath2.resolve(this));
            }
        }
        if (keyPath.propagateToChildren(this.getName(), n)) {
            int n2 = n + keyPath.incrementDepthBy(this.getName(), n);
            this.resolveChildKeyPath(keyPath, n2, list, keyPath2);
        }
    }

    void resolveChildKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        this.transform.applyValueCallback(object, lottieValueCallback);
    }

    static /* synthetic */ void access$1(BaseLayer baseLayer, boolean bl) {
        baseLayer.setVisible(bl);
    }
}

