/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.decoder;

import oz.util.barcode.FormatException;
import oz.util.barcode.datamatrix.decoder.Version$ECB;
import oz.util.barcode.datamatrix.decoder.Version$ECBlocks;

public final class Version {
    private static final Version[] VERSIONS = Version.buildVersions();
    private final int versionNumber;
    private final int symbolSizeRows;
    private final int symbolSizeColumns;
    private final int dataRegionSizeRows;
    private final int dataRegionSizeColumns;
    private final Version$ECBlocks ecBlocks;
    private final int totalCodewords;

    private Version(int n, int n2, int n3, int n4, int n5, Version$ECBlocks version$ECBlocks) {
        Version$ECB[] version$ECBArray;
        this.versionNumber = n;
        this.symbolSizeRows = n2;
        this.symbolSizeColumns = n3;
        this.dataRegionSizeRows = n4;
        this.dataRegionSizeColumns = n5;
        this.ecBlocks = version$ECBlocks;
        int n6 = 0;
        int n7 = version$ECBlocks.getECCodewords();
        Version$ECB[] version$ECBArray2 = version$ECBArray = version$ECBlocks.getECBlocks();
        int n8 = version$ECBArray.length;
        int n9 = 0;
        while (n9 < n8) {
            Version$ECB version$ECB = version$ECBArray2[n9];
            n6 += version$ECB.getCount() * (version$ECB.getDataCodewords() + n7);
            ++n9;
        }
        this.totalCodewords = n6;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public int getSymbolSizeRows() {
        return this.symbolSizeRows;
    }

    public int getSymbolSizeColumns() {
        return this.symbolSizeColumns;
    }

    public int getDataRegionSizeRows() {
        return this.dataRegionSizeRows;
    }

    public int getDataRegionSizeColumns() {
        return this.dataRegionSizeColumns;
    }

    public int getTotalCodewords() {
        return this.totalCodewords;
    }

    Version$ECBlocks getECBlocks() {
        return this.ecBlocks;
    }

    public static Version getVersionForDimensions(int n, int n2) {
        if ((n & 1) != 0 || (n2 & 1) != 0) {
            throw FormatException.getFormatInstance();
        }
        Version[] versionArray = VERSIONS;
        int n3 = VERSIONS.length;
        int n4 = 0;
        while (n4 < n3) {
            Version version = versionArray[n4];
            if (version.symbolSizeRows == n && version.symbolSizeColumns == n2) {
                return version;
            }
            ++n4;
        }
        throw FormatException.getFormatInstance();
    }

    public String toString() {
        return String.valueOf(this.versionNumber);
    }

    private static Version[] buildVersions() {
        return new Version[]{new Version(1, 10, 10, 8, 8, new Version$ECBlocks(5, new Version$ECB(1, 3, null), null)), new Version(2, 12, 12, 10, 10, new Version$ECBlocks(7, new Version$ECB(1, 5, null), null)), new Version(3, 14, 14, 12, 12, new Version$ECBlocks(10, new Version$ECB(1, 8, null), null)), new Version(4, 16, 16, 14, 14, new Version$ECBlocks(12, new Version$ECB(1, 12, null), null)), new Version(5, 18, 18, 16, 16, new Version$ECBlocks(14, new Version$ECB(1, 18, null), null)), new Version(6, 20, 20, 18, 18, new Version$ECBlocks(18, new Version$ECB(1, 22, null), null)), new Version(7, 22, 22, 20, 20, new Version$ECBlocks(20, new Version$ECB(1, 30, null), null)), new Version(8, 24, 24, 22, 22, new Version$ECBlocks(24, new Version$ECB(1, 36, null), null)), new Version(9, 26, 26, 24, 24, new Version$ECBlocks(28, new Version$ECB(1, 44, null), null)), new Version(10, 32, 32, 14, 14, new Version$ECBlocks(36, new Version$ECB(1, 62, null), null)), new Version(11, 36, 36, 16, 16, new Version$ECBlocks(42, new Version$ECB(1, 86, null), null)), new Version(12, 40, 40, 18, 18, new Version$ECBlocks(48, new Version$ECB(1, 114, null), null)), new Version(13, 44, 44, 20, 20, new Version$ECBlocks(56, new Version$ECB(1, 144, null), null)), new Version(14, 48, 48, 22, 22, new Version$ECBlocks(68, new Version$ECB(1, 174, null), null)), new Version(15, 52, 52, 24, 24, new Version$ECBlocks(42, new Version$ECB(2, 102, null), null)), new Version(16, 64, 64, 14, 14, new Version$ECBlocks(56, new Version$ECB(2, 140, null), null)), new Version(17, 72, 72, 16, 16, new Version$ECBlocks(36, new Version$ECB(4, 92, null), null)), new Version(18, 80, 80, 18, 18, new Version$ECBlocks(48, new Version$ECB(4, 114, null), null)), new Version(19, 88, 88, 20, 20, new Version$ECBlocks(56, new Version$ECB(4, 144, null), null)), new Version(20, 96, 96, 22, 22, new Version$ECBlocks(68, new Version$ECB(4, 174, null), null)), new Version(21, 104, 104, 24, 24, new Version$ECBlocks(56, new Version$ECB(6, 136, null), null)), new Version(22, 120, 120, 18, 18, new Version$ECBlocks(68, new Version$ECB(6, 175, null), null)), new Version(23, 132, 132, 20, 20, new Version$ECBlocks(62, new Version$ECB(8, 163, null), null)), new Version(24, 144, 144, 22, 22, new Version$ECBlocks(62, new Version$ECB(8, 156, null), new Version$ECB(2, 155, null), null)), new Version(25, 8, 18, 6, 16, new Version$ECBlocks(7, new Version$ECB(1, 5, null), null)), new Version(26, 8, 32, 6, 14, new Version$ECBlocks(11, new Version$ECB(1, 10, null), null)), new Version(27, 12, 26, 10, 24, new Version$ECBlocks(14, new Version$ECB(1, 16, null), null)), new Version(28, 12, 36, 10, 16, new Version$ECBlocks(18, new Version$ECB(1, 22, null), null)), new Version(29, 16, 36, 14, 16, new Version$ECBlocks(24, new Version$ECB(1, 32, null), null)), new Version(30, 16, 48, 14, 22, new Version$ECBlocks(28, new Version$ECB(1, 49, null), null))};
    }
}

