/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewGroup;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import oz.main.OZStorage;
import oz.viewer.ui.edit.ACanvasMemoView$OZGestureListener;
import oz.viewer.ui.edit.ACanvasObjectView;
import oz.viewer.ui.edit.AControllerMemo;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableConst$Size;
import oz.viewer.ui.edit.AMemoInfo;

public class ACanvasMemoView
extends ACanvasObjectView {
    public final int TOP_1 = 3;
    public final int TOP_2 = 4;
    public final int TOP_3 = 5;
    private AMemoInfo mInfo;
    private String mFontColor;
    private String mFillColor;
    private PointF mXYPos;
    private PointF mRealXYPos;
    private Rect mTempRect;
    private RectF mTempRectF;
    private Paint mTempPaint;
    private float mStrokeWidth;
    public Bitmap m_bitmapSetting;

    public ACanvasMemoView(Context context, AEditableBaseView aEditableBaseView, AMemoInfo aMemoInfo, AControllerMemo aControllerMemo) {
        super(context, aEditableBaseView, aControllerMemo);
        this.setMemoInfo(aMemoInfo);
        this.mXYPos = new PointF();
        this.mRealXYPos = new PointF();
        this.mTempRect = new Rect();
        this.mTempRectF = new RectF();
        this.mTempPaint = new Paint();
        this.getBaseView().m_imageEditor_middle_Layout.setCanvasScale(1.0f);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ACanvasMemoView$OZGestureListener(this, null), null, false);
        AEditableBaseView.m_selectedObject = this;
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mStrokeWidth = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)displayMetrics);
        this.initBitmap();
        this.setWillNotDraw(false);
        this.invalidate();
    }

    AMemoInfo getMemoInfo() {
        return this.mInfo;
    }

    private String getItemFontColor() {
        return this.mFontColor;
    }

    private String getItemFillColor() {
        return this.mFillColor;
    }

    private float getItemStrokeWidth() {
        return this.mStrokeWidth;
    }

    AControllerMemo getMemoController() {
        return (AControllerMemo)this.getController();
    }

    protected void onDraw(Canvas canvas) {
        if (this.getWidth() != 0 && this.getHeight() != 0 && this.getMemoInfo() != null) {
            float f2;
            Object object;
            float f3 = this.getBaseView().m_canvasW;
            if (this.getRect().left == 0.0f && this.getRect().top == 0.0f && this.getRect().isEmpty()) {
                float f4;
                float f5 = this.getBaseView().getDstRect().width();
                float f6 = this.getBaseView().getDstRect().height();
                float f7 = 250.0f * OZStorage.getDensityDPI();
                float f8 = 80.0f * OZStorage.getDensityDPI();
                if (this.getMemoInfo().getFontSize() == 0) {
                    this.getMemoInfo().setFontSize(Math.round(this.getMemoController().getScaledFontSize() / this.getBaseView().m_canvasW));
                }
                object = this.mTempRectF;
                object.set(0.0f, 0.0f, f5, f6);
                if (f5 < f7 || f6 < f8) {
                    if (f5 * f8 < f6 * f7) {
                        object.top = 0.0f;
                        object.bottom = f8;
                    } else {
                        object.left = 0.0f;
                        object.right = f7;
                    }
                    if (this.getMemoController().getRect().width() != 0.0f && this.getMemoController().getRect().height() != 0.0f) {
                        this.setRect(this.getMemoController().getRect().left / f3 + this.getBaseView().getDstRect().left, this.getMemoController().getRect().top / f3 + this.getBaseView().getDstRect().top, this.getMemoController().getRect().right / f3 + this.getBaseView().getDstRect().left, this.getMemoController().getRect().bottom / f3 + this.getBaseView().getDstRect().top);
                    } else {
                        f4 = (float)this.getBaseView().m_imageEditor_middle_Layout.getWidth() / 2.0f - object.width() / 2.0f;
                        f2 = (float)this.getBaseView().m_imageEditor_middle_Layout.getHeight() / 2.0f - object.height() / 2.0f;
                        this.setRect(f4, f2, f4 + object.width(), f2 + object.height());
                    }
                } else if (!this.getMemoController().getRect().isEmpty()) {
                    this.setRect(this.getMemoController().getRect().left / f3 + this.getBaseView().getDstRect().left, this.getMemoController().getRect().top / f3 + this.getBaseView().getDstRect().top, this.getMemoController().getRect().right / f3 + this.getBaseView().getDstRect().left, this.getMemoController().getRect().bottom / f3 + this.getBaseView().getDstRect().top);
                } else {
                    f4 = (float)this.getBaseView().getEditableViewWidth() / 2.0f - (float)((int)(250.0f * OZStorage.getDensityDPI() / 2.0f));
                    f2 = (float)this.getBaseView().getEditableViewHeight() / 2.0f - (float)((int)(80.0f * OZStorage.getDensityDPI() / 2.0f));
                    this.setRect(f4, f2, f4 + (float)((int)(250.0f * OZStorage.getDensityDPI())), f2 + (float)((int)(80.0f * OZStorage.getDensityDPI())));
                }
                this.getMemoController().setProperties(this.getRect(), this.getMemoInfo());
            }
            Paint paint = this.mTempPaint;
            paint.reset();
            if (!this.getMemoInfo().isTransparent()) {
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(Color.parseColor((String)("#" + this.getItemFillColor())));
                paint.setAlpha(this.getMemoInfo().getFillAhpha());
                if (this.isMoveMode() || this.getChangeMode() == 2) {
                    canvas.drawRect(this.getRealRect(), paint);
                } else {
                    canvas.drawRect(this.getRect(), paint);
                }
            }
            paint.setColor(Color.parseColor((String)("#" + this.getItemFontColor())));
            paint.setTextSize(this.getMemoController().getScaledFontSize() / f3);
            Typeface typeface = paint.getTypeface();
            paint.setTypeface(Typeface.create((Typeface)typeface, (int)this.getMemoInfo().getFontStyle()));
            Rect rect = this.mTempRect;
            paint.getTextBounds(this.getMemoInfo().getLabelCaption(), 0, this.getMemoInfo().getLabelCaption().length(), rect);
            int n = rect.height();
            object = this.getTextToken(this.getMemoInfo().getLabelCaption(), paint) == null ? "" : this.getTextToken(this.getMemoInfo().getLabelCaption(), paint).toString();
            String[] stringArray = this.getTextToken((String)object);
            f2 = n * (stringArray == null ? 0 : stringArray.length);
            int n2 = stringArray == null ? 0 : stringArray.length;
            f2 += (float)n * 0.3f * (float)n2;
            float f9 = (float)n * 0.3f;
            for (int j = 0; j < n2; ++j) {
                RectF rectF = null;
                PointF pointF = null;
                if (this.isMoveMode() || this.getChangeMode() == 2) {
                    rectF = this.getRealRect();
                    pointF = this.mRealXYPos;
                } else {
                    rectF = this.getRect();
                    pointF = this.mXYPos;
                }
                switch (this.getMemoInfo().getParagraphHorizontalAlign()) {
                    case 0: {
                        pointF.x = (int)(rectF.left + rectF.width() / 2.0f - paint.measureText(stringArray[j]) / 2.0f);
                        break;
                    }
                    case 1: {
                        pointF.x = (int)(rectF.left + AEditableConst$Size.EDITABLE_GAP_2_5);
                        break;
                    }
                    case 2: {
                        pointF.x = (int)(rectF.right - paint.measureText(stringArray[j]) - AEditableConst$Size.EDITABLE_GAP_2_5);
                    }
                }
                switch (this.getMemoInfo().getParagraphVerticalAlign()) {
                    case 0: {
                        pointF.y = (int)(rectF.top + rectF.height() / 2.0f + f2 / 2.0f - (float)(n2 - (j + 1)) * ((float)n + f9) - f9 / 2.0f);
                        break;
                    }
                    case 1: {
                        pointF.y = (int)(rectF.top + (float)n + f9 + ((float)n + f9) * (float)j);
                        break;
                    }
                    case 2: {
                        pointF.y = (int)(rectF.bottom - f2 + (float)n + ((float)n + f9) * (float)j);
                    }
                }
                float f10 = AEditableConst$Size.EDITABLE_GAP_1 / 2.0f;
                this.mTempRectF.set(rectF);
                this.mTempRectF.inset(-f10, -f10);
                canvas.clipRect(this.mTempRectF);
                canvas.drawText(stringArray[j], pointF.x, pointF.y, paint);
            }
            f9 = AEditableConst$Size.EDITABLE_GAP_1 / 2.0f;
            if (this.isMoveMode() || this.getChangeMode() == 2) {
                this.mTempRectF.set(this.getRealRect());
            } else {
                this.mTempRectF.set(this.getRect());
            }
            this.mTempRectF.inset(-f9, -f9);
            paint.reset();
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(-16777216);
            paint.setStrokeWidth(this.getItemStrokeWidth());
            canvas.drawRect(this.mTempRectF, paint);
        }
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.mGestureDetector.onTouchEvent(motionEvent);
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        Point point = this.getBaseView().m_imageEditor_middle_Layout.getScaledTouch(f2, f3);
        f2 = point.x;
        f3 = point.y;
        if (AEditableBaseView.m_selectedObject == null) {
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            viewGroup.onTouchEvent(motionEvent);
        }
        switch (motionEvent.getAction()) {
            case 0: {
                if (this.getRect().contains(f2, f3)) {
                    if (AEditableBaseView.m_selectedObject == this) break;
                    return true;
                }
                if (AEditableBaseView.m_selectedObject == this) break;
                return false;
            }
        }
        return false;
    }

    public void setMemoInfo(AMemoInfo aMemoInfo) {
        this.mInfo = aMemoInfo;
        this.mFontColor = aMemoInfo.getFontColor();
        this.mFillColor = aMemoInfo.getFillColor();
    }

    private void initBitmap() {
        try {
            int n = OZStorage.getDrawable(this.getResources().getAssets().open(OZStorage.getImagePath("resource/tracker_rotate@2x.png"))).getIntrinsicHeight();
            InputStream inputStream = this.getContext().getAssets().open("resource/memo_icon_setting@2x.png");
            this.m_bitmapSetting = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapSetting = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapSetting, (int)n, (int)n, (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/memo_icon_size@2x.png");
            this.m_bitmapSize = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapSize = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapSize, (int)n, (int)n, (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_foreground@2x.png");
            this.m_bitmapForeground = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapForeground = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapForeground, (int)(n * 3 / 4), (int)(n * 3 / 4), (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_background@2x.png");
            this.m_bitmapBackground = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapBackground = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapBackground, (int)(n * 3 / 4), (int)(n * 3 / 4), (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_garbage@2x.png");
            this.m_bitmapDeleteImamge = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapDeleteImamge = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapDeleteImamge, (int)(n * 3 / 4), (int)(n * 3 / 4), (boolean)true);
            this.m_icon_size = this.m_bitmapSize.getHeight();
            this.m_icon_size3_4 = this.m_bitmapForeground.getHeight();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private StringBuilder getTextToken(String string, Paint paint) {
        StringTokenizer stringTokenizer;
        int n;
        String[] stringArray = null;
        StringBuilder stringBuilder = null;
        if (string != null && !"".equals(string) && (n = (stringTokenizer = new StringTokenizer(string, "\n")).countTokens()) > 0) {
            stringArray = new String[n];
            stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                if (stringTokenizer.hasMoreTokens()) {
                    stringArray[j] = stringTokenizer.nextToken();
                    stringBuilder.append(this.getSplitedText(stringArray[j], paint).toString());
                    continue;
                }
                stringBuilder.append("");
            }
        }
        return stringBuilder;
    }

    private String[] getTextToken(String string) {
        StringTokenizer stringTokenizer;
        int n;
        String[] stringArray = null;
        if (string != null && !"".equals(string) && (n = (stringTokenizer = new StringTokenizer(string, "\n")).countTokens()) > 0) {
            stringArray = new String[n];
            for (int j = 0; j < n; ++j) {
                stringArray[j] = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            }
        }
        return stringArray;
    }

    private StringBuilder getSplitedText(String string, Paint paint) {
        StringBuilder stringBuilder = new StringBuilder();
        Rect rect = new Rect();
        for (int j = 0; j < string.length(); ++j) {
            paint.getTextBounds(string, 0, string.length() - j, rect);
            if (this.isMoveMode() || this.getChangeMode() == 2) {
                if (!((float)rect.width() + AEditableConst$Size.EDITABLE_GAP_2_5 * 2.0f < this.getRealRect().width()) && j != string.length() - 1) continue;
                stringBuilder.append(string.substring(0, string.length() - j));
                stringBuilder.append("\n");
                stringBuilder.append(this.getSplitedText(string.substring(string.length() - j, string.length()), paint).toString());
                break;
            }
            if (!((float)rect.width() + AEditableConst$Size.EDITABLE_GAP_2_5 * 2.0f < this.getRect().width()) && j != string.length() - 1) continue;
            stringBuilder.append(string.substring(0, string.length() - j));
            stringBuilder.append("\n");
            stringBuilder.append(this.getSplitedText(string.substring(string.length() - j, string.length()), paint).toString());
            break;
        }
        return stringBuilder;
    }

    public PointF getItemMemoXYPos() {
        return this.mXYPos;
    }

    public void setItemMemoXYPos(float f2, float f3) {
        this.getItemMemoXYPos().set(f2, f3);
    }

    public void setItemMemoXPos(float f2) {
        this.getItemMemoXYPos().x = f2;
    }

    public float getItemMemoXPos() {
        return this.getItemMemoXYPos().x;
    }

    public void setItemMemoYPos(float f2) {
        this.getItemMemoXYPos().y = f2;
    }

    public float getItemMemoYPos() {
        return this.getItemMemoXYPos().y;
    }

    public PointF getItemMemoRealXYPos() {
        return this.mRealXYPos;
    }

    public void setItemMemoRealXYPos(PointF pointF) {
        this.getItemMemoRealXYPos().set(pointF);
    }

    public void setItemMemoRealXYPos(float f2, float f3) {
        this.getItemMemoRealXYPos().set(f2, f3);
    }

    public void setItemMemoRealXPos(float f2) {
        this.getItemMemoRealXYPos().x = f2;
    }

    public float getItemMemoRealXPos() {
        return this.getItemMemoRealXYPos().x;
    }

    public void setItemMemoRealYPos(float f2) {
        this.getItemMemoRealXYPos().y = f2;
    }

    public float getItemMemoRealYPos() {
        return this.getItemMemoRealXYPos().y;
    }
}

