/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.util.ArrayList;
import oz.viewer.ui.dlg.OZUtilView;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.AParameterManager$1;
import oz.viewer.ui.main.overlay.AParameterManager$ParameterComboBoxData;
import oz.viewer.ui.main.overlay.AParameterManager$ParameterData;
import oz.viewer.ui.main.overlay.AParameterManager$ParameterOnClickListener;
import oz.viewer.ui.main.overlay.AParameterManager$ParameterTextBoxData;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.UserCloseAbleOZOverlayView;

public class AParameterManager
extends UserCloseAbleOZOverlayView {
    private static final int BTN_ID_CLOSE = 1;
    private static final int BTN_ID_FIND = 2;
    private static final String BTN_IMAGE_CLOSE = "resource/toolbar_close@2x.png";
    private static final String BTN_IMAGE_FIND = "resource/toolbar_find@2x.png";
    private ArrayList mDatas;
    private LinearLayout mView;
    private LinearLayout mContentArea;
    private boolean mIsEnableFindButton = true;
    private AParameterManager$ParameterOnClickListener mOnClickListener;

    public AParameterManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 4);
        this.setHideVisibility(8);
        this.mDatas = new ArrayList();
        this.mOnClickListener = new AParameterManager$ParameterOnClickListener(this);
        this.initView();
        this.updateView();
    }

    private void initView() {
        this.mView = new LinearLayout(this.getContext());
        this.mView.setBackgroundColor(Color.argb((int)255, (int)217, (int)217, (int)217));
        this.mView.setOrientation(1);
        this.mView.setOnTouchListener((View.OnTouchListener)new AParameterManager$1(this));
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(0);
        linearLayout.setPadding(AOverlayUtil.DpToPx(15), 0, AOverlayUtil.DpToPx(15), 0);
        this.addCloseButton((ViewGroup)linearLayout);
        this.addContentLayout((ViewGroup)linearLayout);
        this.addFindButton((ViewGroup)linearLayout);
        this.mView.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        OZUtilView.addComponentSeperaterView(this.getContext(), (ViewGroup)this.mView);
        this.mView.setVisibility(8);
    }

    private void addCloseButton(ViewGroup viewGroup) {
        this.addButton(viewGroup, 1, BTN_IMAGE_CLOSE, 0.8f, false, true);
    }

    private void addContentLayout(ViewGroup viewGroup) {
        HorizontalScrollView horizontalScrollView = new HorizontalScrollView(this.getContext());
        this.mContentArea = new LinearLayout(this.getContext());
        this.mContentArea.setFocusable(true);
        this.mContentArea.setFocusableInTouchMode(true);
        this.mContentArea.setPadding(AOverlayUtil.getDP10(), 0, AOverlayUtil.getDP10(), 0);
        horizontalScrollView.addView((View)this.mContentArea, new ViewGroup.LayoutParams(-2, -1));
        viewGroup.addView((View)horizontalScrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
    }

    private void addFindButton(ViewGroup viewGroup) {
        this.addButton(viewGroup, 2, BTN_IMAGE_FIND, 0.8f, true, false);
    }

    private void addButton(ViewGroup viewGroup, int n, String string, float f2, boolean bl, boolean bl2) {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(0);
        linearLayout.setGravity(16);
        ImageButton imageButton = AOverlayUtil.createImageButton(this.getContext(), n, string, 255, this.mOnClickListener);
        imageButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
        AOverlayUtil.setImageButtonSize(imageButton, f2);
        linearLayout.addView((View)imageButton);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
        if (bl) {
            layoutParams.leftMargin = AOverlayUtil.getDP10();
        }
        if (bl2) {
            layoutParams.rightMargin = AOverlayUtil.getDP10();
        }
        viewGroup.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setFindButtonEnable(boolean bl) {
        if (this.mIsEnableFindButton != bl) {
            this.mIsEnableFindButton = bl;
            this.requestNeedUpdateView();
        }
    }

    public boolean isFindButtonEnable() {
        return this.mIsEnableFindButton;
    }

    private void hideKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        for (int j = 0; j < this.mDatas.size(); ++j) {
            if (((AParameterManager$ParameterData)this.mDatas.get(j)).getType() != AParameterManager$ParameterData.TYPE_TEXTBOX) continue;
            inputMethodManager.hideSoftInputFromWindow(((AParameterManager$ParameterData)this.mDatas.get(j)).getFocusView().getWindowToken(), 0);
        }
    }

    public void addTextBoxData(String string, String string2, String string3, int n) {
        this.mDatas.add(new AParameterManager$ParameterTextBoxData(this, string, string2, string3, n));
        this.requestNeedUpdateView();
    }

    public void addCommboBoxData(String string, String string2, String string3, String string4, int n, String string5) {
        this.mDatas.add(new AParameterManager$ParameterComboBoxData(this, string, string2, string3, string4, n, string5));
        this.requestNeedUpdateView();
    }

    public void clear() {
        for (int j = 0; j < this.mDatas.size(); ++j) {
            View view = ((AParameterManager$ParameterData)this.mDatas.get(j)).getView();
            if (view.getParent() == null) continue;
            ((AParameterManager$ParameterData)this.mDatas.get(j)).removeFromParent();
        }
        this.mDatas.clear();
    }

    public void hide() {
        super.hide();
        this.hideKeyboard();
        this.getNativeController().parameterToolbarClose();
    }

    protected void updateView() {
        ImageView imageView = (ImageView)this.getView().findViewById(2);
        imageView.setEnabled(this.isFindButtonEnable());
        imageView.setAlpha(this.isFindButtonEnable() ? 255 : 128);
        for (int j = 0; j < this.mDatas.size(); ++j) {
            View view = ((AParameterManager$ParameterData)this.mDatas.get(j)).getView();
            if (view.getParent() != null) continue;
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
            if (this.mContentArea.getChildCount() == 0) {
                layoutParams.leftMargin = -AOverlayUtil.getDP20();
            }
            this.mContentArea.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
        this.setEnableChildView((ViewGroup)this.mContentArea, this.isFindButtonEnable());
    }

    private void setEnableChildView(ViewGroup viewGroup, boolean bl) {
        int n = viewGroup.getChildCount();
        for (int j = 0; j < n; ++j) {
            View view = viewGroup.getChildAt(j);
            if (view.getId() != 1 && view.getId() != 2) {
                view.setClickable(bl);
                view.setEnabled(bl);
                view.setFocusable(bl);
            }
            if (!(view instanceof ViewGroup)) continue;
            this.setEnableChildView((ViewGroup)view, bl);
        }
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)overlayLayout.findLayout(21120);
        frameLayout.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    static /* synthetic */ void access$000(AParameterManager aParameterManager) {
        aParameterManager.hideKeyboard();
    }

    static /* synthetic */ ArrayList access$100(AParameterManager aParameterManager) {
        return aParameterManager.mDatas;
    }
}

