/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.util.Hashtable;
import oz.viewer.ui.main.overlay.OverlayController;
import oz.viewer.ui.main.overlay.OverlayObject;
import oz.viewer.ui.main.overlay.OverlayView;

public class OverlayLayout
extends FrameLayout {
    public static final int OVERLAY_LAYOUT_ID_ROOT = 0;
    public static final int OVERLAY_LAYOUT_ID_SCROLL_AREA = 10000;
    public static final int OVERLAY_LAYOUT_ID_TOOLBAR_AREA = 20000;
    public static final int OVERLAY_LAYOUT_ID_TOOLBAR_AREA_TOP = 21000;
    public static final int OVERLAY_LAYOUT_ID_TOOLBAR_AREA_TOP_TOOLBAR = 21110;
    public static final int OVERLAY_LAYOUT_ID_TOOLBAR_AREA_TOP_OTHER = 21120;
    public static final int OVERLAY_LAYOUT_ID_TOOLBAR_AREA_BOTTOM = 22000;
    private Hashtable mLayoutViews;
    private Hashtable mOverlayViews;
    private Hashtable mOverlayControllers;

    public OverlayLayout(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mLayoutViews = new Hashtable();
        this.mOverlayViews = new Hashtable();
        this.mOverlayControllers = new Hashtable();
        this.initLayout();
    }

    private void initLayout() {
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        this.addView((View)frameLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 51));
        this.mLayoutViews.put(10000, frameLayout);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 51));
        this.mLayoutViews.put(20000, linearLayout);
        FrameLayout frameLayout2 = new FrameLayout(this.getContext());
        linearLayout.addView((View)frameLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mLayoutViews.put(21000, frameLayout2);
        FrameLayout frameLayout3 = new FrameLayout(this.getContext());
        frameLayout2.addView((View)frameLayout3, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 51));
        this.mLayoutViews.put(21110, frameLayout3);
        FrameLayout frameLayout4 = new FrameLayout(this.getContext());
        frameLayout2.addView((View)frameLayout4, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 51));
        this.mLayoutViews.put(21120, frameLayout4);
        FrameLayout frameLayout5 = new FrameLayout(this.getContext());
        linearLayout.addView((View)frameLayout5, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mLayoutViews.put(22000, frameLayout5);
    }

    private void addOverlayController(OverlayController overlayController) {
        this.mOverlayControllers.put(overlayController.getType(), overlayController);
    }

    private void removeOverlayController(OverlayController overlayController) {
        this.mOverlayControllers.remove(overlayController.getType());
        overlayController.removeFromParent();
    }

    private void addOverlayView(OverlayView overlayView) {
        this.mOverlayViews.put(overlayView.getType(), overlayView);
        View view = overlayView.getView();
        if (view.getParent() == null) {
            overlayView.addToOverlayView(this, overlayView.getView());
        }
    }

    private void removeOverlayView(OverlayView overlayView) {
        this.mOverlayViews.remove(overlayView.getType());
        overlayView.removeFromParent();
    }

    public void addOverlayObject(OverlayObject overlayObject) {
        if (overlayObject instanceof OverlayController) {
            this.addOverlayController((OverlayController)overlayObject);
        } else if (overlayObject instanceof OverlayView) {
            this.addOverlayView((OverlayView)overlayObject);
        }
    }

    public void removeOverlayObject(int n) {
        OverlayObject overlayObject = this.findOverlayObject(n);
        if (overlayObject != null) {
            this.removeOverlayObject(overlayObject);
        }
    }

    public void removeOverlayObject(OverlayObject overlayObject) {
        if (overlayObject instanceof OverlayController) {
            this.removeOverlayController((OverlayController)overlayObject);
        } else if (overlayObject instanceof OverlayView) {
            this.removeOverlayView((OverlayView)overlayObject);
        }
    }

    public View findLayout(int n) {
        if (n == 0) {
            return this;
        }
        View view = (View)this.mLayoutViews.get(n);
        if (view == null) {
            view = this.findViewById(n);
        }
        return view;
    }

    public OverlayController findOverlayController(int n) {
        return (OverlayController)this.mOverlayControllers.get(n);
    }

    public OverlayView findOverlayView(int n) {
        return (OverlayView)this.mOverlayViews.get(n);
    }

    public OverlayObject findOverlayObject(int n) {
        OverlayObject overlayObject = this.findOverlayView(n);
        if (overlayObject == null) {
            overlayObject = this.findOverlayController(n);
        }
        return overlayObject;
    }
}

