package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.Date;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.NumericUtil;
import jp.agentec.adf.util.StringUtil;

public class DownloadedContentInfoJSON extends AcmsJSONParser {
	public static final String ContentId = "contentId";
	public static final String CategoryId = "categoryId";
	public static final String ContentName = "contentName";
	public static final String ContentNameKana = "contentNameKana";
	public static final String ContentDetail = "contentDetail";
	public static final String DeliveryStartDate = "deliveryStartDate";
	public static final String DeliveryStartDateUTC = "deliveryStartDateUTC";
	public static final String DeliveryEndDate = "deliveryEndDate";
	public static final String DeliveryEndDateUTC = "deliveryEndDateUTC";
	public static final String AllPageNum = "allPageNum";
	public static final String Orientation = "orientation";
	public static final String ThumbnailName = "thumbnailName";
	public static final String ThumbnailBigName = "thumbnailBigName";
	public static final String ThumbnailLargeName = "thumbnailLargeName";
	public static final String MetaVersion = "metaVersion";
	public static final String ResourceVersion = "resourceVersion";
	public static final String TagName = "tagName";
	public static final String StrGroupList = "strGroupList";
	public static final String ContentLink = "contentLink";
	public static final String ContentSize = "contentSize";
	public static final String LastDeliveryDate = "lastDeliveryDate";
	public static final String LastDeliveryDateUTC = "lastDeliveryDateUTC";
	public static final String ContentType = "contentType";
	public static final String ContractContentId = "contractContentId";
	public static final String AlertMessageLevel = "alertMessageLevel";
	public static final String AlertMessage = "alertMessage";
	public static final String ProductIdAndroid = "productIdAndroid";
	public static final String DeliveryType = "deliveryType";
	public static final String DisableSwipe = "disableSwipe";
	public static final String BrowserType = "browserType";
	public static final String PdfPassword = "pdfPassword";
	
	public static final String EnqueteId = "enqueteId";
	public static final String ReplyLimit = "replyLimit";
	public static final String ShowResult = "showResult";
	public static final String SendResult = "sendResult";
	public static final String CommonContentFlg = "commonContentFlg";

	public long contentId;
	public int categoryId;
	public String contentName;
	public String contentNameKana;
	public String contentDetail;
	public Date deliveryStartDate;
	public Date deliveryEndDate;
	public int allPageNum;
	public int orientation;
	public String thumbnailName;
	public String thumbnailBigName;
	public String thumbnailLargeName;
	public int metaVersion;
	public int resourceVersion;
	public String[] tags;
	public int[] groupIds;
	public JSONArray contentLinks;
	public Integer contentSize;
	public int contractContentId;
	public String contentType;
	public Date lastDeliveryDate;
	public int alertMessageLevel;
	public String alertMessage;
	public String productId;
	public int deliveryType;
	public boolean disableSwipe;
	public int browserType;
	public String pdfPassword;
	
	public long enqueteId;
	public int replyLimit;
	public int showResult;
	public int sendResult;
	public boolean commonContentFlg;
	
	
	public DownloadedContentInfoJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		contentId = getLong(json, ContentId);
		categoryId = JsonUtil.getInt(json, CategoryId);
		contentName = getString(json, ContentName);
		contentNameKana = getString(json, ContentNameKana, StringUtil.Empty);
		contentDetail = getString(json, ContentDetail, StringUtil.Empty);
		
		if (json.has(DeliveryStartDateUTC)) { // ABook+からUTCキーあり
			String time = json.getString(DeliveryStartDateUTC);
			deliveryStartDate = DateTimeUtil.toDate(time, "UTC", DateTimeFormat.yyyyMMddHHmmss_TZ);
		}
		else if (json.has(DeliveryStartDate)) { // 旧環境で作成されたコンテンツ用
			String time = json.getString(DeliveryStartDate);
			deliveryStartDate = convertDate(time);
		}
		
		if (json.has(DeliveryEndDateUTC)) { // ABook+からUTCキーあり
			String time = json.getString(DeliveryEndDateUTC);
			deliveryEndDate = DateTimeUtil.toDate(time, "UTC", DateTimeFormat.yyyyMMddHHmmss_TZ);
		}
		else if (json.has(DeliveryEndDate)) { // 旧環境で作成されたコンテンツ用
			String time = json.getString(DeliveryEndDate);
			deliveryEndDate = convertDate(time);
		}
		
		allPageNum = getInt(json, AllPageNum, 1);
		orientation = getInt(json, Orientation, -1);
		thumbnailName = getString(json, ThumbnailName, "");
		thumbnailBigName = getString(json, ThumbnailBigName, "");
		metaVersion = getInt(json, MetaVersion);
		resourceVersion = getInt(json, ResourceVersion);
		
		String tagStr = getString(json, TagName, null);
		if (tagStr != null) {
			tags = tagStr.split(",");
		}
		
		String s = JsonUtil.getString(json, StrGroupList);
		if (s != null) {
			String[] a = s.split(",");
			groupIds = new int[a.length];
			for (int i = 0; i < a.length; i++) {
				groupIds[i] = NumericUtil.parseInt(a[i]);
			}
		}
		
		if (json.has(ContentLink)) {
			contentLinks = JsonUtil.getJSONArray(json, ContentLink);
		}
		
		contentSize= getInt(json, ContentSize, 0) / 1024;
		contractContentId= getInt(json, ContractContentId, 0);
		contentType= getString(json, ContentType, "PDF");
		
		if (json.has(LastDeliveryDateUTC)) {
			String time = json.getString(LastDeliveryDateUTC);
			lastDeliveryDate = DateTimeUtil.toDate(time, "UTC", DateTimeFormat.yyyyMMddHHmmss_TZ);
		}
		else if (json.has(LastDeliveryDate)) {
			String time = json.getString(LastDeliveryDate);
			lastDeliveryDate = convertDate(time);
		}
		
		alertMessageLevel= getInt(json, AlertMessageLevel, 0);
		alertMessage= getString(json, AlertMessage, "");
		productId = JsonUtil.getString(json, ProductIdAndroid);
		deliveryType = JsonUtil.getInt(json, DeliveryType, 0);
		disableSwipe = (JsonUtil.getInt(json, DisableSwipe) != 0);
		browserType = getInt(json, BrowserType, 0);

		if (json.has(CommonContentFlg)) {
			commonContentFlg = (JsonUtil.getInt(json, CommonContentFlg) != 0);
		}

		if (json.has(ThumbnailLargeName)) {
			thumbnailLargeName = JsonUtil.getString(json, ThumbnailLargeName);
		}

		// サービスオプションPDFパスワードあり
		if (json.has(PdfPassword)) {
			pdfPassword = JsonUtil.getString(json, PdfPassword);
		}

		// アンケート・試験
		if (json.has(EnqueteId)) {
			enqueteId = JsonUtil.getLong(json, EnqueteId);
		}
		
		// アンケート・試験
		if (json.has(ReplyLimit)) {
			replyLimit = JsonUtil.getInt(json, ReplyLimit);
		}
		
		// 試験
		if (json.has(ShowResult)) {
			showResult = JsonUtil.getInt(json, ShowResult);
		}
		
		// アンケート・試験
		if (json.has(SendResult)) {
			sendResult = JsonUtil.getInt(json, SendResult);
		}
	}
	
	private Date convertDate(String time) {
		try {
			// サーバ日時をUTCとしてとらえてミリ秒を出し、時差を補正する
			return new Date(DateTimeUtil.toDate(time, "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen).getTime() - ABVDataCache.getInstance().getDiffMinFromUTC() * 60 * 1000);
		} catch (Exception e) {
			return null;
		}
	}
	
	/**
	 * Jsonの値をコピーしたDtoを作成して返します。
	 * 
	 * @return dto
	 */	
	public ContentDto convertToDto() {
		ContentDto dto = new ContentDto();
		dto.contentId = contentId;
		dto.categoryId = categoryId;
		dto.contentName = contentName;
		dto.contentNameKana = contentNameKana;
		dto.contentDetail = contentDetail;
		dto.deliveryStartDate = deliveryStartDate;
		dto.deliveryEndDate = deliveryEndDate;
		dto.allPageNum = allPageNum;
		dto.orientation = orientation;
		dto.thumbnailNormalPath = thumbnailName;
		dto.thumbnailBigPath = thumbnailBigName;
		dto.metaVersion = metaVersion;
		dto.resourceVersion = resourceVersion;
		dto.tags = tags;
		dto.groupIds = groupIds;
		dto.contentSize = contentSize;
		dto.contractContentId = contractContentId;
		dto.contentType = contentType;
		dto.lastDeliveryDate = lastDeliveryDate;
		dto.alertMessageLevel = alertMessageLevel;
		dto.alertMessage = alertMessage;
		dto.productId = productId;
		dto.deliveryType = deliveryType;
		dto.disableSwipe = disableSwipe;
		dto.browserType = browserType;
		dto.commonContentFlg = commonContentFlg;
		return dto;
	}
}
