package jp.agentec.abook.abv.bl.acms.client.json.content;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.adf.util.StringUtil;

import org.json.adf.JSONArray;
import org.json.adf.JSONException;
import org.json.adf.JSONObject;

public class PDFLinkJSON {
	public static final String LINKLIST = "linkList";
	public static final String PAGE = "page";
	private JSONArray root;
	
	public PDFLinkJSON(String json) {
		if (StringUtil.isNullOrEmpty(json)) {
			root = new JSONArray();
		}
		else {
			root = new JSONArray(json);
		}
	}
	
	public JSONArray getJsonArray() {
		return  root;
	}
	
	public JSONObject getJsonObject(int num) {
		JSONObject result = null;
		try {
			result = root.getJSONObject(num);
		} catch (JSONException e) {
			Logger.e("[PDFLinkJSONException]new", e);
		}
		return result;
	}
	
	/**
	 * Page毎の設定Object情報を取り出す
	 * @param pageNumber
	 * @return JSONObject ページがない場合nullが返る
	 */
	public JSONArray getPageObject(int pageNumber) {
		JSONArray result = null;
		try {
			for (int i = 0; i < root.length(); i++) {
				JSONObject temp = root.getJSONObject(i);
				int page = JsonUtil.getInt(temp, PAGE); // -1可
				if (page == pageNumber) {
					result = JsonUtil.getJSONArray(temp, LINKLIST);
					break;
				}
			}
		} catch (JSONException e) {
			//
		}
		return result;
	}
}
