package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.PasswordLockInfoDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class PasswordLockInfoDao extends AbstractDao {
	
	/**
	 * {@link PasswordLockInfoDao} のインスタンスを初期化します。
	 * context アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ PasswordLockInfoDao() {
	}
	
	@Override
	protected PasswordLockInfoDto convert(Cursor cursor) {
		PasswordLockInfoDto dto = new PasswordLockInfoDto();
		
		int column = cursor.getColumnIndex("id");
		if (column != -1) {
			dto.id = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("invalid_password_count");
		if (column != -1) {
			dto.invalidPasswordCount = cursor.getShort(column);
		}
		column = cursor.getColumnIndex("password_lock_date");
		if (column != -1) {
			dto.passwordLockDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		
		return dto;
	}

	public List<PasswordLockInfoDto> getPasswordLockInfo() {
		return rawQueryGetDtoList("select * from m_password_lock_info", null, PasswordLockInfoDto.class);
	}

	public void insertPasswordLockInfo(PasswordLockInfoDto dto) {
		insert("insert into m_password_lock_info (id, invalid_password_count, password_lock_date) values (?,?,?)", dto.getInsertValues());
	}
	
	public boolean updatePasswordLockInfo(PasswordLockInfoDto dto) {
		long count = update("update m_password_lock_info set invalid_password_count=?, password_lock_date=? where id=?", dto.getUpdateValues());
		return count > 0;
	}
}
