package jp.agentec.abook.abv.bl.logic;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.AcmsCommonJSON;
import jp.agentec.abook.abv.bl.acms.client.json.AgreementToTermsJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.AgreementToTermsParameters;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;

/**
 * 規約同意の入出力
 */
public class AgreementToTermsLogic extends AbstractLogic {
    private static final String TAG = "AgreementToTermsLogic";

    /**
     * 規約情報の取得
     *
     * @return 規約情報
     * @throws AcmsException CMSがエラーを返したという例外
     * @throws NetworkDisconnectedException ネットワークエラー
     */
    public AgreementToTermsJSON getTerms() throws AcmsException, NetworkDisconnectedException {
        String sid = cache.getMemberInfo().sid;
        return AcmsClient.getInstance(cache.getUrlPath(), networkAdapter).getTerms(sid);
    }

    /**
     * 同意したことをCMSに通達
     *
     * @param termsVersion  バージョン
     * @return 標準的なレスポンス情報
     * @throws AcmsException CMSがエラーを返したという例外
     * @throws NetworkDisconnectedException ネットワークエラー
     */
    public AcmsCommonJSON agreeTerms(String termsVersion) throws AcmsException, NetworkDisconnectedException {
        String sid = cache.getMemberInfo().sid;
        return AcmsClient.getInstance(cache.getUrlPath(), networkAdapter).agreeTerms(new AgreementToTermsParameters(sid, termsVersion));
    }
}
