package jp.agentec.adf.util;

import static org.junit.Assert.assertTrue;
import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import junit.framework.Assert;

import org.json.adf.JSONObject;
import org.junit.Test;

@SuppressWarnings("deprecation")
public class JSONUtilTest {
	@Test
	public void testToObjectStringClassOfT() {
		String jsonString = "{\"httpStatus\":400,\"errorMessage\":[\"ログインIDは必須です。\",\"パスワードは必須です。\",\"udIdは必須です。\"]}";
		
		try {
//			AcmsException obj = JSONUtil.toObject(jsonString, AcmsException.class);
			Object obj = null;
			
			if (obj != null) {
				System.out.println(obj.toString());
			}
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
//		} catch (IllegalAccessException e) {
//			e.printStackTrace();
//		} catch (JSONException e) {
//			e.printStackTrace();
//		} catch (InstantiationException e) {
//			e.printStackTrace();
//		} catch (InvocationTargetException e) {
//			e.printStackTrace();
		}
		
		assertTrue(true);
	}
	
	@Test
	public void testGet() {
		JSONObject json = new JSONObject("{\"mediaType\":6,\"action\":{\"target\":\"20121017183739197\",\"index\":\"2\",\"actionType\":\"7\"},\"location\":{\"x\":310,\"width\":120,\"y\":755,\"height\":78.984375},\"mediaInfo\":{\"resourceId\":\"183\",\"fileName\":\"0003_0000000017_0000000183_RESOURCE.jpg\"}}],\"page\":1}");
		try {
			System.out.println(JsonUtil.get(json, int.class, "action", "actionType"));
		} catch (ABVException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Test
	public void testGet2() {
		boolean print = false;
		
		String jsonText = "{\"contentId\":\"29\",\"isOk\":false,\"vertical\":{\"pages\":[{\"objects\":[{\"mediaType\":2,\"action\":{\"ratio\":\"standard\",\"video\":\"0003_0000000001_0000000002_RESOURCE_IPAD.mov\",\"actionType\":1},\"location\":{\"x\":104,\"width\":267,\"y\":333,\"height\":170},\"mediaInfo\":{\"displayFileName\":\"ABC Song.mov\",\"resourceId\":\"2\",\"icon\":{\"position\":\"22\",\"scale\":31},\"fileName\":\"0003_0000000001_0000000002_RESOURCE_IPAD.mov\"}}],\"page\":0},{\"objects\":[{\"mediaType\":4,\"location\":{\"x\":65,\"width\":315,\"y\":296,\"height\":208},\"mediaInfo\":{\"id\":\"20121017183739197\",\"aspectType\":0,\"media\":[{\"index\":\"0\",\"resourceId\":\"3\",\"fileName\":\"0003_0000000002_0000000003_RESOURCE.jpg\"},{\"index\":\"1\",\"resourceId\":\"4\",\"fileName\":\"0003_0000000003_0000000004_RESOURCE.jpg\"},{\"index\":\"2\",\"resourceId\":\"183\",\"fileName\":\"0003_0000000017_0000000183_RESOURCE.jpg\"}],\"triggerType\":0}},{\"mediaType\":6,\"action\":{\"target\":\"20121017183739197\",\"index\":\"0\",\"actionType\":\"7\"},\"location\":{\"x\":491,\"width\":120,\"y\":346,\"height\":147.19211822660097},\"mediaInfo\":{\"resourceId\":\"3\",\"fileName\":\"0003_0000000002_0000000003_RESOURCE.jpg\"}},{\"mediaType\":6,\"action\":{\"target\":\"20121017183739197\",\"index\":\"1\",\"actionType\":\"7\"},\"location\":{\"x\":496,\"width\":120,\"y\":542,\"height\":180},\"mediaInfo\":{\"resourceId\":\"4\",\"fileName\":\"0003_0000000003_0000000004_RESOURCE.jpg\"}},{\"mediaType\":6,\"action\":{\"target\":\"20121017183739197\",\"index\":\"2\",\"actionType\":\"7\"},\"location\":{\"x\":310,\"width\":120,\"y\":755,\"height\":78.984375},\"mediaInfo\":{\"resourceId\":\"183\",\"fileName\":\"0003_0000000017_0000000183_RESOURCE.jpg\"}}],\"page\":1},{\"objects\":[{\"mediaType\":1,\"action\":{\"resourceIds\":[\"4\",\"183\"],\"preview\":[\"0003_0000000003_0000000004_RESOURCE.jpg\",\"0003_0000000017_0000000183_RESOURCE.jpg\"],\"actionType\":\"4\"},\"location\":{\"x\":121,\"width\":200,\"y\":171,\"height\":50},\"mediaInfo\":{\"flexResourceId\":\"184\",\"vectorSkin\":{\"cornerRadius\":8,\"skinType\":\"simpleButton\",\"backgroundAlpha\":1,\"backgroundColor\":16777215,\"label\":{\"text\":\"danboo1.JPG\",\"fontSize\":12,\"fontColor\":1118481}},\"resourceId\":\"184\",\"fileName\":\"201211_518435188.png\"}},{\"mediaType\":1,\"action\":{\"playType\":\"0\",\"actionType\":\"2\",\"music\":\"0003_0000000014_0000000168_RESOURCE.mp3\",\"resourceId\":\"168\"},\"location\":{\"x\":182,\"width\":200,\"y\":390,\"height\":50},\"mediaInfo\":{\"flexResourceId\":\"185\",\"vectorSkin\":{\"cornerRadius\":8,\"skinType\":\"simpleButton\",\"backgroundAlpha\":1,\"backgroundColor\":16777215,\"label\":{\"text\":\"おと！\",\"fontSize\":12,\"fontColor\":1118481}},\"resourceId\":\"185\",\"fileName\":\"201211_5182643451.png\"}}],\"page\":2}],\"pdfFile\":\"0003_0000000007_0000000008_PDF.pdf\"}}";
		ContentJSON json = new ContentJSON(jsonText);
		try {
			System.out.println(JsonUtil.get(json, Integer.class, "vertical", null));
			assertTrue(false);
		} catch (IllegalArgumentException e) {
			assertTrue("null check", e.getMessage().startsWith("KeyOrIndex is invalid. index=1 arg=null"));
			if(print)e.printStackTrace();
		} catch (ABVException e) {
			e.printStackTrace();
			assertTrue(false);
		}
		
		try {
			System.out.println(JsonUtil.get(json, Integer.class, "vertical", "pages", 0, "objects", "mediaType"));
			assertTrue(false);
		} catch (ABVException e) {
			if(print)e.printStackTrace();
			assertTrue("invalid arg. key for index.", e.getMessage().startsWith("KeyOrIndex is invalid. index=4 arg=mediaType"));
		}
		
		try {
			System.out.println(JsonUtil.get(json, Integer.class, "vertical", "pages", 0, 1));
			assertTrue(false);
		} catch (ABVException e) {
			if(print)e.printStackTrace();
			assertTrue("invalid arg. index for key.", e.getMessage().startsWith("KeyOrIndex is invalid. index=3 arg=1"));
		}
		
		try {
			System.out.println(JsonUtil.get(json, Integer.class, "vertical", "pages", 0, "objects", 10));
			assertTrue(false);
		} catch (ABVException e) {
			if(print)e.printStackTrace();
			assertTrue("invalid arg. index outofbound.", e.getMessage().startsWith("JSONArray[10] not found."));
		}
		
		try {
			Assert.assertEquals("pages", false, (boolean)JsonUtil.getBoolean(json, "isOk"));
			Assert.assertEquals("pages", 3, JsonUtil.getInt(json, "vertical", "pages"));
			Assert.assertEquals("pages", 2, (int)JsonUtil.get(json, Integer.class, "vertical", "pages", 0, "objects", 0, "mediaType"));
			Assert.assertEquals("pages", "standard", (String)JsonUtil.getString(json, "vertical", "pages", 0, "objects", 0, "action", "ratio"));
			Assert.assertEquals("pages", "1", (String)JsonUtil.get(json, String.class, "vertical", "pages", 0, "objects", 0, "action", "actionType"));
			Assert.assertEquals("pages", 1, (int)JsonUtil.get(json, Integer.class, "vertical", "pages", 0, "objects", 0, "action", "actionType"));
			Assert.assertEquals("pages", 147.19211822660097, (Double)JsonUtil.get(json, Double.class, "vertical", "pages", 1, "objects", 1, "location", "height"));
			float a = JsonUtil.get(json, Double.class, "vertical", "pages", 1, "objects", 1, "location", "height").floatValue();
			Assert.assertEquals("pages", "22", (String)JsonUtil.get(json, String.class, "vertical", "pages", 0, "objects", 0, "mediaInfo", "icon", "position"));
			Assert.assertEquals("pages", 22, (int)JsonUtil.get(json, Integer.class, "vertical", "pages", 0, "objects", 0, "mediaInfo", "icon", "position"));
		} catch (ABVException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			assertTrue(false);
		}
		
		
	}

}
