package jp.agentec.abook.abv.launcher.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import androidx.multidex.MultiDex;
import androidx.multidex.MultiDexApplication;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.cl.helper.ABVUncaughtExceptionHandler;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.util.Initializer;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.adf.util.FileUtil;

public class ABVApplication extends MultiDexApplication {
	private static final String TAG = "ABVApplication";
	
	private ABVUIDataCache aBVUIDataCache;
	private ABVApplicationHelper abvApplicationHelper;
	private boolean isMainActivityCalled = false;
	//プッシュ―メッセージでコンテンツをダウンロード場合ダウンロードした後に自動的に開く
	private boolean isAutoOpenAfterDownloadContent;

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

	@Override
    public void onCreate() {
        super.onCreate();
        /** Called when the Application-class is first created. */
        Logger.i(TAG,"--- onCreate() ---");
    	init();
    }
 
    private void init() {
		Initializer initializer = Initializer.getInstance();
		initializer.init(this);

		aBVUIDataCache = new ABVUIDataCache(this);
		isAutoOpenAfterDownloadContent = false;
		
		ABVUncaughtExceptionHandler exceptionHandler = ABVUncaughtExceptionHandler.getInstancer();
        exceptionHandler.init(this);
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);

		//添付ファイル臨時保存場所削除
		FileUtil.delete(ABVEnvironment.getInstance().getCacheTempAttachedImageDirPath());

		// 絞り検索のfetchDateをローカルに保存された値を取得して設定する
		ABVDataCache.getInstance().setTempApertureMasterDataFetchDate(PreferenceUtil.getUserPref(this, AppDefType.UserPrefKey.APERTURE_MASTER_DATA_FETCH_DATE, null));
	}

    @Override
    public void onTerminate() { // 呼ばれることはないので意味がないが
		super.onTerminate();
        /** This Method Called when this Application finished. */
        Logger.v(TAG,"--- onTerminate() in ---");
        super.onTerminate();
        try {
			ActivityHandlingHelper.getInstance().destroy();
		} catch (Exception e) {
	        Logger.e(TAG,"--- onTerminate() stopContentDownlodKickService ---", e);
		}
    }
	
	public ABVUIDataCache getABVUIDataCache() {
		return aBVUIDataCache;
	}
	
	public static ABVUIDataCache getABVUIDataCache(Context context) {
		Application app = (context instanceof Activity)? ((Activity) context).getApplication(): (Application)context;
		return ((ABVApplication)app).getABVUIDataCache();
	}

	public ABVApplicationHelper getABVApplicationHelper() {
		return abvApplicationHelper;
	}

	public boolean isMainActivityCalled() {
		return isMainActivityCalled;
	}

	public void setMainActivityCalled(boolean isMainActivityCalled) {
		this.isMainActivityCalled = isMainActivityCalled;
	}
	
	public boolean isAutoOpenAfterDownloadContent() {
		return isAutoOpenAfterDownloadContent;
	}

	public void setAutoOpenAfterDownloadContent(boolean isAutoOpenContent) {
		this.isAutoOpenAfterDownloadContent = isAutoOpenContent;
	}
}
