package jp.agentec.abook.abv.ui.common.helper;

import jp.agentec.abook.abv.ui.common.activity.ABVActivity;

public abstract class NavigationContentDownloadForReader {

	protected NavigationForReaderInterface mContentReaderInterface;
	protected ABVActivity mActivity;
	
	public NavigationContentDownloadForReader (NavigationForReaderInterface contentReaderInterface, ABVActivity activity) {
		mContentReaderInterface = contentReaderInterface;
		mActivity = activity;
	}
	//次の処理をする
	public abstract void moveToNextDisposal();
	public abstract void showMessageDialog( String title, String msg);
	
	//コンテンツをダウンロードしようとする時に起きられる状態の振る舞い
	public interface NavigationForReaderInterface {
		void UpdateContent (String repositoryFqdn, String shareKey);
		void openContent (long contentId);
		void downloadContent();
		void showPassInput(String repositoryFqdn, String shareKey);
		void onFinishPushActivity();
	}
	
	public void goToNext(final int alertType, final String title, final String msg) {
		mActivity.runOnUiThread(new Runnable() {
			@Override
			public void run() {
				if (alertType == 0) {
					moveToNextDisposal();
				} else {
					showMessageDialog(title, msg);
				}
			}
		});
	}
}
