package jp.agentec.abook.abv.ui.common.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.LightingColorFilter;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ABVThumbnailImageView extends ImageView {
	
	public ABVThumbnailImageView(Context context) {
		super(context);
		setImage();
	}

	public ABVThumbnailImageView(Context context, AttributeSet attrs) {
		super(context, attrs);
		setImage();
	}
	
	public ABVThumbnailImageView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		setImage();
	}
	
	private void setImage() {

		setOnTouchListener(new OnTouchListener() {
			@Override
			public boolean onTouch(View v, MotionEvent event) {
				ImageView image = (ImageView) v;
				switch (event.getAction()) {
				case MotionEvent.ACTION_DOWN:
					image.setColorFilter(new LightingColorFilter(Color.LTGRAY, 1));
					break;
				case MotionEvent.ACTION_MOVE:
					image.setColorFilter(new LightingColorFilter(Color.LTGRAY, 1));
					break;
				default:
					image.setColorFilter(null);
					break;
				}
				return false;
			}
		});
	}
	
}
