package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.bl.dto.HelpDisplayInfoDto;
import jp.agentec.abook.abv.launcher.android.R;

public class HelpAdapter extends ArrayAdapter<HelpDisplayInfoDto> {
    private LayoutInflater mInflater;

    public HelpAdapter(Context context, List<HelpDisplayInfoDto> objects) {
        super(context, 0, objects);
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }
    @Override
    public boolean isEnabled(int position) {
        return false;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_help_list, parent, false);
            holder = new HelpAdapter.ViewHolder();
            holder.helpIconImageView = (ImageView) convertView.findViewById(R.id.iv_help_icon);
            holder.descriptionTextView = (TextView) convertView.findViewById(R.id.tv_help_description);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        final HelpDisplayInfoDto dto = getItem(position);
        if (dto != null) {
            holder.helpIconImageView.setImageResource(dto.resourceId);
            holder.descriptionTextView.setText(dto.helpDescription);
        }

        return convertView;
    }

    private class ViewHolder {
        ImageView helpIconImageView;
        TextView descriptionTextView;
    }
}
