package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.CategoryContentDto;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.launcher.android.R;

public class OperationRelatedContentSectionAdapter extends BaseAdapter {
    final private String TAG = "OperationRelatedContentSectionAdapter";
    private List<CategoryContentDto> categoryContentDtorArray = new ArrayList<>();
    private Context mContext;
    private LayoutInflater mInflater;
    private boolean mNomalSizeFlg;

    private OperationRelatedContentSectionAdapter.OperationRelatedContentSectionListener mListener;
    private static final int NORMAL_SIZE_COLUMN = 1;
    private static final int LARGE_SIZE_COLUMN = 2;

    private ConcurrentHashMap<String , ViewHolder> mViewHolderMap;
    private OperationRelatedContentPanelAdapter mOperationRelatedContentPanelAdapter;

    public OperationRelatedContentSectionAdapter(Context context, List<CategoryContentDto> categoryContentDtorArray, boolean nomalSizeFlg) {
        this.mContext = context;
        this.categoryContentDtorArray = categoryContentDtorArray;
        this.mNomalSizeFlg = nomalSizeFlg;
        this.mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        mViewHolderMap = new ConcurrentHashMap<>();
    }

    @Override
    public View getView(int position, View convertView, final ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_related_content_section, parent, false);
            holder = new ViewHolder();
            holder.categoryNameTextView = (TextView) convertView.findViewById(R.id.tv_category_name);
            holder.contentListGridView = (GridView) convertView.findViewById(R.id.gv_content_list);
            convertView.setTag(holder);
        }else {
            holder = (ViewHolder) convertView.getTag();
        }
        CategoryContentDto dto = getItem(position);
        holder.categoryNameTextView.setText(dto.categoryName);


        Logger.d(TAG, "holder.mOperationRelatedContentPanelAdapter == null");
        mOperationRelatedContentPanelAdapter = new OperationRelatedContentPanelAdapter(mContext, dto.contentDtoArray);
        holder.contentListGridView.setAdapter(mOperationRelatedContentPanelAdapter);
        if (mNomalSizeFlg) {
            holder.contentListGridView.setNumColumns(NORMAL_SIZE_COLUMN);
        } else {
            holder.contentListGridView.setNumColumns(LARGE_SIZE_COLUMN);
        }

        mOperationRelatedContentPanelAdapter.setAdapterListener(new OperationRelatedContentPanelAdapter.OperationRelatedContentPanelListener() {
            @Override
            public boolean onContentDownload(long contentId) {
                return mListener.onContentDownload(contentId);
            }

            @Override
            public void onContentDownloadPause(ContentDto contentDto) {
                mListener.onContentDownloadPause(contentDto);
            }

            @Override
            public void onContentDownloadResume(ContentDto contentDto) {
                mListener.onContentDownloadResume(contentDto);
            }

            @Override
            public void onContentDelete(ContentDto contentDto) {
                mListener.onContentDelete(contentDto);
            }

            @Override
            public void onContentDownloadCancel(ContentDto contentDto) {
                mListener.onContentDownloadCancel(contentDto);
            }

            @Override
            public void onOpenContentView(long contentId) {
                mListener.onOpenContentView(contentId);
            }
        });

        mViewHolderMap.put(dto.categoryName, holder);

        return convertView;
    }

    public void setAdapterListener(OperationRelatedContentSectionAdapter.OperationRelatedContentSectionListener listener) {
        this.mListener = listener;
    }

    public interface OperationRelatedContentSectionListener {
        boolean onContentDownload(long contentId);
        void onContentDownloadPause(ContentDto contentDto);
        void onContentDownloadResume(ContentDto contentDto);
        void onOpenContentView(long contentId);
        void onContentDelete(ContentDto contentDto);
        void onContentDownloadCancel(ContentDto contentDto);
    }

    private static class ViewHolder {
        TextView categoryNameTextView;
        GridView contentListGridView;
    }

        @Override
    public int getCount() {
        return categoryContentDtorArray.size();
    }

    @Override
    public CategoryContentDto getItem(int position) {
        return categoryContentDtorArray.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    public List<CategoryContentDto> getListItem() {
        return categoryContentDtorArray;
    }

    public void updateDownloadView(ContentDto contentDto) {
        ViewHolder viewHolder = mViewHolderMap.get(contentDto.categoryNames);
        if (viewHolder != null) {
            OperationRelatedContentPanelAdapter rojectRelatedContentPanelAdapter = (OperationRelatedContentPanelAdapter)viewHolder.contentListGridView.getAdapter();
            rojectRelatedContentPanelAdapter.updateDownloadView(contentDto);
        }
    }
}
