package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Log;

import com.theta.helper.ThetaHelper;
import com.theta.network.HttpConnector;
import com.theta.network.ImageInfo;
import com.theta.view.ImageRow;

import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaImageListActivity;

/**
 * THETAカメラ内の画像情報取得スレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class ImageListTask extends AsyncTask<Void, String, List<ImageRow>> {
    private static final String TAG = "ImageListTask";

    private final WeakReference<ThetaImageListActivity> refActivity;

    public ImageListTask(ThetaImageListActivity refActivity) {
        this.refActivity = new WeakReference<>(refActivity);
    }

    @Override
    protected void onPreExecute() {
        Logger.d(TAG, "onPreExecute");
    }

    @Override
    protected List<ImageRow> doInBackground(Void... params) {
        try {
            Logger.d(TAG, "doInBackground");
            boolean isOldApi = PreferenceUtil.getUserPref(refActivity.get(), ABookKeys.THETA_OLD_VERSION_FLG, false);
            HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS, isOldApi);
            ArrayList<ImageInfo> objects = camera.getList();
            if (objects == null) { //エラー発生
                return null;
            }
            List<ImageRow> imageRows = new ArrayList<>();
            int objectSize = objects.size();
            ThetaHelper thetaHelper = new ThetaHelper(refActivity.get());
            for (int i = 0; i < objectSize; i++) {
                ImageInfo object = objects.get(i);
                ImageRow imageRow = new ImageRow();
                imageRow.setFileId(object.getFileId());
                imageRow.setFileSize(object.getFileSize());
                imageRow.setFileName(object.getFileName());
                imageRow.setCaptureDate(object.getCaptureDate());
                imageRow.setIsPhoto(true);
                Bitmap thumbnail = camera.getThumb(object.getFileId());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                thumbnail.compress(Bitmap.CompressFormat.JPEG, 100, baos);
                final byte[] thumbnailImage = baos.toByteArray();
                imageRow.setThumbnail(thumbnailImage);

                if (thetaHelper.transferredImage(object.getFileId())) {
                    imageRow.setIsTransferred(true);
                } else {
                    imageRow.setIsTransferred(false);
                }
                imageRows.add(imageRow);
            }
            return imageRows;
        } catch (Throwable throwable) {
            String errorLog = Log.getStackTraceString(throwable);
            Logger.e(errorLog);
            return null;
        }
    }

    @Override
    protected void onProgressUpdate(String... values) {
        for (String log : values) {
            Logger.d(TAG, "onProgressUpdate" + log);
        }
    }

    @Override
    protected void onPostExecute(List<ImageRow> imageRows) {
        Logger.d(TAG, "onPostExecute");
        ThetaImageListActivity activity = refActivity.get();
        activity.imageListTaskFinish(imageRows);
    }

    @Override
    protected void onCancelled() {
        Logger.e(TAG, "onCancelled");
        ThetaImageListActivity activity = refActivity.get();
        activity.imageListTaskFinish(null);
    }
}
