package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.app.Activity;
import android.os.AsyncTask;
import android.util.Log;

import com.theta.network.HttpConnector;
import com.theta.network.HttpDownloadListener;
import com.theta.network.ImageData;

import java.lang.ref.WeakReference;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaImageListActivity;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaImagePreviewActivity;

/**
 * THETAカメラ内の１つの画像情報を取得スレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class LoadPhotoTask extends AsyncTask<Void, Object, ImageData> {
    private static final String TAG = "LoadPhotoTask";

    private final WeakReference<Activity> refActivity;

    private String mFileId;
    private long fileSize;
    private long receivedDataSize = 0;

    public LoadPhotoTask(Activity refActivity, String fileId) {
        this.refActivity = new WeakReference<>(refActivity);
        this.mFileId = fileId;
    }

    @Override
    protected void onPreExecute() {
        Logger.d(TAG, "onPreExecute");
        Activity activity = refActivity.get();
        if (activity instanceof ThetaImagePreviewActivity) {
            ThetaImagePreviewActivity previewActivity = (ThetaImagePreviewActivity)activity;
            previewActivity.showProgressView(activity.getString(R.string.progress));
        }

    }

    @Override
    protected ImageData doInBackground(Void... params) {
        try {
            Logger.d(TAG,"start to download image" + mFileId);
            boolean isOldApi = PreferenceUtil.getUserPref(refActivity.get(), ABookKeys.THETA_OLD_VERSION_FLG, false);
            HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS, isOldApi);
            ImageData resizedImageData = camera.getImage(mFileId, new HttpDownloadListener() {
                @Override
                public void onTotalSize(long totalSize) {
                    fileSize = totalSize;
                }

                @Override
                public void onDataReceived(int size) {
                    receivedDataSize += size;

                    if (fileSize != 0) {
                        int progressPercentage = (int) (receivedDataSize * 100 / fileSize);
                        publishProgress(progressPercentage);
                    }
                }
            });
            return resizedImageData;

        } catch (Throwable throwable) {
            String errorLog = Log.getStackTraceString(throwable);
            Logger.e(errorLog);
            return null;
        }
    }

    @Override
    protected void onProgressUpdate(Object... values) {
        Activity activity = refActivity.get();
        if (activity instanceof ThetaImagePreviewActivity) {
            ThetaImagePreviewActivity previewActivity = (ThetaImagePreviewActivity)activity;
            for (Object param : values) {
                if (param instanceof Integer) {
                    Logger.d(TAG, "onProgressUpdate progress = " + param);
                    previewActivity.progressDialogHorizontal.setProgress((Integer) param);
                } else if (param instanceof String) {
                    Logger.d(TAG, "onProgressUpdate param = " + param);
                }
            }
        }
    }

    @Override
    protected void onPostExecute(ImageData imageData) {
        Logger.d(TAG, "onPostExecute");
        Activity activity = refActivity.get();
        if (activity instanceof ThetaImagePreviewActivity) {
            ThetaImagePreviewActivity previewActivity = (ThetaImagePreviewActivity)activity;
            previewActivity.loadPhotoTaskFinish(imageData);
        } else if (activity instanceof ThetaImageListActivity) {
            ThetaImageListActivity imageListActivity = (ThetaImageListActivity)activity;
            imageListActivity.loadPhotoTaskFinish(imageData, mFileId);
        }
    }
}
