/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.client.shape.ui.view.OZBillKeyboardView$1;
import oz.client.shape.ui.view.OZBillKeyboardView$KeyBuilder;
import oz.client.shape.ui.view.OZBillKeyboardView$KeyBuilderInfo;
import oz.client.shape.ui.view.OZBillKeyboardView$OnBillKeyListener;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;

public class OZBillKeyboardView
extends FrameLayout
implements View.OnClickListener {
    public static final int TYPE_BILL_KOR = 0;
    public static final int TEXT_TYPE_NORMAL = 0;
    public static final int TEXT_TYPE_ONLY_NUMBER = 1;
    private static final int CARET_LAST = -1;
    private static final String DEFAULT_TEXT = "";
    private static final int ID_TEXT = 0xFFF8828;
    private static final int ID_KEY = 268404777;
    private static final int KEY_ACTION_NUMBER = 0;
    private static final int KEY_ACTION_MULTIPLY = 1;
    private static final int KEY_ACTION_FUNCTION = -1;
    private static final int KEY_FUNCTION_OK = 1;
    private static final int KEY_FUNCTION_CANCEL = 2;
    private static final int KEY_FUNCTION_RESET = 3;
    private static final int KEY_FUNCTION_WON = 4;
    private static final int KEY_FUNCTION_BACKSPACE = 5;
    private int mType;
    private int mTextType;
    private int mCaret = -1;
    private boolean mAllowMultiline;
    private boolean mNeedUpdate;
    private boolean mDisplayViewAutoSize;
    private String mRealText = "";
    private TextView mDisplayTextView;
    private OZBillKeyboardView$OnBillKeyListener mListener;
    private int mWidth = 500;
    private int mHeight = 500;
    private float mScale = 1.0f;

    private static LayerDrawable getRoundRectShape(float f2, int n, int n2, float f3, int n3, int n4) {
        PaintDrawable paintDrawable = new PaintDrawable(n2);
        paintDrawable.setCornerRadius(f2);
        paintDrawable.getPaint().setAntiAlias(true);
        paintDrawable.getPaint().setStyle(Paint.Style.FILL);
        PaintDrawable paintDrawable2 = new PaintDrawable(n3);
        paintDrawable2.setCornerRadius(f2);
        paintDrawable2.getPaint().setAntiAlias(true);
        paintDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        paintDrawable2.getPaint().setStrokeWidth(f3);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{paintDrawable, paintDrawable2});
        layerDrawable.setAlpha(n4);
        return layerDrawable;
    }

    private static StateListDrawable getRoundRectShape(float f2, int n, int n2, float f3, int n3) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)OZBillKeyboardView.getRoundRectShape(f2, n, n2, f3, n3, 128));
        stateListDrawable.addState(new int[]{-16842919}, (Drawable)OZBillKeyboardView.getRoundRectShape(f2, n, n2, f3, n3, 255));
        return stateListDrawable;
    }

    public OZBillKeyboardView(Context context) {
        super(context);
        this.setNeedUpdate();
    }

    public int getTextType() {
        return this.mTextType;
    }

    public void setKeyboardWidth(int n) {
        this.mWidth = Math.max(0, n);
    }

    public void setKeyboardHeight(int n) {
        this.mHeight = Math.max(0, n);
    }

    public int getKeyboardWidth() {
        return this.mWidth;
    }

    public int getKeyboardHeight() {
        return this.mHeight;
    }

    public void setKeyboardScale(float f2) {
        if (f2 != this.getKeyboardScale()) {
            this.mScale = Math.max(0.1f, f2);
            this.setNeedUpdate();
        }
    }

    public float getKeyboardScale() {
        return this.mScale;
    }

    private int getScaledSize(float f2) {
        return (int)(f2 * this.getKeyboardScale());
    }

    public void setBillKeyListener(OZBillKeyboardView$OnBillKeyListener oZBillKeyboardView$OnBillKeyListener) {
        this.mListener = oZBillKeyboardView$OnBillKeyListener;
    }

    public OZBillKeyboardView$OnBillKeyListener getBillKeyListener() {
        return this.mListener;
    }

    private void setNeedUpdate() {
        this.mNeedUpdate = true;
    }

    public boolean isNeedUpdate() {
        return this.mNeedUpdate;
    }

    public void setLayoutType(int n) {
        if (n != this.getLayoutType()) {
            this.mType = 0;
            this.setNeedUpdate();
        }
    }

    public int getLayoutType() {
        return this.mType;
    }

    private void resetKeyboardViews() {
        this.removeAllViews();
        this.setDisplayTextView(null);
    }

    public void updateKeyboard() {
        if (this.isNeedUpdate() && OZStorage.isUIThread()) {
            this.resetKeyboardViews();
            switch (this.getLayerType()) {
                default: 
            }
            this.updateKeyboard_Bill_KOR();
            this.mNeedUpdate = false;
        }
    }

    private void addKeyBuilderInfos_SetBackground(OZBillKeyboardView$KeyBuilderInfo oZBillKeyboardView$KeyBuilderInfo) {
        block0 : switch (oZBillKeyboardView$KeyBuilderInfo.getAction().action) {
            case 0: 
            case 1: {
                oZBillKeyboardView$KeyBuilderInfo.getProperty().background = OZBillKeyboardView.getRoundRectShape(10.0f, 0, -1, 1.0f, Color.rgb((int)136, (int)138, (int)142));
                break;
            }
            case -1: {
                switch (oZBillKeyboardView$KeyBuilderInfo.getAction().value) {
                    case 5: {
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().background = OZBillKeyboardView.getRoundRectShape(10.0f, 0, -1, 1.0f, Color.rgb((int)136, (int)138, (int)142));
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().top_background_path = "resource/bill_btn_del.png";
                        break block0;
                    }
                    case 2: {
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().background = OZBillKeyboardView.getRoundRectShape(10.0f, 0, Color.rgb((int)237, (int)95, (int)85), 1.0f, Color.rgb((int)218, (int)77, (int)67));
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().textColor = -1;
                        break block0;
                    }
                    case 3: {
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().background = OZBillKeyboardView.getRoundRectShape(10.0f, 0, Color.rgb((int)173, (int)178, (int)188), 1.0f, Color.rgb((int)136, (int)138, (int)142));
                        break block0;
                    }
                    case 1: {
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().background = OZBillKeyboardView.getRoundRectShape(10.0f, 0, Color.rgb((int)22, (int)160, (int)232), 1.0f, Color.rgb((int)39, (int)130, (int)178));
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().textColor = -1;
                        break block0;
                    }
                    case 4: {
                        oZBillKeyboardView$KeyBuilderInfo.getProperty().background = OZBillKeyboardView.getRoundRectShape(10.0f, 0, -1, 1.0f, Color.rgb((int)136, (int)138, (int)142));
                    }
                }
            }
        }
    }

    private void addKeyBuilderInfos(OZBillKeyboardView$KeyBuilder oZBillKeyboardView$KeyBuilder, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, String[] stringArray) {
        for (int j = 0; j < nArray2.length; ++j) {
            OZBillKeyboardView$KeyBuilderInfo oZBillKeyboardView$KeyBuilderInfo = new OZBillKeyboardView$KeyBuilderInfo();
            oZBillKeyboardView$KeyBuilderInfo.getProperty().text = stringArray[j];
            oZBillKeyboardView$KeyBuilderInfo.getAction().value = nArray4[j];
            oZBillKeyboardView$KeyBuilderInfo.getAction().action = nArray[Math.min(j, nArray.length - 1)];
            this.addKeyBuilderInfos_SetBackground(oZBillKeyboardView$KeyBuilderInfo);
            oZBillKeyboardView$KeyBuilder.setInfo(oZBillKeyboardView$KeyBuilderInfo, nArray2[j], nArray3[j]);
        }
    }

    private void updateKeyboard_Bill_KOR() {
        OZBillKeyboardView$KeyBuilder oZBillKeyboardView$KeyBuilder = new OZBillKeyboardView$KeyBuilder(this, this.getContext());
        oZBillKeyboardView$KeyBuilder.setSize(this.getKeyboardWidth(), this.getKeyboardHeight(), 4, 4);
        int[] nArray = new int[]{3, 0, 0, 0, 1, 1, 1, 2, 2, 2};
        int[] nArray2 = new int[]{1, 0, 1, 2, 0, 1, 2, 0, 1, 2};
        int[] nArray3 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        String[] stringArray = new String[]{null, null, null, null, null, null, null, null, null, null};
        this.addKeyBuilderInfos(oZBillKeyboardView$KeyBuilder, new int[]{0}, nArray, nArray2, nArray3, stringArray);
        nArray = new int[]{3, 3};
        nArray2 = new int[]{0, 2};
        nArray3 = new int[]{4, 3};
        stringArray = new String[]{OZAndroidResource.getResource("textbox.bill.zero4"), OZAndroidResource.getResource("textbox.bill.zero3")};
        this.addKeyBuilderInfos(oZBillKeyboardView$KeyBuilder, new int[]{1}, nArray, nArray2, nArray3, stringArray);
        nArray = new int[]{0, 1, 2, 3};
        nArray2 = new int[]{3, 3, 3, 3};
        nArray3 = new int[]{5, 3, 1, 4};
        stringArray = new String[]{DEFAULT_TEXT, OZAndroidResource.getResource("textbox.bill.clear"), OZAndroidResource.getResource(60014), OZAndroidResource.getResource("textbox.bill.won")};
        this.addKeyBuilderInfos(oZBillKeyboardView$KeyBuilder, new int[]{-1}, nArray, nArray2, nArray3, stringArray);
        TextView textView = this.createDisplayTextView();
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        int n = this.getScaledSize(OZStorage.padding_5);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, this.getDisplayTextViewHeight());
        layoutParams.setMargins(n, n, n, n);
        linearLayout.setPadding(n, n, n, n);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        linearLayout.addView((View)oZBillKeyboardView$KeyBuilder.build());
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.setDisplayTextView(textView);
    }

    public int getDisplayTextViewHeight() {
        return Math.max(this.getScaledSize(OZStorage.padding_5) * 10, OZStorage.padding_10 * 4);
    }

    private TextView createDisplayTextView() {
        TextView textView = new TextView(this.getContext());
        textView.setTextSize(2, 24.0f);
        textView.setId(0xFFF8828);
        textView.setGravity(21);
        textView.setTextColor(-16777216);
        if (!this.mAllowMultiline) {
            textView.setSingleLine();
        }
        textView.setPadding((int)OZStorage.padding_1, 0, OZStorage.padding_10, 0);
        textView.setBackgroundDrawable((Drawable)OZBillKeyboardView.getRoundRectShape(10.0f, 0, -1, 1.0f, Color.rgb((int)136, (int)138, (int)142), 255));
        return textView;
    }

    private void setDisplayTextView(TextView textView) {
        this.mDisplayTextView = textView;
        if (this.mDisplayTextView != null) {
            String string = null;
            if (this.getBillKeyListener() != null) {
                string = this.getBillKeyListener().OnValueUpdate(this, this.getRealText());
            }
            this.requestUpdateText(string);
        }
    }

    public boolean isEmpty() {
        return this.mRealText.isEmpty();
    }

    public String getRealText() {
        return this.mRealText;
    }

    public void setRealText(String string) {
        if (string == null) {
            string = DEFAULT_TEXT;
        }
        switch (this.mTextType) {
            case 1: {
                this.setNumberText(string);
                break;
            }
            default: {
                this.mRealText = string;
            }
        }
        if (!this.mAllowMultiline) {
            this.mRealText = this.mRealText.replaceAll("\n", DEFAULT_TEXT);
        }
        this.setNeedUpdate();
    }

    public void setCaret(int n) {
        this.mCaret = n < 0 ? -1 : n;
    }

    private boolean isCaretLast() {
        return this.mCaret == -1;
    }

    public int getCaret() {
        return this.isCaretLast() ? this.mRealText.length() : Math.min(this.mRealText.length(), Math.max(0, this.mCaret));
    }

    private void setNumberText(String string) {
        this.mRealText = string.replaceAll("[^0-9]", DEFAULT_TEXT);
        while (this.mRealText.startsWith("0") && this.mRealText.length() != 1) {
            this.mRealText = this.mRealText.substring(1);
        }
    }

    public void appendRealNumber(int n) {
        if (!this.canAppendZeroRealNumber() && n > 0) {
            this.mRealText = DEFAULT_TEXT;
        }
        if (this.mRealText.isEmpty()) {
            this.mRealText = String.valueOf(n);
            this.setCaret(-1);
        } else {
            this.mRealText = String.format("%s%s%s", this.mRealText.substring(0, this.getCaret()), String.valueOf(n), this.mRealText.substring(this.getCaret()));
            if (!this.isCaretLast()) {
                this.setCaret(this.getCaret() + 1);
            }
        }
    }

    public boolean performBackspace() {
        int n = this.getCaret();
        if (!this.getRealText().isEmpty() && n > 0) {
            if (!this.isCaretLast()) {
                this.setRealText(this.getRealText().substring(0, n - 1) + this.getRealText().substring(n));
                this.setCaret(Math.max(n - 1, 0));
            } else {
                this.setRealText(this.getRealText().substring(0, this.getRealText().length() - 1));
            }
            return true;
        }
        return false;
    }

    public boolean canAppendRealNumber() {
        switch (this.mTextType) {
            case 1: {
                return this.mRealText.length() < 11;
            }
        }
        return true;
    }

    public boolean canAppendZeroRealNumber() {
        switch (this.mTextType) {
            case 1: {
                return !"0".equals(this.mRealText);
            }
        }
        return true;
    }

    public void requestUpdateText() {
        this.requestUpdateText(this.getRealText());
    }

    void requestUpdateText(String string) {
        if (this.getDisplayTextView() != null) {
            OZStorage.workUIThread(new OZBillKeyboardView$1(this, string));
        }
    }

    public boolean setEmptyNumber() {
        boolean bl = false;
        if (!this.isEmpty()) {
            this.mRealText = DEFAULT_TEXT;
            bl = true;
            String string = DEFAULT_TEXT;
            if (this.getBillKeyListener() != null) {
                string = this.getBillKeyListener().OnReset(this);
            }
            this.requestUpdateText(string);
        }
        return bl;
    }

    public TextView getDisplayTextView() {
        return this.mDisplayTextView;
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 268404777: {
                if (view.getTag() == null || !(view.getTag() instanceof OZBillKeyboardView$KeyBuilderInfo)) break;
                ((OZBillKeyboardView$KeyBuilderInfo)view.getTag()).getAction().action(this);
            }
        }
    }

    static /* synthetic */ int access$000(OZBillKeyboardView oZBillKeyboardView, float f2) {
        return oZBillKeyboardView.getScaledSize(f2);
    }

    static /* synthetic */ boolean access$200(OZBillKeyboardView oZBillKeyboardView) {
        return oZBillKeyboardView.mDisplayViewAutoSize;
    }
}

