/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import oz.lottie.custom.okio.Base64;
import oz.lottie.custom.okio.Util;

public final class ByteString
implements Serializable,
Comparable {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    private transient int hashCode;
    private transient String utf8;

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    public static ByteString of(byte ... byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data == null");
        }
        return new ByteString((byte[])byArray.clone());
    }

    public static ByteString of(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("data == null");
        }
        Util.checkOffsetAndCount(byArray.length, n, n2);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new ByteString(byArray2);
    }

    public static ByteString encodeUtf8(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s == null");
        }
        ByteString byteString = new ByteString(string.getBytes(Util.UTF_8));
        byteString.utf8 = string;
        return byteString;
    }

    public String utf8() {
        String string = this.utf8;
        return string != null ? string : (this.utf8 = new String(this.data, Util.UTF_8));
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public static ByteString decodeBase64(String string) {
        if (string == null) {
            throw new IllegalArgumentException("base64 == null");
        }
        byte[] byArray = Base64.decode(string);
        return byArray != null ? new ByteString(byArray) : null;
    }

    public String hex() {
        char[] cArray = new char[this.data.length * 2];
        int n = 0;
        byte[] byArray = this.data;
        int n2 = this.data.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            cArray[n++] = HEX_DIGITS[by >> 4 & 0xF];
            cArray[n++] = HEX_DIGITS[by & 0xF];
            ++n3;
        }
        return new String(cArray);
    }

    public static ByteString decodeHex(String string) {
        if (string == null) {
            throw new IllegalArgumentException("hex == null");
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected hex string: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < byArray.length) {
            int n2 = ByteString.decodeHexDigit(string.charAt(n * 2)) << 4;
            int n3 = ByteString.decodeHexDigit(string.charAt(n * 2 + 1));
            byArray[n] = (byte)(n2 + n3);
            ++n;
        }
        return ByteString.of(byArray);
    }

    private static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c2);
    }

    public static ByteString read(InputStream inputStream, int n) {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("byteCount < 0: " + n);
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n2 += n3;
        }
        return new ByteString(byArray);
    }

    public ByteString toAsciiLowercase() {
        int n = 0;
        while (n < this.data.length) {
            byte by = this.data[n];
            if (by >= 65 && by <= 90) {
                byte[] byArray = (byte[])this.data.clone();
                byArray[n++] = (byte)(by - -32);
                while (n < byArray.length) {
                    by = byArray[n];
                    if (by >= 65 && by <= 90) {
                        byArray[n] = (byte)(by - -32);
                    }
                    ++n;
                }
                return new ByteString(byArray);
            }
            ++n;
        }
        return this;
    }

    public ByteString toAsciiUppercase() {
        int n = 0;
        while (n < this.data.length) {
            byte by = this.data[n];
            if (by >= 97 && by <= 122) {
                byte[] byArray = (byte[])this.data.clone();
                byArray[n++] = (byte)(by - 32);
                while (n < byArray.length) {
                    by = byArray[n];
                    if (by >= 97 && by <= 122) {
                        byArray[n] = (byte)(by - 32);
                    }
                    ++n;
                }
                return new ByteString(byArray);
            }
            ++n;
        }
        return this;
    }

    public byte getByte(int n) {
        return this.data[n];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    public void write(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        outputStream.write(this.data);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ByteString && Arrays.equals(((ByteString)object).data, this.data);
    }

    public int hashCode() {
        int n = this.hashCode;
        return n != 0 ? n : (this.hashCode = Arrays.hashCode(this.data));
    }

    public String toString() {
        if (this.data.length == 0) {
            return "ByteString[size=0]";
        }
        if (this.data.length <= 16) {
            return String.format("ByteString[size=%s data=%s]", this.data.length, this.hex());
        }
        try {
            return String.format("ByteString[size=%s md5=%s]", this.data.length, ByteString.of(MessageDigest.getInstance("MD5").digest(this.data)).hex());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        ByteString byteString = ByteString.read(objectInputStream, n);
        try {
            Field field = ByteString.class.getDeclaredField("data");
            field.setAccessible(true);
            field.set(this, byteString.data);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }

    public boolean rangeEquals(int n, byte[] byArray, int n2, int n3) {
        return n >= 0 && n <= this.data.length - n3 && n2 >= 0 && n2 <= byArray.length - n3 && Util.arrayRangeEquals(this.data, n, byArray, n2, n3);
    }

    public boolean rangeEquals(int n, ByteString byteString, int n2, int n3) {
        return byteString.rangeEquals(n2, this.data, n, n3);
    }

    public final boolean startsWith(ByteString byteString) {
        return this.rangeEquals(0, byteString, 0, byteString.size());
    }

    public int compareTo(ByteString byteString) {
        int n = this.size();
        int n2 = byteString.size();
        int n3 = 0;
        int n4 = Math.min(n, n2);
        while (n3 < n4) {
            int n5;
            int n6 = this.getByte(n3) & 0xFF;
            if (n6 != (n5 = byteString.getByte(n3) & 0xFF)) {
                return n6 < n5 ? -1 : 1;
            }
            ++n3;
        }
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }
}

