/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oz.main.OZStorage;

public class BeepManager {
    private static final String TAG = "OZViewer";
    private static final float BEEP_VOLUME = 1.0f;
    private static final long VIBRATE_DURATION = 200L;
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;

    public BeepManager(Activity activity) {
        this.activity = activity;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    void updatePrefs() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        this.playBeep = BeepManager.shouldBeep(sharedPreferences, (Context)this.activity);
        this.vibrate = true;
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(3);
            this.mediaPlayer = BeepManager.buildMediaPlayer((Context)this.activity);
        }
    }

    public void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.seekTo(0);
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            try {
                Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
                vibrator.vibrate(200L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static boolean shouldBeep(SharedPreferences sharedPreferences, Context context) {
        AudioManager audioManager;
        boolean bl = true;
        if (bl && (audioManager = (AudioManager)context.getSystemService("audio")).getRingerMode() != 2) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static MediaPlayer buildMediaPlayer(Context context) {
        String string;
        MediaPlayer mediaPlayer;
        block24: {
            Exception exception2222;
            FileOutputStream fileOutputStream;
            InputStream inputStream;
            block22: {
                mediaPlayer = new MediaPlayer();
                mediaPlayer.setAudioStreamType(3);
                string = OZStorage.tmpCacheDir + "/OZReport Viewer/res/beep.mp3";
                File file = new File(string);
                inputStream = null;
                fileOutputStream = null;
                inputStream = context.getResources().getAssets().open("resource/beep.mp3");
                if (!file.exists() || file.length() != (long)inputStream.available()) {
                    if (file.exists()) {
                        file.delete();
                    }
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[4096];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                Object var9_10 = null;
                if (inputStream == null) break block22;
                try {
                    inputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2222) {}
            }
            break block24;
            {
                catch (Exception exception3) {
                    Exception exception42222;
                    Log.e((String)TAG, (String)"file copy error", (Throwable)exception3);
                    Object var9_11 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception42222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var9_12 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        try {
            mediaPlayer.setDataSource(string);
            mediaPlayer.setVolume(1.0f, 1.0f);
            mediaPlayer.prepare();
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)iOException.getMessage());
            mediaPlayer = null;
        }
        return mediaPlayer;
    }
}

