/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.Collection;
import java.util.Map;
import oz.util.barcode.Result;
import oz.util.barcode.client.android.DecodeThread;
import oz.util.barcode.client.android.OZCaptureHandler$State;
import oz.util.barcode.client.android.OZCaptureView;
import oz.util.barcode.client.android.ViewfinderResultPointCallback;
import oz.util.barcode.client.android.camera.CameraManager;

public final class OZCaptureHandler
extends Handler {
    public static boolean DEBUG = false;
    private static final String TAG = "OZViewerBarCode";
    private final OZCaptureView activity;
    private final DecodeThread decodeThread;
    private OZCaptureHandler$State state;
    private final CameraManager cameraManager;

    OZCaptureHandler(OZCaptureView oZCaptureView, Collection collection, Map map, String string, CameraManager cameraManager) {
        this.activity = oZCaptureView;
        this.decodeThread = new DecodeThread(oZCaptureView, collection, map, string, new ViewfinderResultPointCallback(oZCaptureView.getViewfinderView()));
        this.decodeThread.start();
        this.state = OZCaptureHandler$State.SUCCESS;
        this.cameraManager = cameraManager;
        cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 2131230725: {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"Got restart preview message");
                }
                this.restartPreviewAndDecode();
                break;
            }
            case 2131230722: {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"Got decode succeeded message");
                }
                this.state = OZCaptureHandler$State.SUCCESS;
                this.activity.handleDecode((Result)message.obj);
                break;
            }
            case 2131230721: {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"decode failed message");
                }
                this.state = OZCaptureHandler$State.PREVIEW;
                this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 2131230720);
                break;
            }
            case 2131230726: {
                if (!DEBUG) break;
                Log.d((String)TAG, (String)"Got return scan result message");
                break;
            }
            case 2131230723: {
                if (!DEBUG) break;
                Log.d((String)TAG, (String)"Got product query message");
            }
        }
    }

    public void quitSynchronously() {
        this.state = OZCaptureHandler$State.DONE;
        this.cameraManager.stopPreview();
        Message message = Message.obtain((Handler)this.decodeThread.getHandler(), (int)2131230724);
        message.sendToTarget();
        try {
            this.decodeThread.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(2131230722);
        this.removeMessages(2131230721);
    }

    private void restartPreviewAndDecode() {
        if (this.state == OZCaptureHandler$State.SUCCESS) {
            this.state = OZCaptureHandler$State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 2131230720);
            this.activity.drawViewfinder();
        }
    }
}

