/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android.camera.exposure;

import android.hardware.Camera;
import android.util.Log;
import oz.util.barcode.client.android.camera.exposure.ExposureInterface;

public final class FroyoExposureInterface
implements ExposureInterface {
    private static final String TAG = FroyoExposureInterface.class.getSimpleName();
    private static final float MAX_EXPOSURE_COMPENSATION = 1.5f;
    private static final float MIN_EXPOSURE_COMPENSATION = 0.0f;

    @Override
    public void setExposure(Camera.Parameters parameters, boolean bl) {
        int n = parameters.getMinExposureCompensation();
        int n2 = parameters.getMaxExposureCompensation();
        if (n != 0 || n2 != 0) {
            float f2 = parameters.getExposureCompensationStep();
            int n3 = bl ? Math.max((int)(0.0f / f2), n) : Math.min((int)(1.5f / f2), n2);
            Log.i((String)TAG, (String)("Setting exposure compensation to " + n3 + " / " + f2 * (float)n3));
            parameters.setExposureCompensation(n3);
        } else {
            Log.i((String)TAG, (String)"Camera does not support exposure compensation");
        }
    }
}

