/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common;

import java.util.Map;
import oz.util.barcode.DecodeHintType;

public final class StringUtils {
    private static final String PLATFORM_DEFAULT_ENCODING = System.getProperty("file.encoding");
    public static final String SHIFT_JIS = "SJIS";
    public static final String GB2312 = "GB2312";
    private static final String EUC_JP = "EUC_JP";
    private static final String UTF8 = "UTF8";
    private static final String ISO88591 = "ISO8859_1";
    private static final boolean ASSUME_SHIFT_JIS = "SJIS".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING) || "EUC_JP".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING);

    private StringUtils() {
    }

    public static String guessEncoding(byte[] byArray, Map map) {
        String string;
        if (map != null && (string = (String)map.get((Object)DecodeHintType.CHARACTER_SET)) != null) {
            return string;
        }
        int n = byArray.length;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl4 = byArray.length > 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65;
        int n13 = 0;
        while (n13 < n && (bl || bl2 || bl3)) {
            int n14 = byArray[n13] & 0xFF;
            if (bl3) {
                if (n2 > 0) {
                    if ((n14 & 0x80) == 0) {
                        bl3 = false;
                    } else {
                        --n2;
                    }
                } else if ((n14 & 0x80) != 0) {
                    if ((n14 & 0x40) == 0) {
                        bl3 = false;
                    } else {
                        ++n2;
                        if ((n14 & 0x20) == 0) {
                            ++n3;
                        } else {
                            ++n2;
                            if ((n14 & 0x10) == 0) {
                                ++n4;
                            } else {
                                ++n2;
                                if ((n14 & 8) == 0) {
                                    ++n5;
                                } else {
                                    bl3 = false;
                                }
                            }
                        }
                    }
                }
            }
            if (bl) {
                if (n14 > 127 && n14 < 160) {
                    bl = false;
                } else if (n14 > 159 && (n14 < 192 || n14 == 215 || n14 == 247)) {
                    ++n12;
                }
            }
            if (bl2) {
                if (n6 > 0) {
                    if (n14 < 64 || n14 == 127 || n14 > 252) {
                        bl2 = false;
                    } else {
                        --n6;
                    }
                } else if (n14 == 128 || n14 == 160 || n14 > 239) {
                    bl2 = false;
                } else if (n14 > 160 && n14 < 224) {
                    ++n7;
                    n9 = 0;
                    if (++n8 > n10) {
                        n10 = n8;
                    }
                } else if (n14 > 127) {
                    ++n6;
                    n8 = 0;
                    if (++n9 > n11) {
                        n11 = n9;
                    }
                } else {
                    n8 = 0;
                    n9 = 0;
                }
            }
            ++n13;
        }
        if (bl3 && n2 > 0) {
            bl3 = false;
        }
        if (bl2 && n6 > 0) {
            bl2 = false;
        }
        if (bl3 && (bl4 || n3 + n4 + n5 > 0)) {
            return UTF8;
        }
        if (bl2 && (ASSUME_SHIFT_JIS || n10 >= 3 || n11 >= 3)) {
            return SHIFT_JIS;
        }
        if (bl && bl2) {
            return n10 == 2 && n7 == 2 || n12 * 10 >= n ? SHIFT_JIS : ISO88591;
        }
        if (bl) {
            return ISO88591;
        }
        if (bl2) {
            return SHIFT_JIS;
        }
        if (bl3) {
            return UTF8;
        }
        return PLATFORM_DEFAULT_ENCODING;
    }
}

