/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Arrays;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.OneDReader;

public final class CodaBarReader
extends OneDReader {
    private static final int MAX_ACCEPTABLE = 512;
    private static final int PADDING = 384;
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final char[] STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private int[] counters = new int[80];
    private int counterLength = 0;

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        int n2;
        int n3;
        Arrays.fill(this.counters, 0);
        this.setCounters(bitArray);
        int n4 = n3 = this.findStartPattern();
        this.decodeRowResult.setLength(0);
        do {
            if ((n2 = this.toNarrowWidePattern(n4)) == -1) {
                throw NotFoundException.getNotFoundInstance();
            }
            this.decodeRowResult.append((char)n2);
        } while ((this.decodeRowResult.length() <= 1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n2])) && (n4 += 8) < this.counterLength);
        n2 = this.counters[n4 - 1];
        int n5 = 0;
        int n6 = -8;
        while (n6 < -1) {
            n5 += this.counters[n4 + n6];
            ++n6;
        }
        if (n4 < this.counterLength && n2 < n5 / 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.validatePattern(n3);
        n6 = 0;
        while (n6 < this.decodeRowResult.length()) {
            this.decodeRowResult.setCharAt(n6, ALPHABET[this.decodeRowResult.charAt(n6)]);
            ++n6;
        }
        n6 = this.decodeRowResult.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, (char)n6)) {
            throw NotFoundException.getNotFoundInstance();
        }
        char c2 = this.decodeRowResult.charAt(this.decodeRowResult.length() - 1);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, c2)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.decodeRowResult.length() <= 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (map == null || !map.containsKey((Object)DecodeHintType.RETURN_CODABAR_START_END)) {
            this.decodeRowResult.deleteCharAt(this.decodeRowResult.length() - 1);
            this.decodeRowResult.deleteCharAt(0);
        }
        int n7 = 0;
        int n8 = 0;
        while (n8 < n3) {
            n7 += this.counters[n8];
            ++n8;
        }
        float f2 = n7;
        int n9 = n3;
        while (n9 < n4 - 1) {
            n7 += this.counters[n9];
            ++n9;
        }
        float f3 = n7;
        return new Result(this.decodeRowResult.toString(), null, new ResultPoint[]{new ResultPoint(f2, n), new ResultPoint(f3, n)}, BarcodeFormat.CODABAR);
    }

    void validatePattern(int n) {
        int n2;
        int n3;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n4 = this.decodeRowResult.length() - 1;
        int n5 = n;
        int n6 = 0;
        while (true) {
            int n7 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n6)];
            n3 = 6;
            while (n3 >= 0) {
                int n8 = n2 = (n3 & 1) + (n7 & 1) * 2;
                nArray[n8] = nArray[n8] + this.counters[n5 + n3];
                int n9 = n2;
                nArray2[n9] = nArray2[n9] + 1;
                n7 >>= 1;
                --n3;
            }
            if (n6 >= n4) break;
            n5 += 8;
            ++n6;
        }
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        n3 = 0;
        while (n3 < 2) {
            nArray4[n3] = 0;
            nArray4[n3 + 2] = (nArray[n3] << 8) / nArray2[n3] + (nArray[n3 + 2] << 8) / nArray2[n3 + 2] >> 1;
            nArray3[n3] = nArray4[n3 + 2];
            nArray3[n3 + 2] = (nArray[n3 + 2] * 512 + 384) / nArray2[n3 + 2];
            ++n3;
        }
        n5 = n;
        n3 = 0;
        while (true) {
            n2 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n3)];
            int n10 = 6;
            while (n10 >= 0) {
                int n11 = this.counters[n5 + n10] << 8;
                int n12 = (n10 & 1) + (n2 & 1) * 2;
                if (n11 < nArray4[n12] || n11 > nArray3[n12]) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n2 >>= 1;
                --n10;
            }
            if (n3 >= n4) break;
            n5 += 8;
            ++n3;
        }
    }

    private void setCounters(BitArray bitArray) {
        int n;
        this.counterLength = 0;
        int n2 = bitArray.getNextUnset(0);
        if (n2 >= (n = bitArray.getSize())) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean bl = true;
        int n3 = 0;
        while (n2 < n) {
            if (bitArray.get(n2) ^ bl) {
                ++n3;
            } else {
                this.counterAppend(n3);
                n3 = 1;
                bl = !bl;
            }
            ++n2;
        }
        this.counterAppend(n3);
    }

    private void counterAppend(int n) {
        this.counters[this.counterLength] = n;
        ++this.counterLength;
        if (this.counterLength >= this.counters.length) {
            int[] nArray = new int[this.counterLength * 2];
            System.arraycopy(this.counters, 0, nArray, 0, this.counterLength);
            this.counters = nArray;
        }
    }

    private int findStartPattern() {
        int n = 1;
        while (n < this.counterLength) {
            int n2 = this.toNarrowWidePattern(n);
            if (n2 != -1 && CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n2])) {
                int n3 = 0;
                int n4 = n;
                while (n4 < n + 7) {
                    n3 += this.counters[n4];
                    ++n4;
                }
                if (n == 1 || this.counters[n - 1] >= n3 / 2) {
                    return n;
                }
            }
            n += 2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static boolean arrayContains(char[] cArray, char c2) {
        if (cArray != null) {
            char[] cArray2 = cArray;
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c3 = cArray2[n2];
                if (c3 == c2) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private int toNarrowWidePattern(int n) {
        int n2;
        int n3;
        int n4 = n + 7;
        if (n4 >= this.counterLength) {
            return -1;
        }
        int[] nArray = this.counters;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        int n7 = n;
        while (n7 < n4) {
            n3 = nArray[n7];
            if (n3 < n6) {
                n6 = n3;
            }
            if (n3 > n5) {
                n5 = n3;
            }
            n7 += 2;
        }
        n7 = (n6 + n5) / 2;
        n3 = 0;
        int n8 = Integer.MAX_VALUE;
        int n9 = n + 1;
        while (n9 < n4) {
            n2 = nArray[n9];
            if (n2 < n8) {
                n8 = n2;
            }
            if (n2 > n3) {
                n3 = n2;
            }
            n9 += 2;
        }
        n9 = (n8 + n3) / 2;
        n2 = 128;
        int n10 = 0;
        int n11 = 0;
        while (n11 < 7) {
            int n12 = (n11 & 1) == 0 ? n7 : n9;
            n2 >>= 1;
            if (nArray[n + n11] > n12) {
                n10 |= n2;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < CHARACTER_ENCODINGS.length) {
            if (CHARACTER_ENCODINGS[n11] == n10) {
                return n11;
            }
            ++n11;
        }
        return -1;
    }
}

