/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.animatable;

import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import oz.util.view.animatable.AnimatableFrameLayout;

class AnimatableFrameLayout$MoveJob
implements Runnable {
    public static final int SEQ_CREATE = 0;
    public static final int SEQ_SCROLL_START = 1;
    public static final int SEQ_SCROLL_END = 2;
    public static final int SEQ_SCROLL_AFTER = 3;
    public AnimatableFrameLayout parent;
    public int seq;
    public View oldView;
    public View nextView;
    public int duration;
    public boolean reverse;
    public ViewGroup.LayoutParams backupLayoutParams;
    private boolean cancel;

    public AnimatableFrameLayout$MoveJob(AnimatableFrameLayout animatableFrameLayout) {
        this.parent = animatableFrameLayout;
        this.seq = 0;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.cancel) {
            this.cancel = true;
            Object object = AnimatableFrameLayout.access$300(this.parent);
            synchronized (object) {
                switch (this.seq) {
                    case 1: 
                    case 2: {
                        this.tryRemoveOldView();
                        this.tryRestoreNextViewLayout();
                        if (this.seq == 1) {
                            this.callListenerScrollFinish();
                        }
                        this.callListenerScrollAfter();
                    }
                }
            }
        }
    }

    public void tryRestoreNextViewLayout() {
        if (this.nextView != null && this.backupLayoutParams != null && Looper.getMainLooper() == Looper.myLooper()) {
            this.nextView.setLayoutParams(this.backupLayoutParams);
            this.nextView.postInvalidate();
        }
    }

    public void tryRemoveOldView() {
        if (this.oldView != null && Looper.getMainLooper() == Looper.myLooper()) {
            this.parent.removeView(this.oldView);
        }
    }

    public void callListenerScrollStart() {
        if (this.parent.getMoveListener() != null) {
            this.parent.getMoveListener().OnStartMove(this.parent, this.nextView, this.oldView, this.reverse);
        }
    }

    public void callListenerScrollFinish() {
        if (this.parent.getMoveListener() != null) {
            this.parent.getMoveListener().OnFinishMove(this.parent, this.nextView, this.oldView, this.reverse);
        }
    }

    public void callListenerScrollAfter() {
        if (this.parent.getMoveListener() != null) {
            this.parent.getMoveListener().OnAfterMove(this.parent, this.nextView, this.oldView, this.reverse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.cancel) {
            Object object = AnimatableFrameLayout.access$300(this.parent);
            synchronized (object) {
                switch (this.seq) {
                    case 0: {
                        this.startScroll();
                        break;
                    }
                    case 1: {
                        this.endScroll();
                        break;
                    }
                    case 2: {
                        this.afterScroll();
                    }
                }
            }
        }
    }

    private boolean isValid() {
        return !this.cancel && (this.nextView != null || this.oldView != null);
    }

    private void startScroll() {
        if (this.isValid()) {
            if (this.nextView != null && this.nextView.getParent() != null) {
                ViewGroup viewGroup = (ViewGroup)this.nextView.getParent();
                viewGroup.removeView(this.nextView);
            }
            int n = this.parent.getScrollX();
            int n2 = this.parent.getScrollY();
            int n3 = this.parent.getHeight();
            if (n3 == 0) {
                this.parent.measure(0, 0);
                n3 = this.parent.getMeasuredHeight();
            }
            int n4 = 0;
            if (this.nextView != null) {
                this.backupLayoutParams = this.nextView.getLayoutParams();
                if (this.backupLayoutParams == null) {
                    this.backupLayoutParams = new FrameLayout.LayoutParams(-2, -2);
                }
                n4 = this.nextView.getMeasuredHeight();
                if (this.backupLayoutParams != null && this.backupLayoutParams.height > 0) {
                    n4 = this.backupLayoutParams.height;
                }
                if (n4 <= 0) {
                    this.nextView.measure(0, 0);
                    n4 = this.nextView.getMeasuredHeight() + 500;
                }
            }
            int n5 = 0;
            FrameLayout.LayoutParams layoutParams = null;
            if (this.nextView != null) {
                layoutParams = new FrameLayout.LayoutParams(-1, n4);
                if (this.backupLayoutParams != null && this.backupLayoutParams instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.backupLayoutParams;
                    layoutParams.setMargins(marginLayoutParams.leftMargin, marginLayoutParams.topMargin, marginLayoutParams.rightMargin, marginLayoutParams.bottomMargin);
                    layoutParams.setMarginStart(marginLayoutParams.getMarginStart());
                    layoutParams.setMarginEnd(marginLayoutParams.getMarginEnd());
                    layoutParams.setLayoutDirection(marginLayoutParams.getLayoutDirection());
                }
            }
            if (this.reverse) {
                if (n2 != 0) {
                    n5 = n2 > 0 ? (n5 -= n2) : (n5 += n2);
                }
                n5 -= n3;
                n5 -= n4;
                if (layoutParams != null) {
                    if (layoutParams.topMargin > 0) {
                        n5 -= layoutParams.topMargin;
                    }
                    layoutParams.topMargin -= n3;
                    layoutParams.topMargin -= n4;
                }
            } else {
                if (n2 != 0) {
                    n5 -= n2;
                }
                n5 += n3;
                if (layoutParams != null) {
                    if (layoutParams.topMargin > 0) {
                        n5 -= layoutParams.topMargin;
                    }
                    layoutParams.topMargin += n3;
                }
            }
            if (this.nextView != null) {
                this.parent.addView(this.nextView, (ViewGroup.LayoutParams)layoutParams);
            }
            AnimatableFrameLayout.access$400(this.parent).startScroll(n, n2, n, n5, this.duration);
            AnimatableFrameLayout.access$500(this.parent, true);
            this.callListenerScrollStart();
            this.seq = 1;
            AnimatableFrameLayout.access$600(this.parent);
        } else {
            this.cancel = true;
        }
    }

    private void endScroll() {
        if (this.isValid()) {
            this.callListenerScrollFinish();
            AnimatableFrameLayout.access$500(this.parent, false);
            this.seq = 2;
            this.parent.post(this);
        } else {
            this.cancel = true;
        }
    }

    private void afterScroll() {
        if (this.isValid()) {
            this.tryRemoveOldView();
            this.tryRestoreNextViewLayout();
            this.parent.clearMove();
            AnimatableFrameLayout.access$700(this.parent);
            this.callListenerScrollAfter();
            this.seq = 3;
        }
        this.cancel = true;
    }
}

