/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.animatable;

import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import oz.util.view.animatable.AnimatableFrameLayout$DoJob;
import oz.util.view.animatable.AnimatableFrameLayout$MoveJob;
import oz.util.view.animatable.AnimatableFrameLayout$OnMoveListener;

public class AnimatableFrameLayout
extends FrameLayout {
    private boolean mTouchDisable;
    private OverScroller mScroller;
    private boolean mIsReverseMove;
    private boolean mIsMoving;
    private int mMoveDuration;
    private AnimatableFrameLayout$OnMoveListener mListener;
    private View mOldView;
    private View mNextView;
    private AnimatableFrameLayout$MoveJob mCurrentJob;
    private Object mMoveJobLock;
    private Runnable mDoJob;

    public AnimatableFrameLayout(Context context) {
        super(context);
        this.init();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.mTouchDisable) {
            return true;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mTouchDisable) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    private void init() {
        this.setWillNotDraw(false);
        this.mDoJob = new AnimatableFrameLayout$DoJob(this, null);
        this.mScroller = new OverScroller(this.getContext());
        this.mIsMoving = false;
        this.mIsReverseMove = false;
        this.mMoveDuration = 0;
        this.mTouchDisable = false;
        this.mMoveJobLock = new Object();
    }

    private void _postInvalidateOnAnimation() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.postInvalidateOnAnimation();
        } else {
            this.postInvalidate();
        }
    }

    public void computeScroll() {
        if (this.mIsMoving && this.mScroller.computeScrollOffset()) {
            this.setScrollX(this.mScroller.getCurrX());
            this.setScrollY(this.mScroller.getCurrY());
            this._postInvalidateOnAnimation();
        } else {
            super.computeScroll();
            if (this.mIsMoving && this.mCurrentJob != null) {
                this.post(this.mCurrentJob);
            }
        }
    }

    private Object getMoveJobLock() {
        return this.mMoveJobLock;
    }

    private OverScroller getScroller() {
        return this.mScroller;
    }

    private void setMoving(boolean bl) {
        this.mIsMoving = bl;
    }

    public void setTouchDisable(boolean bl) {
        this.mTouchDisable = bl;
    }

    public boolean isTouchDisable() {
        return this.mTouchDisable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMove() {
        Object object = this.mMoveJobLock;
        synchronized (object) {
            AnimatableFrameLayout$MoveJob animatableFrameLayout$MoveJob = this.mCurrentJob;
            this.mCurrentJob = null;
            if (animatableFrameLayout$MoveJob != null && !animatableFrameLayout$MoveJob.isCancel()) {
                animatableFrameLayout$MoveJob.cancel();
            }
        }
        this.setMoving(false);
        if (!this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
        }
    }

    private void createNewJob() {
        this.mCurrentJob = new AnimatableFrameLayout$MoveJob(this);
        this.mCurrentJob.oldView = this.mOldView;
        this.mCurrentJob.nextView = this.mNextView;
        this.mCurrentJob.duration = this.mMoveDuration;
        this.mCurrentJob.reverse = this.mIsReverseMove;
    }

    private void moveToZero() {
        this.setScrollX(0);
        this.setScrollY(0);
        this._postInvalidateOnAnimation();
    }

    public void setMoveListener(AnimatableFrameLayout$OnMoveListener animatableFrameLayout$OnMoveListener) {
        this.mListener = animatableFrameLayout$OnMoveListener;
    }

    public AnimatableFrameLayout$OnMoveListener getMoveListener() {
        return this.mListener;
    }

    public void setOldView(View view) {
        this.mOldView = view;
    }

    public void setNextView(View view) {
        this.mNextView = view;
    }

    public void setIsNextViewReverse(boolean bl) {
        this.mIsReverseMove = bl;
    }

    public void setMoveDuration(int n) {
        this.mMoveDuration = n;
    }

    public void doMoveNextView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.mDoJob.run();
        } else {
            this.post(this.mDoJob);
        }
    }

    static /* synthetic */ Object access$000(AnimatableFrameLayout animatableFrameLayout) {
        return animatableFrameLayout.mMoveJobLock;
    }

    static /* synthetic */ void access$100(AnimatableFrameLayout animatableFrameLayout) {
        animatableFrameLayout.createNewJob();
    }

    static /* synthetic */ AnimatableFrameLayout$MoveJob access$200(AnimatableFrameLayout animatableFrameLayout) {
        return animatableFrameLayout.mCurrentJob;
    }

    static /* synthetic */ Object access$300(AnimatableFrameLayout animatableFrameLayout) {
        return animatableFrameLayout.getMoveJobLock();
    }

    static /* synthetic */ OverScroller access$400(AnimatableFrameLayout animatableFrameLayout) {
        return animatableFrameLayout.getScroller();
    }

    static /* synthetic */ void access$500(AnimatableFrameLayout animatableFrameLayout, boolean bl) {
        animatableFrameLayout.setMoving(bl);
    }

    static /* synthetic */ void access$600(AnimatableFrameLayout animatableFrameLayout) {
        animatableFrameLayout._postInvalidateOnAnimation();
    }

    static /* synthetic */ void access$700(AnimatableFrameLayout animatableFrameLayout) {
        animatableFrameLayout.moveToZero();
    }
}

