/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.view.View;
import android.widget.Toast;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.main.ACommentView;
import oz.viewer.ui.main.overlay.AScreenToolController$ToastHandler;
import oz.viewer.ui.main.overlay.AScreenToolController$ToastTextView;
import oz.viewer.ui.main.overlay.OZOverlayController;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.OverlayView;

public class AScreenToolController
extends OZOverlayController {
    private static final int MODE_DEFAULT = 0;
    public static final int MODE_HAND = 0;
    public static final int MODE_COMMENT = 1;
    public static final int MODE_GUIDE = 2;
    private static final int HAND_SUBMODE_DEFAULT = 0;
    private static final int COMMENT_SUBMODE_DEFAULT = 0;
    private static final int COMMENT_SUBMODE_MEMO = 1;
    private static final int COMMENT_SUBMODE_FILL = 2;
    private static final int GUIDE_SUBMODE_DEFAULT = 0;
    private static final int[] LIST_TOOLBAR_AREA_SOMETHING = new int[]{4, 6, 5};
    private static final int[] LIST_VISIBLE_OVERLAY_HAND = new int[]{3, 7, 10};
    private static final int[] LIST_VISIBLE_OVERLAY_COMMENT = new int[]{2, 7, 10};
    private int mMode;
    private int mSubType;
    private int mModeOld;
    private int mSubTypeOld;
    private boolean mUseModeChangeToast;
    private boolean mUseUserActionCommand;
    private Toast mToast;
    private AScreenToolController$ToastHandler mToastHandler;

    public AScreenToolController(OverlayLayout overlayLayout) {
        super(overlayLayout, 10002);
        this.initDefault();
        this.initToast();
        this.update();
    }

    public boolean isUseUserActionCommand() {
        return this.mUseUserActionCommand;
    }

    public void setUseUserActionCommand(boolean bl) {
        this.mUseUserActionCommand = bl;
    }

    public boolean isShowModeChangeToast() {
        return this.mUseModeChangeToast;
    }

    public void setUseModeChangeToast(boolean bl) {
        this.mUseModeChangeToast = bl;
    }

    private void initDefault() {
        this.mMode = 0;
        this.mSubType = 0;
        this.mModeOld = 0;
        this.mSubTypeOld = 0;
        this.mUseModeChangeToast = true;
        this.mUseUserActionCommand = true;
    }

    private void initToast() {
        this.mToastHandler = new AScreenToolController$ToastHandler(this, null);
        this.mToast = new Toast(this.getContext());
        this.mToast.setDuration(10000);
        this.mToast.setGravity(17, 0, 0);
        this.mToast.setView((View)new AScreenToolController$ToastTextView(this, this.getContext()));
    }

    public int getScreenToolMode() {
        return this.mMode;
    }

    public int restoreScreenToolMode() {
        return this.mModeOld;
    }

    public void backupScreenToolMode(int n) {
        this.mModeOld = n;
    }

    public boolean isHandMode() {
        return this.getScreenToolMode() == 0;
    }

    public boolean isCommentMode() {
        return this.getScreenToolMode() == 1;
    }

    public void setScreenToolMode(int n, int n2) {
        boolean bl;
        boolean bl2 = this.mMode != n;
        boolean bl3 = bl = bl2 || this.getSubType() != n2;
        if (bl2) {
            int n3 = this.mMode;
            this.mMode = n;
            if (this.isUseUserActionCommand()) {
                this.getNativeController().OnScreenToolChanged(this.mMode);
            }
            if (this.isShowModeChangeToast()) {
                this.showModeChangeToast(n3, this.mMode);
            }
        }
        if (this.getSubType() != n2) {
            this.mSubType = n2;
        }
        if (bl2) {
            this.update();
        } else if (bl) {
            this.updateSubMode();
        }
    }

    public void setHandMode() {
        this.setScreenToolMode(0, 0);
    }

    public void setCommentMode(int n) {
        this.setScreenToolMode(1, n);
    }

    public void setCommentMode() {
        this.setCommentMode(0);
    }

    public void setCommentMemoMode() {
        if (!this.getNativeController().isOnlyDrawWithStylusPen()) {
            this.setCommentMode(1);
        } else if (!this.isCommentMode()) {
            if (this.getNativeController().isFillTypePen()) {
                this.setCommentFillMode();
            } else {
                this.setCommentMode();
            }
        }
    }

    public void setCommentFillMode() {
        this.setCommentMode(2);
    }

    public void setGuideMode() {
        this.setScreenToolMode(2, 0);
    }

    public int getSubType() {
        return this.mSubType;
    }

    public int getSubOldType() {
        return this.mSubTypeOld;
    }

    private void showModeChangeToast(int n, int n2) {
        if (n != n2) {
            this.setModeChangeToastTextView(this.getModeChangeToastText(n2));
            this.mToast.show();
            this.requestToastCancel();
        }
    }

    private void setModeChangeToastTextView(String string) {
        ((AScreenToolController$ToastTextView)this.mToast.getView()).setText(string);
    }

    private String getModeChangeToastText(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.getNativeController().getResourceInputMode();
                if (!string.equalsIgnoreCase("")) break;
                string = OZAndroidResource.getResource("input.mode.message");
                break;
            }
            case 1: {
                string = this.getNativeController().getResourceEditMode();
                if (!string.equalsIgnoreCase("")) break;
                string = OZAndroidResource.getResource("edit.mode.message");
                break;
            }
            case 2: {
                string = this.getNativeController().getResourceGuideMode();
                if (!string.equalsIgnoreCase("")) break;
                string = OZAndroidResource.getResource("guide.mode.message");
            }
        }
        return string;
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean bl) {
        this.updateMode(bl);
        this.updateSubMode(bl);
    }

    private void updateMode(boolean bl) {
        switch (this.mMode) {
            case 0: {
                ACommentView aCommentView;
                this.getNativeController().setCommentMode(true);
                if (this.getOZParent().getIconToolbar() != null) {
                    this.getOZParent().getIconToolbar().getButtonFromKey(2, 5001).hide();
                    this.getOZParent().getIconToolbar().getButtonFromKey(2, 5000).show();
                    this.getOZParent().getIconToolbar().getButtonFromKey(1, 6001).hide();
                    this.getOZParent().getIconToolbar().getButtonFromKey(1, 6000).show();
                    if (bl) {
                        this.getOZParent().getIconToolbar().getButtonFromKey(3, 0).show();
                    }
                    this.getOZParent().getIconToolbar().setButtonTypeVisibility(4, true);
                    this.getOZParent().getIconToolbar().requestUpdateView();
                    if (bl) {
                        this.getOZParent().getIconToolbar().show();
                    }
                }
                if (this.getOZParent().getCommentManager() != null) {
                    this.getOZParent().getCommentManager().setEnable(false);
                }
                if (this.getOZParent().getStatus() != null) {
                    this.getOZParent().getStatus().requestNeedUpdateView();
                }
                if ((aCommentView = this.getNativeController().getCommentView()) == null) break;
                aCommentView.setUserInteractionEnabled(false);
                break;
            }
            case 1: {
                this.getNativeController().setCommentMode(false);
                if (this.getOZParent().getNavigator() != null) {
                    this.getOZParent().getNavigator().hide();
                }
                if (this.getOZParent().getIconToolbar() != null) {
                    this.getOZParent().getIconToolbar().getButtonFromKey(1, 6001).hide();
                    this.getOZParent().getIconToolbar().getButtonFromKey(1, 6000).hide();
                    this.getOZParent().getIconToolbar().getButtonFromKey(2, 5001).show();
                    this.getOZParent().getIconToolbar().getButtonFromKey(2, 5000).hide();
                    this.getOZParent().getIconToolbar().getButtonFromKey(3, 0).hide();
                    this.getOZParent().getIconToolbar().setButtonTypeVisibility(4, false);
                    this.getOZParent().getIconToolbar().requestUpdateView();
                    if (bl) {
                        if (!this.getOZParent().getIconToolbar().isAutoHideEnable()) {
                            this.getOZParent().getIconToolbar().autoHideCancel();
                        }
                        this.getOZParent().getIconToolbar().show();
                    }
                }
                if (this.getOZParent().getCommentManager() != null) {
                    this.getOZParent().getCommentManager().setEnable(true);
                    if (bl) {
                        this.getOZParent().getCommentManager().show();
                    }
                }
                if (this.getOZParent().getStatus() == null) break;
                this.getOZParent().getStatus().requestNeedUpdateView();
                break;
            }
            case 2: {
                if (this.getOZParent().getIconToolbar() == null) break;
                this.getOZParent().getIconToolbar().getButtonFromKey(2, 5001).hide();
                this.getOZParent().getIconToolbar().getButtonFromKey(2, 5000).show();
                this.getOZParent().getIconToolbar().getButtonFromKey(1, 6001).show();
                this.getOZParent().getIconToolbar().getButtonFromKey(1, 6000).hide();
                if (bl) {
                    this.getOZParent().getIconToolbar().getButtonFromKey(3, 0).show();
                }
                this.getOZParent().getIconToolbar().setButtonTypeVisibility(4, true);
                this.getOZParent().getIconToolbar().requestUpdateView();
                if (!bl) break;
                this.getOZParent().getIconToolbar().show();
            }
        }
    }

    public void setScrollBigImage(boolean bl) {
        if (this.getOZParent().getScrollManager() != null) {
            this.getOZParent().getScrollManager().setBigScrollBarMode(bl);
            if (bl) {
                this.getOZParent().getScrollManager().requestAutoHideCancel();
                this.getOZParent().getScrollManager().setAutoHideEnable(false);
                this.getOZParent().getScrollManager().show(false);
            } else {
                this.getOZParent().getScrollManager().setAutoHideEnable(true);
                this.getOZParent().getScrollManager().requestAutoHide();
            }
            if (this.getOZParent().getStatus() != null) {
                this.getOZParent().getStatus().setNeedBigScrollImageMarginRight(bl);
                if (this.getOZParent().getStatus().isShowing()) {
                    this.getOZParent().getStatus().requestUpdateView();
                }
            }
        }
    }

    private void updateSubMode() {
        this.updateSubMode(true);
    }

    private void updateSubMode(boolean bl) {
        boolean bl2 = this.isCommentFillMode();
        boolean bl3 = this.isCommentMemoMode();
        ACommentView aCommentView = this.getNativeController().getCommentView();
        boolean bl4 = false;
        if (this.getNativeController().isOnlyDrawWithStylusPen()) {
            bl4 = true;
        }
        if (bl3) {
            this.getNativeController().setCommentSubModeMemo();
            this.getOZParent().getCommentManager().getBaseView().setMode(10002);
            if (bl4) {
                this.getOZParent().getCommentManager().getBaseView().getBottomBar().setHandMode();
            }
            this.getOZParent().getCommentManager().getBaseView().getBottomBar().setModeBackground();
        } else if (bl2) {
            this.getNativeController().setCommentSubModeFill();
            this.getOZParent().getCommentManager().getBaseView().setMode(10002);
            this.getOZParent().getCommentManager().getBaseView().getBottomBar().setCommentMode(bl);
            this.getOZParent().getCommentManager().getBaseView().getBottomBar().setModeBackground();
        } else if (this.isCommentNormalMode()) {
            this.getNativeController().setCommentSubModeNormal();
            this.getOZParent().getCommentManager().getBaseView().setMode(10001);
            this.getOZParent().getCommentManager().getBaseView().getBottomBar().setCommentMode(bl);
            this.getOZParent().getCommentManager().getBaseView().getBottomBar().setModeBackground();
        }
        if (this.isCommentMode() && aCommentView != null) {
            aCommentView.setUserInteractionEnabled(!bl3 && !bl2);
        }
        if (bl4) {
            this.setScrollBigImage(false);
        } else {
            this.setScrollBigImage(this.isCommentMode());
        }
    }

    private void requestToastCancel() {
        this.mToastHandler.removeMessages(0);
        this.mToastHandler.sendEmptyMessageDelayed(0, 1000L);
    }

    public boolean isShowToolbarAreaSomething() {
        boolean bl = false;
        for (int j = 0; j < LIST_TOOLBAR_AREA_SOMETHING.length; ++j) {
            if (!this.getOZParent().findOverlayView(LIST_TOOLBAR_AREA_SOMETHING[j]).isShowing()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void closeToolbarArea() {
        this.getOZParent().getIconToolbar().hide();
        for (int j = 0; j < LIST_TOOLBAR_AREA_SOMETHING.length; ++j) {
            this.getOZParent().findOverlayView(LIST_TOOLBAR_AREA_SOMETHING[j]).hide();
        }
    }

    public void showToolbarArea(int n) {
        OverlayView overlayView = this.getOZParent().findOverlayView(n);
        if (overlayView.isEnable()) {
            if (!overlayView.isShowing()) {
                this.closeToolbarArea();
            }
            this.getOZParent().findOverlayView(n).show();
        }
    }

    private int[] getCurrentModeVisibleList() {
        if (this.isHandMode()) {
            return LIST_VISIBLE_OVERLAY_HAND;
        }
        if (this.isCommentMode()) {
            return LIST_VISIBLE_OVERLAY_COMMENT;
        }
        return null;
    }

    public void showOverlays() {
        int[] nArray;
        if (!this.isShowToolbarAreaSomething()) {
            this.getOZParent().getIconToolbar().show();
        }
        if ((nArray = this.getCurrentModeVisibleList()) != null) {
            for (int j = 0; j < nArray.length; ++j) {
                this.getOZParent().findOverlayView(nArray[j]).show();
            }
        }
    }

    public void hideOverlays() {
        this.getOZParent().getIconToolbar().hide();
        int[] nArray = this.getCurrentModeVisibleList();
        if (nArray != null) {
            for (int j = 0; j < nArray.length; ++j) {
                this.getOZParent().findOverlayView(nArray[j]).hide();
            }
        }
    }

    public boolean isCommentFillMode() {
        return this.isCommentMode() && this.getSubType() == 2;
    }

    public boolean isCommentMemoMode() {
        return this.isCommentMode() && this.getSubType() == 1;
    }

    public boolean isCommentNormalMode() {
        return this.isCommentMode() && this.getSubType() == 0;
    }

    static /* synthetic */ Toast access$100(AScreenToolController aScreenToolController) {
        return aScreenToolController.mToast;
    }
}

