/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.os.Handler;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView$1;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView$AutoHideHandler;
import oz.viewer.ui.main.overlay.OZOverlayView;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.OverlayView$AutoHideAble;

public class AutoHideAbleOZOverlayView
extends OZOverlayView
implements OverlayView$AutoHideAble {
    private Handler mAutoHideHandler = new AutoHideAbleOZOverlayView$AutoHideHandler(this, null);
    private Animation mDefaultAnimation = this.getHideAnimation();
    private boolean mIsAutoHiding;
    private boolean mIsAutoHideCancel;
    private boolean mIsIgnoreAutoHide;

    AutoHideAbleOZOverlayView(OverlayLayout overlayLayout, int n) {
        super(overlayLayout, n);
        this.mDefaultAnimation.setStartOffset(this.getHideStartOffset());
        this.mDefaultAnimation.setDuration(this.getHideDuration());
        this.mDefaultAnimation.setAnimationListener((Animation.AnimationListener)new AutoHideAbleOZOverlayView$1(this));
    }

    public boolean getIsIgnoreAutoHide() {
        return this.mIsIgnoreAutoHide;
    }

    public boolean isAutoHideCancel() {
        return this.mIsAutoHideCancel;
    }

    public void setIgnoreAutoHide(boolean bl) {
        if (this.getIsIgnoreAutoHide() != bl) {
            this.mIsIgnoreAutoHide = bl;
            if (this.getIsIgnoreAutoHide()) {
                this.requestAutoHideCancel();
            }
        }
    }

    public void autoHide() {
        if (this.getView() != null && !this.getIsIgnoreAutoHide()) {
            this.mIsAutoHiding = true;
            this.getView().startAnimation(this.mDefaultAnimation);
        }
    }

    public void autoHideCancel() {
        this.mDefaultAnimation.reset();
        this.mIsAutoHideCancel = true;
        this.getView().clearAnimation();
        this.mIsAutoHideCancel = false;
    }

    public boolean isAutoHiding() {
        return this.mIsAutoHiding;
    }

    protected void OnHideAnimationStart() {
    }

    protected void OnHideAnimationRepeat() {
    }

    protected void OnHideAnimationEnd() {
        if (!this.isAutoHideCancel()) {
            this.hide();
        }
        if (this.getView() != null) {
            this.getView().setAlpha(1.0f);
        }
    }

    AlphaAnimation getHideAnimation() {
        return new AlphaAnimation(1.0f, 0.0f);
    }

    long getHideInterval() {
        return this.getHideStartOffset() + this.getHideDuration();
    }

    long getHideStartOffset() {
        return 3000L;
    }

    long getHideDuration() {
        return 2000L;
    }

    public void requestAutoHide() {
        if (this.isShowing() && this.isAutoHideEnable()) {
            this.mAutoHideHandler.sendEmptyMessage(0);
        }
    }

    public void requestAutoHideCancel() {
        if (this.isShowing() && this.isAutoHideEnable()) {
            this.mAutoHideHandler.removeMessages(0);
            this.mAutoHideHandler.removeMessages(2);
            this.mAutoHideHandler.sendEmptyMessage(1);
        }
    }

    public void requestAutoHideTimeReset() {
        if (this.isShowing() && this.isAutoHideEnable() && !this.hasRequestAutoHideTimeReset()) {
            this.mAutoHideHandler.sendEmptyMessage(2);
        }
    }

    public boolean hasRequestAutoHideTimeReset() {
        return this.mAutoHideHandler.hasMessages(2);
    }

    public void show() {
        if (this.isEnable()) {
            this.requestUpdateView();
            if (!this.isShowing()) {
                this.getView().setVisibility(0);
                this.getOZParent().requestLayout();
            }
            if (this.isAutoHideEnable()) {
                if (this.isAutoHiding()) {
                    this.requestAutoHideTimeReset();
                } else {
                    this.requestAutoHide();
                }
            }
        }
    }

    public void hide() {
        super.hide();
        if (this.isAutoHideEnable() || this.isAutoHiding()) {
            this.mAutoHideHandler.removeMessages(0);
            this.mAutoHideHandler.removeMessages(1);
            this.mAutoHideHandler.removeMessages(2);
            if (this.isAutoHiding()) {
                this.autoHideCancel();
            }
        }
    }

    static /* synthetic */ boolean access$102(AutoHideAbleOZOverlayView autoHideAbleOZOverlayView, boolean bl) {
        autoHideAbleOZOverlayView.mIsAutoHiding = bl;
        return autoHideAbleOZOverlayView.mIsAutoHiding;
    }
}

