package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class UnreadCountJSON extends AcmsCommonJSON {


    public ArrayList<ChatMessageDto> chatMessageDtoArrayList;

    public UnreadCountJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // メッセージ情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }
        HashMap<Integer, Integer> existShopMmeberMap = new HashMap<Integer, Integer>();
        JSONArray unreadCountList = json.getJSONArray(ABookCommConstants.KEY.BODY);
        if (unreadCountList == null) { return; }
        chatMessageDtoArrayList = new ArrayList<ChatMessageDto>();
        for (int listCount = 0; listCount < unreadCountList.length(); listCount++) {
            ChatMessageDto chatMessageDto = new ChatMessageDto();

            JSONObject messageInfoJSON = unreadCountList.getJSONObject(listCount);
            if (messageInfoJSON == null) { continue; }
            chatMessageDto.chatMessageId = messageInfoJSON.getInt(ABookCommConstants.KEY.MESSAGE_ID);
            chatMessageDto.unreadCount = messageInfoJSON.getInt(ABookCommConstants.KEY.UNREAD_COUNT);
            chatMessageDtoArrayList.add(chatMessageDto);
        }
    }
}

