package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.abook.abv.bl.acms.type.InstallType;

/**
 * ユーザ認証（２回目以降）用のパラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class EnterpriseLoginParameters extends AbstractAcmsLoginParameters {
	/**
	 * アプリのインストールタイプです。
	 * @since 1.0.0
	 */
	private InstallType installType;
	
	/**
	 * {@link EnterpriseLoginParameters} クラスのインスタンスを初期化します。
	 * @param loginId ユーザのログインIDです。半角英数字と'_'、'-'のみ使えます。
	 * @param memberPassword ユーザのパスワードです。半角英数字と'_'、'-'のみ使えます。
	 * @param appId アプリケーションIDです。
	 * @param appVersion アプリケーションの現在バージョンです。
	 * @param deviceTypeId 端末タイプです。
	 * @param deviceToken デバイストークンです。
	 * @param ma 端末のMACアドレスです。 
	 * @throws IllegalArgumentException 引数のどれかが半角英数字と'_'、'-'ではありません。
	 * @since 1.0.0
	 */
	public EnterpriseLoginParameters(String loginId, String memberPassword, int appId, String appVersion
			, int deviceTypeId, String deviceToken, String ma, InstallType installType)
			throws IllegalArgumentException {
		super(loginId, memberPassword, appId, appVersion, deviceTypeId, deviceToken, ma);

		if (installType == null) {
			throw new IllegalArgumentException("argument installType not allowed null or white space.");
		}
		this.installType = installType;
	}

	/**
	 * アプリのインストールタイプを取得します。
	 * @return アプリのインストールタイプです。
	 * @since 1.0.0
	 */
	public int getInstallType() {
		return installType.type();
	}
}
