package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.abook.abv.bl.acms.type.ContentZipType;

/**
 * コンテンツダウンロード用のパラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class GetContentParameters extends AcmsContentParameters {
	private ContentZipType downloadContentType;
	private String productId;
	private String purchaseToken;
	private String account;

	public String loginId;
	
	/**
	 * {@link GetContentParameters} のインスタンスを初期化します。
	 * @param contentId ダウンロードするコンテンツのIDです。
	 * @param sid ログインした時のセッションIDです。
	 * @param downloadContentType ダウンロードするZIPファイルのタイプです。
	 * @since 1.0.0
	 */
	public GetContentParameters(long contentId, String sid, ContentZipType downloadContentType) {
		super(sid, contentId);

		this.downloadContentType = downloadContentType;
	}
	
	/**
	 * 決済用コンストラクタ(productId, purchaseTokenをパラメータに追加）
	 * 
	 * @param contentId
	 * @param sid
	 * @param downloadContentType
	 * @param productId
	 * @param purchaseToken
	 */
	public GetContentParameters(long contentId, String sid, ContentZipType downloadContentType, String productId, String purchaseToken) {
		super(sid, contentId);

		this.downloadContentType = downloadContentType;
		this.productId = productId;
		this.purchaseToken = purchaseToken;
	}
	
	/**
	 * 決済用コンストラクタ(Googleアカウントをパラメータに追加）
	 * 
	 * @param contentId
	 * @param sid
	 * @param downloadContentType
	 * @param account
	 */
	public GetContentParameters(long contentId, String sid, ContentZipType downloadContentType, String account) {
		super(sid, contentId);

		this.downloadContentType = downloadContentType;
		this.account = account;
	}

	/**
	 * ダウンロードするZIPファイルのタイプを返します。
	 * @return　ダウンロードするZIPファイルのタイプです。
	 * @since 1.0.0
	 */
	public ContentZipType getContentType() {
		return downloadContentType;
	}

	public String getProductId() {
		return productId;
	}

	public String getPurchaseToken() {
		return purchaseToken;
	}

	public String getAccount() {
		return account;
	}
}
