package jp.agentec.abook.abv.bl.common.exception;

/**
 * UIに渡す例外です。{@link ABVException#getCode()} を呼び出して、戻り値のコードをみて、適切なエラーメッセージ（多言語）を用意してください。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ABVException extends Exception {
	private static final long serialVersionUID = 8288183644463348579L;
	
	private ABVExceptionCode code;
	
	/**
	 * {@link ABVException} クラスのインスタンスを初期化します。
	 * @param code 例外内容を示すコードです。
	 * @since 1.0.0
	 */
	public ABVException(ABVExceptionCode code) {
		super();
		this.code = code;
	}
	
	/**
	 * {@link ABVException} クラスのインスタンスを初期化します。
	 * @param code 例外内容を示すコードです。
	 * @param message 例外内容の補足です。
	 * @since 1.0.0
	 */
	public ABVException(ABVExceptionCode code, String message) {
		super(message);
		this.code = code;
	}
	
	/**
	 * {@link ABVException} クラスのインスタンスを初期化します。
	 * @param code 例外内容を示すコードです。
	 * @param cause 例外の原因です。
	 * @since 1.0.0
	 */
	public ABVException(ABVExceptionCode code, Throwable cause) {
		super(cause);
		this.code = code;
	}
	
	/**
	 * {@link ABVException} クラスのインスタンスを初期化します。
	 * @param code 例外内容を示すコードです。
	 * @param message 例外内容の補足です。
	 * @param cause 例外の原因です。
	 * @since 1.0.0
	 */
	public ABVException(ABVExceptionCode code, String message, Throwable cause) {
		super(message, cause);
		this.code = code;
	}
	
	/**
	 * 例外内容を示すコードを返します。このコードをみて、適切なエラーメッセージ（多言語）を用意してください。
	 * @return 例外内容を示すコードです。
	 * @since 1.0.0
	 */
	public ABVExceptionCode getCode() {
		return code;
	}
	
	@Override
	public String toString() {
		return String.format("%s: code: %s, message: %s", getClass().getName(), code.toString(), getMessage());
	}
}
